/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParseException;

public class HeaderTokenizer {
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    private static final Token EOF = new Token(-4, null);
    private String header;
    private String delimiters;
    private boolean skipComments;
    private int pos = 0;
    private int next = 0;
    private int peek = 0;
    private int maxPos;

    public HeaderTokenizer(String header, String delimiters, boolean skipComments) {
        this.header = header == null ? "" : header;
        this.delimiters = delimiters;
        this.skipComments = skipComments;
        this.peek = 0;
        this.next = 0;
        this.pos = 0;
        this.maxPos = header.length();
    }

    public HeaderTokenizer(String header, String delimiters) {
        this(header, delimiters, true);
    }

    public HeaderTokenizer(String header) {
        this(header, RFC822, true);
    }

    public Token next() throws ParseException {
        this.pos = this.next;
        Token token = this.token();
        this.peek = this.next = this.pos;
        return token;
    }

    public Token peek() throws ParseException {
        this.pos = this.peek;
        Token token = this.token();
        this.peek = this.pos;
        return token;
    }

    public String getRemainder() {
        return this.header.substring(this.next);
    }

    private Token token() throws ParseException {
        int start;
        if (this.pos >= this.maxPos) {
            return EOF;
        }
        if (this.skipWhitespace() == -4) {
            return EOF;
        }
        boolean needsFilter = false;
        char c = this.header.charAt(this.pos);
        while (c == '(') {
            start = ++this.pos;
            int parenCount = 1;
            while (parenCount > 0 && this.pos < this.maxPos) {
                c = this.header.charAt(this.pos);
                if (c == '\\') {
                    ++this.pos;
                    needsFilter = true;
                } else if (c == '\r') {
                    needsFilter = true;
                } else if (c == '(') {
                    ++parenCount;
                } else if (c == ')') {
                    --parenCount;
                }
                ++this.pos;
            }
            if (parenCount != 0) {
                throw new ParseException("Illegal comment");
            }
            if (!this.skipComments) {
                String ret = needsFilter ? this.filter(this.header, start, this.pos - 1) : this.header.substring(start, this.pos - 1);
                return new Token(-3, ret);
            }
            if (this.skipWhitespace() == -4) {
                return EOF;
            }
            c = this.header.charAt(this.pos);
        }
        if (c == '\"') {
            start = ++this.pos;
            while (this.pos < this.maxPos) {
                c = this.header.charAt(this.pos);
                if (c == '\\') {
                    ++this.pos;
                    needsFilter = true;
                } else if (c == '\r') {
                    needsFilter = true;
                } else if (c == '\"') {
                    ++this.pos;
                    String ret = needsFilter ? this.filter(this.header, start, this.pos - 1) : this.header.substring(start, this.pos - 1);
                    return new Token(-2, ret);
                }
                ++this.pos;
            }
            throw new ParseException("Illegal quoted string");
        }
        if (c < ' ' || c >= '\u007f' || this.delimiters.indexOf(c) >= 0) {
            ++this.pos;
            char[] chars = new char[]{c};
            return new Token(c, new String(chars));
        }
        start = this.pos;
        while (this.pos < this.maxPos && (c = this.header.charAt(this.pos)) >= ' ' && c < '\u007f' && c != '(' && c != ' ' && c != '\"' && this.delimiters.indexOf(c) < 0) {
            ++this.pos;
        }
        return new Token(-1, this.header.substring(start, this.pos));
    }

    private int skipWhitespace() {
        while (this.pos < this.maxPos) {
            char c = this.header.charAt(this.pos);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                return this.pos;
            }
            ++this.pos;
        }
        return -4;
    }

    private String filter(String s, int start, int end) {
        StringBuffer buffer = new StringBuffer();
        boolean backslash = false;
        boolean cr = false;
        for (int i = start; i < end; ++i) {
            char c = s.charAt(i);
            if (c == '\n' && cr) {
                cr = false;
                continue;
            }
            cr = false;
            if (!backslash) {
                if (c == '\\') {
                    backslash = true;
                    continue;
                }
                if (c == '\r') {
                    cr = true;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
            backslash = false;
        }
        return buffer.toString();
    }

    public static class Token {
        public static final int ATOM = -1;
        public static final int QUOTEDSTRING = -2;
        public static final int COMMENT = -3;
        public static final int EOF = -4;
        private int type;
        private String value;

        public Token(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

