/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Map;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XMSelection;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.awt.XSettings;
import sun.util.logging.PlatformLogger;

class XAWTXSettings
extends XSettings
implements XMSelectionListener {
    private final XAtom xSettingsPropertyAtom = XAtom.get("_XSETTINGS_SETTINGS");
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XAWTXSettings");
    public static final long MAX_LENGTH = 1000000L;
    XMSelection settings;

    public XAWTXSettings() {
        this.initXSettings();
    }

    void initXSettings() {
        if (log.isLoggable(500)) {
            log.fine("Initializing XAWT XSettings");
        }
        this.settings = new XMSelection("_XSETTINGS");
        this.settings.addSelectionListener(this);
        this.initPerScreenXSettings();
    }

    void dispose() {
        this.settings.removeSelectionListener(this);
    }

    @Override
    public void ownerDeath(int screen, XMSelection sel, long deadOwner) {
        if (log.isLoggable(500)) {
            log.fine("Owner " + deadOwner + " died for selection " + sel + " screen " + screen);
        }
    }

    @Override
    public void ownerChanged(int screen, XMSelection sel, long newOwner, long data, long timestamp) {
        if (log.isLoggable(500)) {
            log.fine("New Owner " + newOwner + " for selection = " + sel + " screen " + screen);
        }
    }

    @Override
    public void selectionChanged(int screen, XMSelection sel, long owner, XPropertyEvent event) {
        log.fine("Selection changed on sel " + sel + " screen = " + screen + " owner = " + owner + " event = " + event);
        this.updateXSettings(screen, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initPerScreenXSettings() {
        if (log.isLoggable(500)) {
            log.fine("Updating Per XSettings changes");
        }
        Map updatedSettings = null;
        XToolkit.awtLock();
        try {
            long display = XToolkit.getDisplay();
            int screen = (int)XlibWrapper.DefaultScreen(display);
            updatedSettings = this.getUpdatedSettings(this.settings.getOwner(screen));
        }
        finally {
            XToolkit.awtUnlock();
        }
        ((XToolkit)Toolkit.getDefaultToolkit()).parseXSettings(0, updatedSettings);
    }

    private void updateXSettings(int screen, long owner) {
        final Map updatedSettings = this.getUpdatedSettings(owner);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((XToolkit)Toolkit.getDefaultToolkit()).parseXSettings(0, updatedSettings);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getUpdatedSettings(long owner) {
        if (log.isLoggable(500)) {
            log.fine("owner =" + owner);
        }
        if (0L == owner) {
            return null;
        }
        Map settings = null;
        try {
            WindowPropertyGetter getter = new WindowPropertyGetter(owner, this.xSettingsPropertyAtom, 0L, 1000000L, false, this.xSettingsPropertyAtom.getAtom());
            try {
                byte[] array;
                int status = getter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (status != 0 || getter.getData() == 0L) {
                    if (log.isLoggable(500)) {
                        log.fine("OH OH : getter failed  status = " + status);
                    }
                    settings = null;
                }
                long ptr = getter.getData();
                if (log.isLoggable(500)) {
                    log.fine("noItems = " + getter.getNumberOfItems());
                }
                if ((array = Native.toBytes(ptr, getter.getNumberOfItems())) != null) {
                    settings = this.update(array);
                }
            }
            finally {
                getter.dispose();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }
}

