/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.ArrayList;
import org.havi.ui.event.HBackgroundImageEvent;
import org.havi.ui.event.HBackgroundImageListener;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.URLImageSource;

public class HBackgroundImage
implements ImageObserver {
    private ImageProducer producer;
    private Image img;
    private ArrayList listeners = new ArrayList();

    public HBackgroundImage(String filename) {
        this.producer = new FileImageSource(filename);
        this.img = Toolkit.getDefaultToolkit().createImage(this.producer);
    }

    public HBackgroundImage(byte[] pixels) {
        this.producer = new ByteArrayImageSource(pixels);
        this.img = Toolkit.getDefaultToolkit().createImage(this.producer);
    }

    public HBackgroundImage(URL contents) {
        this.producer = new URLImageSource(contents);
        this.img = Toolkit.getDefaultToolkit().createImage(this.producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(HBackgroundImageListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
        Toolkit.getDefaultToolkit().prepareImage(this.img, -1, -1, this);
    }

    public int getHeight() {
        return this.img.getHeight(null);
    }

    public int getWidth() {
        return this.img.getWidth(null);
    }

    public void flush() {
        this.img.flush();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        switch (infoflags) {
            case 16: 
            case 32: {
                this.notifyListeners(new HBackgroundImageEvent(this, 1));
                return false;
            }
            case 64: {
                this.notifyListeners(new HBackgroundImageEvent(this, 4));
                return false;
            }
            case 128: {
                this.notifyListeners(new HBackgroundImageEvent(this, 3));
                return false;
            }
        }
        return true;
    }

    protected Image getImage() {
        return this.img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(HBackgroundImageEvent event) {
        ArrayList list;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (ArrayList)this.listeners.clone();
            this.listeners.clear();
        }
        for (int i = 0; i < list.size(); ++i) {
            HBackgroundImageListener listener = (HBackgroundImageListener)list.get(i);
            if (event.getID() == 1) {
                listener.imageLoaded(event);
                continue;
            }
            listener.imageLoadFailed(event);
        }
    }
}

