/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.provider.beanshell.GlyphGutter;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceModel;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PlainSourceView
extends JScrollPane
implements ScriptSourceView,
DocumentListener {
    private final ScriptSourceModel model;
    private JTextArea ta;
    private GlyphGutter gg;
    private int linecount;
    private boolean isModified = false;

    public PlainSourceView(ScriptSourceModel model) {
        this.model = model;
        this.initUI();
        model.setView(this);
    }

    public void clear() {
        this.ta.setText("");
    }

    public void update() {
        this.ta.getDocument().removeDocumentListener(this);
        if (!this.isModified) {
            int pos = this.ta.getCaretPosition();
            this.ta.setText(this.model.getText());
            try {
                this.ta.setCaretPosition(pos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            int line = this.ta.getLineStartOffset(this.model.getCurrentPosition());
            Rectangle rect = this.ta.modelToView(line);
            this.ta.scrollRectToVisible(rect);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gg.repaint();
        this.ta.getDocument().addDocumentListener(this);
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean value) {
        this.isModified = value;
    }

    private void initUI() {
        this.ta = new JTextArea();
        this.ta.setRows(15);
        this.ta.setColumns(40);
        this.ta.setLineWrap(false);
        this.ta.insert(this.model.getText(), 0);
        this.linecount = this.ta.getLineCount();
        this.gg = new GlyphGutter(this);
        this.setViewportView(this.ta);
        this.setRowHeaderView(this.gg);
        this.ta.getDocument().addDocumentListener(this);
    }

    public void insertUpdate(DocumentEvent e) {
        this.doChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.doChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.doChanged();
    }

    private void doChanged() {
        this.isModified = true;
        if (this.linecount != this.ta.getLineCount()) {
            this.gg.update();
            this.linecount = this.ta.getLineCount();
        }
    }

    public String getText() {
        return this.ta.getText();
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public int getCurrentPosition() {
        return this.model.getCurrentPosition();
    }
}

