/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.actions.ActionManager;
import org.openide.actions.Bundle;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JMenuPlus;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ToolsAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = 4906417339959070129L;
    private static ScheduledFuture<G> taskGl;

    static final G gl() {
        return ToolsAction.gl(Long.MAX_VALUE);
    }

    static final G gl(long l) {
        ToolsAction.initGl();
        while (true) {
            try {
                return (G)taskGl.get(l, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                return null;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Exception exception) {
                taskGl = null;
                throw new IllegalStateException(exception);
            }
            break;
        }
    }

    private static synchronized void initGl() {
        if (taskGl == null) {
            taskGl = RequestProcessor.getDefault().schedule((Callable)new G(), 0L, TimeUnit.MILLISECONDS);
        }
    }

    protected void initialize() {
        super.initialize();
    }

    public String getName() {
        return ToolsAction.getActionName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ToolsAction.class);
    }

    public JMenuItem getMenuPresenter() {
        return new Inline((Action)((Object)this));
    }

    public JMenuItem getPopupPresenter() {
        return new Popup((Action)((Object)this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    private static String getActionName() {
        return NbBundle.getMessage(ToolsAction.class, (String)"CTL_Tools");
    }

    static List<Action> getToolActions() {
        ActionManager actionManager = ActionManager.getDefault();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(actionManager.getContextActions()));
        String string = arrayList.isEmpty() ? null : "";
        for (Lookup.Item item : ToolsAction.gl().result.allItems()) {
            Action action = (Action)item.getInstance();
            if (action == null) continue;
            String string2 = item.getId().replaceFirst("[^/]*$", "");
            if (string != null && !string.equals(string2)) {
                arrayList.add(null);
            }
            string = string2;
            arrayList.add(action);
        }
        return arrayList;
    }

    private static List<JMenuItem> generate(Action action, boolean bl) {
        List<Action> list = ToolsAction.getToolActions();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(list.size());
        boolean bl2 = false;
        boolean bl3 = false;
        Lookup lookup = action instanceof Lookup.Provider ? ((Lookup.Provider)action).getLookup() : null;
        for (Action action2 : list) {
            JMenuItem jMenuItem;
            if (lookup != null && action2 instanceof ContextAwareAction) {
                action2 = ((ContextAwareAction)action2).createContextAwareInstance(lookup);
            }
            if (action2 == null) {
                if (!bl3) continue;
                bl2 = true;
                continue;
            }
            boolean bl4 = action2 instanceof Presenter.Popup;
            boolean bl5 = action2 instanceof Presenter.Menu;
            if (!(bl && bl5 || !bl && bl4) && (bl5 || bl4) || !action2.isEnabled()) continue;
            if (bl && bl5) {
                jMenuItem = ((Presenter.Menu)action2).getMenuPresenter();
            } else if (!bl && bl4) {
                jMenuItem = ((Presenter.Popup)action2).getPopupPresenter();
            } else {
                if (bl5 || bl4) continue;
                jMenuItem = new JMenuItem();
                Actions.connect((JMenuItem)jMenuItem, (Action)action2, (!bl ? 1 : 0) != 0);
            }
            if (bl2) {
                arrayList.add(null);
                bl2 = false;
            }
            arrayList.add(jMenuItem);
            bl3 = true;
        }
        return arrayList;
    }

    @Deprecated
    public static void setModel(Model model) {
        throw new SecurityException();
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Lookup.Provider {
        private ToolsAction delegate;
        private Lookup lookup;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(ToolsAction toolsAction, Lookup lookup) {
            this.delegate = toolsAction;
            this.lookup = lookup;
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public JMenuItem getMenuPresenter() {
            return new Inline(this);
        }

        public JMenuItem getPopupPresenter() {
            return new Popup(this);
        }
    }

    private static class G
    implements PropertyChangeListener,
    LookupListener,
    Callable<G> {
        public static final String PROP_STATE = "actionsState";
        private int timestamp = 1;
        private Action[] actions = null;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);
        Lookup.Result<Action> result;

        @Override
        public G call() {
            ActionManager actionManager = ActionManager.getDefault();
            actionManager.addPropertyChangeListener(this);
            this.result = Lookups.forPath((String)"UI/ToolActions").lookupResult(Action.class);
            this.result.addLookupListener((LookupListener)this);
            this.actionsListChanged();
            return this;
        }

        public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }

        protected final void firePropertyChange(String string, Object object, Object object2) {
            this.supp.firePropertyChange(string, object, object2);
        }

        private void actionsListChanged() {
            Object object;
            ++this.timestamp;
            Action[] actionArray = this.actions;
            if (actionArray != null) {
                for (int i = 0; i < actionArray.length; ++i) {
                    object = actionArray[i];
                    if (object == null) continue;
                    object.removePropertyChangeListener(this);
                }
            }
            ActionManager actionManager = ActionManager.getDefault();
            object = new ArrayList<SystemAction>();
            object.addAll(Arrays.asList(actionManager.getContextActions()));
            object.addAll(this.result.allInstances());
            actionArray = object.toArray(new Action[0]);
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                if (action == null) continue;
                action.addPropertyChangeListener(this);
            }
            this.actions = actionArray;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        private void actionStateChanged() {
            ++this.timestamp;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("contextActions")) {
                this.actionsListChanged();
            } else if (string.equals("enabled")) {
                this.actionStateChanged();
            }
        }

        private boolean isPopupEnabled(Action action) {
            boolean bl = false;
            Action[] actionArray = this.actions;
            Lookup lookup = action instanceof Lookup.Provider ? ((Lookup.Provider)action).getLookup() : null;
            for (int i = 0; i < actionArray.length; ++i) {
                Action action2;
                if (actionArray[i] == null) continue;
                if (lookup != null && actionArray[i] instanceof ContextAwareAction) {
                    action2 = ((ContextAwareAction)actionArray[i]).createContextAwareInstance(lookup);
                    if (action2 == null) {
                        throw new IllegalStateException("createContextAwareInstance for " + actionArray[i] + " returned null!");
                    }
                } else {
                    action2 = actionArray[i];
                }
                if (!action2.isEnabled()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private int getTimestamp() {
            return this.timestamp;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.actionsListChanged();
        }
    }

    private static final class Popup
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private JMenu menu = new MyMenu();
        private Action toolsAction;

        public Popup(Action action) {
            this.toolsAction = action;
            HelpCtx.setHelpIDString((JComponent)this.menu, (String)ToolsAction.class.getName());
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            JComponent[] jComponentArray2;
            if (ToolsAction.gl().isPopupEnabled(this.toolsAction)) {
                JMenuItem[] jMenuItemArray = new JMenuItem[1];
                jComponentArray2 = jMenuItemArray;
                jMenuItemArray[0] = this.menu;
            } else {
                jComponentArray2 = new JMenuItem[]{};
            }
            return jComponentArray2;
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }

        private class MyMenu
        extends JMenuPlus
        implements PopupMenuListener {
            private JPopupMenu lastPopup;

            MyMenu() {
                super(ToolsAction.getActionName());
                this.lastPopup = null;
            }

            public JPopupMenu getPopupMenu() {
                JPopupMenu jPopupMenu = super.getPopupMenu();
                this.fillSubmenu(jPopupMenu);
                return jPopupMenu;
            }

            private void fillSubmenu(JPopupMenu jPopupMenu) {
                if (this.lastPopup == null) {
                    jPopupMenu.addPopupMenuListener(this);
                    this.lastPopup = jPopupMenu;
                    this.removeAll();
                    for (Component component : ToolsAction.generate(Popup.this.toolsAction, false)) {
                        if (component == null) {
                            this.addSeparator();
                            continue;
                        }
                        this.add(component);
                    }
                    if (this.getMenuComponentCount() == 0) {
                        Component component;
                        component = new JMenuItem(NbBundle.getMessage(ToolsAction.class, (String)"CTL_EmptySubMenu"));
                        ((JMenuItem)component).setEnabled(false);
                        this.add((JMenuItem)component);
                    }
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.lastPopup.removePopupMenuListener(this);
                this.lastPopup = null;
            }
        }
    }

    private static final class Inline
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private int timestamp = 0;
        private Action toolsAction;

        Inline(Action action) {
            this.toolsAction = action;
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            G g = ToolsAction.gl(50L);
            if (g == null) {
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(Bundle.LAB_ToolsActionInitializing());
                jMenuItem.setEnabled(false);
                return new JMenuItem[]{jMenuItem};
            }
            if (this.timestamp == g.getTimestamp()) {
                return jComponentArray;
            }
            List list = ToolsAction.generate(this.toolsAction, true);
            this.timestamp = ToolsAction.gl().getTimestamp();
            return list.toArray(new JMenuItem[list.size()]);
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }
    }

    @Deprecated
    public static interface Model {
        public SystemAction[] getActions();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

