/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.PSState;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;

public class PSGenerator {
    public static final int DEFAULT_LANGUAGE_LEVEL = 3;
    public static final Object ATEND = DSCConstants.ATEND;
    public static final char LF = '\n';
    private OutputStream out;
    private int psLevel = 3;
    private boolean commentsEnabled = true;
    private Stack graphicsStateStack = new Stack();
    private PSState currentState;
    private DecimalFormat df3 = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat df5 = new DecimalFormat("0.#####", new DecimalFormatSymbols(Locale.US));
    private StringBuffer tempBuffer = new StringBuffer(256);
    private ResourceTracker resTracker = new ResourceTracker();

    public PSGenerator(OutputStream out) {
        this.out = out;
        this.currentState = new PSState();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPSLevel() {
        return this.psLevel;
    }

    public void setPSLevel(int level) {
        this.psLevel = level;
    }

    public Source resolveURI(String uri) {
        return new StreamSource(uri);
    }

    public final void newLine() throws IOException {
        this.out.write(10);
    }

    public String formatDouble(double value) {
        return this.df3.format(value);
    }

    public String formatDouble5(double value) {
        return this.df5.format(value);
    }

    public void write(String cmd) throws IOException {
        this.out.write(cmd.getBytes("US-ASCII"));
    }

    public void writeln(String cmd) throws IOException {
        this.write(cmd);
        this.newLine();
    }

    public void commentln(String comment) throws IOException {
        if (this.commentsEnabled) {
            this.writeln(comment);
        }
    }

    public void writeByteArr(byte[] cmd) throws IOException {
        this.out.write(cmd);
        this.newLine();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public static final void escapeChar(char c, StringBuffer target) {
        switch (c) {
            case '\n': {
                target.append("\\n");
                break;
            }
            case '\r': {
                target.append("\\r");
                break;
            }
            case '\t': {
                target.append("\\t");
                break;
            }
            case '\b': {
                target.append("\\b");
                break;
            }
            case '\f': {
                target.append("\\f");
                break;
            }
            case '\\': {
                target.append("\\\\");
                break;
            }
            case '(': {
                target.append("\\(");
                break;
            }
            case ')': {
                target.append("\\)");
                break;
            }
            default: {
                if (c > '\u00ff') {
                    target.append('?');
                    break;
                }
                if (c < ' ' || c > '\u007f') {
                    target.append('\\');
                    target.append((char)(48 + (c >> 6)));
                    target.append((char)(48 + (c >> 3) % 8));
                    target.append((char)(48 + c % 8));
                    break;
                }
                target.append(c);
            }
        }
    }

    public static final String convertStringToDSC(String text) {
        return PSGenerator.convertStringToDSC(text, false);
    }

    public static final String convertRealToDSC(float value) {
        return Float.toString(value);
    }

    public static final String convertStringToDSC(String text, boolean forceParentheses) {
        if (text == null || text.length() == 0) {
            return "()";
        }
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        if (text.indexOf(32) >= 0 || forceParentheses) {
            sb.append('(');
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                PSGenerator.escapeChar(c, sb);
                ++i;
            }
            sb.append(')');
            return sb.toString();
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            PSGenerator.escapeChar(c, sb);
            ++i;
        }
        return sb.toString();
    }

    public void writeDSCComment(String name) throws IOException {
        this.writeln("%%" + name);
    }

    public void writeDSCComment(String name, Object param) throws IOException {
        this.writeDSCComment(name, new Object[]{param});
    }

    public void writeDSCComment(String name, Object[] params) throws IOException {
        this.tempBuffer.setLength(0);
        this.tempBuffer.append("%%");
        this.tempBuffer.append(name);
        if (params != null && params.length > 0) {
            this.tempBuffer.append(": ");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    this.tempBuffer.append(" ");
                }
                if (params[i] instanceof String) {
                    this.tempBuffer.append(PSGenerator.convertStringToDSC((String)params[i]));
                } else if (params[i] == DSCConstants.ATEND) {
                    this.tempBuffer.append(DSCConstants.ATEND);
                } else if (params[i] instanceof Double) {
                    this.tempBuffer.append(this.df3.format(params[i]));
                } else if (params[i] instanceof Number) {
                    this.tempBuffer.append(params[i].toString());
                } else if (params[i] instanceof Date) {
                    SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    this.tempBuffer.append(PSGenerator.convertStringToDSC(datef.format((Date)params[i])));
                } else if (params[i] instanceof PSResource) {
                    this.tempBuffer.append(((PSResource)params[i]).getResourceSpecification());
                } else {
                    throw new IllegalArgumentException("Unsupported parameter type: " + params[i].getClass().getName());
                }
                ++i;
            }
        }
        this.writeln(this.tempBuffer.toString());
    }

    public void saveGraphicsState() throws IOException {
        this.writeln("gsave");
        PSState state = new PSState(this.currentState, false);
        this.graphicsStateStack.push(this.currentState);
        this.currentState = state;
    }

    public boolean restoreGraphicsState() throws IOException {
        if (this.graphicsStateStack.size() > 0) {
            this.writeln("grestore");
            this.currentState = (PSState)this.graphicsStateStack.pop();
            return true;
        }
        return false;
    }

    public PSState getCurrentState() {
        return this.currentState;
    }

    public void concatMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        AffineTransform at = new AffineTransform(a, b, c, d, e, f);
        this.concatMatrix(at);
    }

    public void concatMatrix(double[] matrix) throws IOException {
        this.concatMatrix(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public void concatMatrix(AffineTransform at) throws IOException {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.getCurrentState().concatMatrix(at);
        this.writeln("[" + this.formatDouble5(matrix[0]) + " " + this.formatDouble5(matrix[1]) + " " + this.formatDouble5(matrix[2]) + " " + this.formatDouble5(matrix[3]) + " " + this.formatDouble5(matrix[4]) + " " + this.formatDouble5(matrix[5]) + "] concat");
    }

    public void defineRect(double x, double y, double w, double h) throws IOException {
        this.writeln(this.formatDouble(x) + " " + this.formatDouble(y) + " " + this.formatDouble(w) + " " + this.formatDouble(h) + " re");
    }

    public void useLineCap(int linecap) throws IOException {
        if (this.getCurrentState().useLineCap(linecap)) {
            this.writeln(linecap + " setlinecap");
        }
    }

    public void useLineWidth(double width) throws IOException {
        if (this.getCurrentState().useLineWidth(width)) {
            this.writeln(this.formatDouble(width) + " setlinewidth");
        }
    }

    public void useDash(String pattern) throws IOException {
        if (pattern == null) {
            pattern = "[] 0";
        }
        if (this.getCurrentState().useDash(pattern)) {
            this.writeln(pattern + " setdash");
        }
    }

    public void useRGBColor(Color col) throws IOException {
        this.useColor(col);
    }

    public void useColor(Color col) throws IOException {
        if (this.getCurrentState().useColor(col)) {
            this.writeln(this.convertColorToPS(col));
        }
    }

    private String convertColorToPS(Color col) {
        StringBuffer p = new StringBuffer();
        float[] comps = col.getColorComponents(null);
        if (col.getColorSpace().getType() == 5) {
            boolean same;
            boolean bl = same = comps[0] == comps[1] && comps[0] == comps[2];
            if (same) {
                p.append(this.formatDouble(comps[0]));
            } else {
                int i = 0;
                while (i < col.getColorSpace().getNumComponents()) {
                    if (i > 0) {
                        p.append(" ");
                    }
                    p.append(this.formatDouble(comps[i]));
                    ++i;
                }
            }
            if (same) {
                p.append(" setgray");
            } else {
                p.append(" setrgbcolor");
            }
        } else if (col.getColorSpace().getType() == 9) {
            int i = 0;
            while (i < col.getColorSpace().getNumComponents()) {
                if (i > 0) {
                    p.append(" ");
                }
                p.append(this.formatDouble(comps[i]));
                ++i;
            }
            p.append(" setcmykcolor");
        } else {
            p.append(this.formatDouble(comps[0]));
            p.append(" setgray");
        }
        return p.toString();
    }

    public void useFont(String name, float size) throws IOException {
        if (this.getCurrentState().useFont(name, size)) {
            this.writeln(name + " " + this.formatDouble(size) + " F");
        }
    }

    public ResourceTracker getResourceTracker() {
        return this.resTracker;
    }

    public void setResourceTracker(ResourceTracker resTracker) {
        this.resTracker = resTracker;
    }

    public void notifyStartNewPage() {
        this.getResourceTracker().notifyStartNewPage();
    }

    public void notifyResourceUsage(PSResource res, boolean needed) {
        this.getResourceTracker().notifyResourceUsageOnPage(res);
    }

    public void writeResources(boolean pageLevel) throws IOException {
        this.getResourceTracker().writeResources(pageLevel, this);
    }

    public boolean isResourceSupplied(PSResource res) {
        return this.getResourceTracker().isResourceSupplied(res);
    }
}

