/*
 * Decompiled with CFR 0.152.
 */
package org.grails.exceptions.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.exceptions.reporting.StackTraceFilterer;

public class DefaultStackTraceFilterer
implements StackTraceFilterer {
    public static final String STACK_LOG_NAME = "StackTrace";
    public static final Log STACK_LOG = LogFactory.getLog((String)"StackTrace");
    private static final String[] DEFAULT_INTERNAL_PACKAGES = new String[]{"org.grails.plugin.resource.DevMode", "org.grails.", "org.codehaus.groovy.grails.", "gant.", "org.codehaus.groovy.runtime.", "org.codehaus.groovy.reflection.", "org.codehaus.groovy.ast.", "org.codehaus.gant.", "groovy.", "org.mortbay.", "org.apache.catalina.", "org.apache.coyote.", "org.apache.tomcat.", "net.sf.cglib.proxy.", "sun.", "java.lang.reflect.", "org.springframework.", "org.springsource.loaded.", "com.opensymphony.", "org.hibernate.", "javax.servlet."};
    private List<String> packagesToFilter = new ArrayList<String>();
    private boolean shouldFilter;
    private String cutOffPackage = null;

    public DefaultStackTraceFilterer() {
        this(!Boolean.getBoolean("grails.full.stacktrace"));
    }

    public DefaultStackTraceFilterer(boolean shouldFilter) {
        this.shouldFilter = shouldFilter;
        this.packagesToFilter.addAll(Arrays.asList(DEFAULT_INTERNAL_PACKAGES));
    }

    @Override
    public void addInternalPackage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Package name cannot be null");
        }
        this.packagesToFilter.add(name);
    }

    @Override
    public void setCutOffPackage(String cutOffPackage) {
        this.cutOffPackage = cutOffPackage;
    }

    @Override
    public Throwable filter(Throwable source, boolean recursive) {
        if (recursive) {
            for (Throwable current = source; current != null; current = current.getCause()) {
                current = this.filter(current);
            }
        }
        return this.filter(source);
    }

    @Override
    public Throwable filter(Throwable source) {
        if (this.shouldFilter) {
            StackTraceElement[] trace = source.getStackTrace();
            List<StackTraceElement> newTrace = this.filterTraceWithCutOff(trace, this.cutOffPackage);
            if (newTrace.isEmpty()) {
                newTrace = this.filterTraceWithCutOff(trace, null);
            }
            if (!newTrace.isEmpty()) {
                STACK_LOG.error((Object)"Full Stack Trace:", source);
                StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
                newTrace.toArray(clean);
                source.setStackTrace(clean);
            }
        }
        return source;
    }

    private List<StackTraceElement> filterTraceWithCutOff(StackTraceElement[] trace, String endPackage) {
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean foundGroovy = false;
        for (StackTraceElement stackTraceElement : trace) {
            String className = stackTraceElement.getClassName();
            String fileName = stackTraceElement.getFileName();
            if (!foundGroovy && fileName != null && fileName.endsWith(".groovy")) {
                foundGroovy = true;
            }
            if (endPackage != null && className.startsWith(endPackage) && foundGroovy) break;
            if (!this.isApplicationClass(className) || stackTraceElement.getLineNumber() <= -1) continue;
            newTrace.add(stackTraceElement);
        }
        return newTrace;
    }

    protected boolean isApplicationClass(String className) {
        for (String packageName : this.packagesToFilter) {
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setShouldFilter(boolean shouldFilter) {
        this.shouldFilter = shouldFilter;
    }
}

