/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.web.taglib;

import grails.artefact.TagLibrary;
import grails.compiler.ast.AnnotatedClassInjector;
import grails.compiler.ast.AstTransformer;
import grails.compiler.ast.GrailsArtefactClassInjector;
import groovy.lang.Closure;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.taglib.TagOutput;
import org.grails.taglib.encoder.OutputContextLookupHelper;

@AstTransformer
public class TagLibraryTransformer
implements GrailsArtefactClassInjector,
AnnotatedClassInjector {
    protected static final String GET_TAG_LIB_NAMESPACE_METHOD_NAME = "$getTagLibNamespace";
    public static Pattern TAGLIB_PATTERN = Pattern.compile(".+/grails-app/taglib/(.+)TagLib\\.groovy");
    private static final String ATTRS_ARGUMENT = "attrs";
    private static final String BODY_ARGUMENT = "body";
    private static final Parameter[] MAP_CLOSURE_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Map.class), "attrs"), new Parameter(new ClassNode(Closure.class), "body")};
    private static final Parameter[] CLOSURE_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Closure.class), "body")};
    private static final Parameter[] MAP_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Map.class), "attrs")};
    private static final Parameter[] MAP_CHARSEQUENCE_PARAMETERS = new Parameter[]{new Parameter(new ClassNode(Map.class), "attrs"), new Parameter(new ClassNode(CharSequence.class), "body")};
    private static final ClassNode TAG_OUTPUT_CLASS_NODE = new ClassNode(TagOutput.class);
    private static final VariableExpression ATTRS_EXPRESSION = new VariableExpression("attrs");
    private static final VariableExpression BODY_EXPRESSION = new VariableExpression("body");
    private static final MethodCallExpression CURRENT_OUTPUT_CONTEXT_METHOD_CALL = new MethodCallExpression((Expression)new ClassExpression(new ClassNode(OutputContextLookupHelper.class)), "lookupOutputContext", (Expression)ZERO_ARGS);
    private static final Expression NULL_EXPRESSION = new ConstantExpression(null);
    private static final String NAMESPACE_PROPERTY = "namespace";
    private static final ClassNode CLOSURE_CLASS_NODE = new ClassNode(Closure.class);

    public String[] getArtefactTypes() {
        return new String[]{this.getArtefactType(), "TagLibrary"};
    }

    protected String getArtefactType() {
        return "TagLib";
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, classNode);
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, classNode);
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, classNode);
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        Expression initialExpression;
        List<PropertyNode> tags = this.findTags(classNode);
        PropertyNode namespaceProperty = classNode.getProperty(NAMESPACE_PROPERTY);
        String namespace = "g";
        if (namespaceProperty != null && namespaceProperty.isStatic() && (initialExpression = namespaceProperty.getInitialExpression()) instanceof ConstantExpression) {
            namespace = initialExpression.getText();
        }
        this.addGetTagLibNamespaceMethod(classNode, namespace);
        MethodCallExpression tagLibraryLookupMethodCall = new MethodCallExpression((Expression)new VariableExpression("this", ClassHelper.make(TagLibrary.class)), "getTagLibraryLookup", (Expression)ZERO_ARGS);
        for (PropertyNode tag : tags) {
            String tagName = tag.getName();
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, tagName);
            this.addAttributesAndStringBodyMethod(classNode, tagName);
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, tagName, false);
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, tagName, true, false);
            this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, tagName, false, false);
        }
    }

    private void addGetTagLibNamespaceMethod(ClassNode classNode, String namespace) {
        ConstantExpression namespaceConstantExpression = new ConstantExpression((Object)namespace);
        ReturnStatement returnNamespaceStatement = new ReturnStatement((Expression)namespaceConstantExpression);
        MethodNode m = new MethodNode(GET_TAG_LIB_NAMESPACE_METHOD_NAME, 4, new ClassNode(String.class), Parameter.EMPTY_ARRAY, null, (Statement)returnNamespaceStatement);
        classNode.addMethod(m);
    }

    private void addAttributesAndStringBodyMethod(ClassNode classNode, String tagName) {
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        ArgumentListExpression constructorArgs = new ArgumentListExpression();
        constructorArgs.addExpression((Expression)BODY_EXPRESSION);
        arguments.addExpression((Expression)new CastExpression(ClassHelper.make(Map.class), (Expression)ATTRS_EXPRESSION)).addExpression((Expression)new ConstructorCallExpression(new ClassNode(TagOutput.ConstantClosure.class), (Expression)constructorArgs));
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), tagName, (Expression)arguments)));
        classNode.addMethod(new MethodNode(tagName, 1, GrailsASTUtils.OBJECT_CLASS_NODE, MAP_CHARSEQUENCE_PARAMETERS, null, (Statement)methodBody));
    }

    private void addAttributesAndBodyMethod(ClassNode classNode, MethodCallExpression tagLibraryLookupMethodCall, String tagName) {
        this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, tagName, true);
    }

    private void addAttributesAndBodyMethod(ClassNode classNode, MethodCallExpression tagLibraryLookupMethodCall, String tagName, boolean includeBody) {
        this.addAttributesAndBodyMethod(classNode, tagLibraryLookupMethodCall, tagName, includeBody, true);
    }

    private void addAttributesAndBodyMethod(ClassNode classNode, MethodCallExpression tagLibraryLookupMethodCall, String tagName, boolean includeBody, boolean includeAttrs) {
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)tagLibraryLookupMethodCall).addExpression((Expression)new MethodCallExpression((Expression)new VariableExpression("this"), GET_TAG_LIB_NAMESPACE_METHOD_NAME, (Expression)new ArgumentListExpression())).addExpression((Expression)new ConstantExpression((Object)tagName)).addExpression((Expression)(includeAttrs ? new CastExpression(ClassHelper.make(Map.class), (Expression)ATTRS_EXPRESSION) : new MapExpression())).addExpression((Expression)(includeBody ? BODY_EXPRESSION : NULL_EXPRESSION)).addExpression((Expression)CURRENT_OUTPUT_CONTEXT_METHOD_CALL);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(TAG_OUTPUT_CLASS_NODE), "captureTagOutput", (Expression)arguments)));
        if (includeBody && includeAttrs) {
            if (!this.methodExists(classNode, tagName, MAP_CLOSURE_PARAMETERS)) {
                classNode.addMethod(new MethodNode(tagName, 1, GrailsASTUtils.OBJECT_CLASS_NODE, MAP_CLOSURE_PARAMETERS, null, (Statement)methodBody));
            }
        } else if (includeAttrs && !includeBody) {
            if (!this.methodExists(classNode, tagName, MAP_PARAMETERS)) {
                classNode.addMethod(new MethodNode(tagName, 1, GrailsASTUtils.OBJECT_CLASS_NODE, MAP_PARAMETERS, null, (Statement)methodBody));
            }
        } else if (includeBody) {
            if (!this.methodExists(classNode, tagName, CLOSURE_PARAMETERS)) {
                classNode.addMethod(new MethodNode(tagName, 1, GrailsASTUtils.OBJECT_CLASS_NODE, CLOSURE_PARAMETERS, null, (Statement)methodBody));
            }
        } else if (!this.methodExists(classNode, tagName, Parameter.EMPTY_ARRAY)) {
            classNode.addMethod(new MethodNode(tagName, 1, GrailsASTUtils.OBJECT_CLASS_NODE, Parameter.EMPTY_ARRAY, null, (Statement)methodBody));
        }
    }

    private boolean methodExists(ClassNode classNode, String methodName, Parameter[] parameters) {
        return classNode.getMethod(methodName, parameters) != null;
    }

    private List<PropertyNode> findTags(ClassNode classNode) {
        ArrayList<PropertyNode> tags = new ArrayList<PropertyNode>();
        List properties = classNode.getProperties();
        ArrayList<PropertyNode> potentialAliases = new ArrayList<PropertyNode>();
        for (PropertyNode property : properties) {
            if (!property.isPublic()) continue;
            Expression initialExpression = property.getInitialExpression();
            if (initialExpression instanceof ClosureExpression) {
                ClosureExpression ce = (ClosureExpression)initialExpression;
                Parameter[] parameters = ce.getParameters();
                if (parameters.length > 2) continue;
                tags.add(property);
                property.setType(CLOSURE_CLASS_NODE);
                continue;
            }
            if (!(initialExpression instanceof VariableExpression)) continue;
            potentialAliases.add(property);
        }
        for (PropertyNode potentialAlias : potentialAliases) {
            VariableExpression pe = (VariableExpression)potentialAlias.getInitialExpression();
            String propertyName = pe.getName();
            PropertyNode property = classNode.getProperty(propertyName);
            if (property == null || !tags.contains(property)) continue;
            potentialAlias.setType(CLOSURE_CLASS_NODE);
            tags.add(potentialAlias);
        }
        return tags;
    }

    public boolean shouldInject(URL url) {
        return url != null && TAGLIB_PATTERN.matcher(url.getFile()).find();
    }
}

