/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Log;
import org.springsource.loaded.agent.SpringPlugin;

public class GlobalConfiguration {
    private static Logger log = Logger.getLogger(GlobalConfiguration.class.getName());
    public static final boolean fieldRewriting = true;
    public static boolean catchersOn = true;
    public static boolean fileSystemMonitoring = false;
    public static boolean logging = false;
    public static boolean verboseMode = false;
    public static boolean assertsMode = false;
    public static boolean explainMode = false;
    public static boolean allowSplitPackages = false;
    public static boolean isRuntimeLogging = false;
    public static boolean callsideRewritingOn = true;
    public static boolean cleanCache = false;
    public static boolean isCaching = false;
    public static boolean investigateSystemClassReflection = false;
    public static boolean rewriteAllSystemClasses = false;
    public static String profile = null;
    public static String cacheDir = null;
    public static final boolean logNonInterceptedReflectiveCalls = false;
    public static String[] jarsToWatch = null;
    public static final boolean isProfiling = false;
    public static boolean directlyDefineTypes = true;
    public static final boolean interceptReflection = true;
    public static int enumLimit = 1000;
    public static boolean reloadMessages = false;
    public static boolean verifyReloads = true;
    public static String dumpFolder = null;
    public static Properties globalConfigurationProperties;
    public static List<String> classesToDump;
    public static int maxClassDefinitions;
    public static List<String> pluginClassnameList;
    public static final boolean debugplugins;
    public static final boolean isJava18orHigher;
    public static boolean InTestMode;

    private static void printUsage() {
        System.out.println("SpringLoaded");
        System.out.println("============");
        System.out.println();
        System.out.println("Usage: java -noverify -javaagent:<pathto>/springloaded.jar");
        System.out.println("Optionally specify configuration through -Dspringloaded=<options>");
        System.out.println("<options> is a ';' separated list of directives or name=value options");
        System.out.println("Example: -Dspringloaded=verbose;cacheDir=/tmp");
        System.out.println();
        System.out.println("Directives:");
        System.out.println("  ? - print this usage text");
        System.out.println("  verbose - the reloader will log important lifecycle events");
        System.out.println("Options:");
        System.exit(0);
    }

    private static int toInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static {
        maxClassDefinitions = 100;
        globalConfigurationProperties = new Properties();
        boolean debugPlugins = false;
        try {
            String userhome;
            boolean specifiedCaching = false;
            String value = System.getProperty("springloaded");
            if (value != null) {
                StringTokenizer st = new StringTokenizer(value, ";");
                while (st.hasMoreTokens()) {
                    String kv = st.nextToken();
                    int equals = kv.indexOf(61);
                    if (equals != -1) {
                        String key = kv.substring(0, equals);
                        if (key.equals("dump")) {
                            String classList = kv.substring(equals + 1);
                            StringTokenizer clSt = new StringTokenizer(classList, ",");
                            classesToDump = new ArrayList<String>();
                            while (clSt.hasMoreTokens()) {
                                classesToDump.add(clSt.nextToken().replace('.', '/'));
                            }
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: dumping: " + classesToDump);
                            continue;
                        }
                        if (key.equals("cleanCache")) {
                            cleanCache = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("caching")) {
                            specifiedCaching = true;
                            isCaching = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("allowSplitPackages")) {
                            allowSplitPackages = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("debugplugins")) {
                            debugPlugins = true;
                            continue;
                        }
                        if (key.equals("enumlimit")) {
                            enumLimit = GlobalConfiguration.toInt(kv.substring(equals + 1), enumLimit);
                            continue;
                        }
                        if (key.equals("profile")) {
                            profile = kv.substring(equals + 1);
                            continue;
                        }
                        if (key.equals("cacheDir")) {
                            cacheDir = kv.substring(equals + 1);
                            continue;
                        }
                        if (key.equals("callsideRewritingOn")) {
                            callsideRewritingOn = kv.substring(equals + 1).equalsIgnoreCase("true");
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: callsideRewritingOn = " + callsideRewritingOn);
                            continue;
                        }
                        if (key.equals("verifyReloads")) {
                            verifyReloads = kv.substring(equals + 1).equalsIgnoreCase("true");
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: verifyReloads = " + verifyReloads);
                            continue;
                        }
                        if (key.equals("dumpFolder")) {
                            dumpFolder = kv.substring(equals + 1);
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: dumpFolder = " + dumpFolder);
                            continue;
                        }
                        if (key.equals("watchJars")) {
                            if (isRuntimeLogging && log.isLoggable(Level.INFO)) {
                                log.info("Watching jars: " + kv.substring(equals + 1));
                            }
                            jarsToWatch = kv.substring(equals + 1).split(":");
                            continue;
                        }
                        if (key.equals("maxClassDefinitions")) {
                            try {
                                maxClassDefinitions = Integer.parseInt(kv.substring(equals + 1));
                                if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                                log.info("configuration: maxClassDefinitions = " + maxClassDefinitions);
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("ERROR: unable to parse " + kv.substring(equals + 1) + " as a integer");
                            }
                            continue;
                        }
                        if (key.equals("logging")) {
                            isRuntimeLogging = kv.substring(equals + 1).equalsIgnoreCase("true");
                            logging = kv.substring(equals + 1).equalsIgnoreCase("true");
                            System.out.println("Spring-Loaded logging = (" + isRuntimeLogging + "," + logging + ")");
                            continue;
                        }
                        if (key.equals("verbose")) {
                            reloadMessages = verboseMode = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("asserts")) {
                            assertsMode = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("rebasePaths")) {
                            globalConfigurationProperties.put("rebasePaths", kv.substring(equals + 1));
                            continue;
                        }
                        if (key.equals("inclusions")) {
                            globalConfigurationProperties.put("inclusions", kv.substring(equals + 1));
                            continue;
                        }
                        if (key.equals("exclusions")) {
                            globalConfigurationProperties.put("exclusions", kv.substring(equals + 1));
                            continue;
                        }
                        if (!key.equals("plugins")) continue;
                        String pluginList = kv.substring(equals + 1);
                        StringTokenizer pluginListTokenizer = new StringTokenizer(pluginList, ",");
                        pluginClassnameList = new ArrayList<String>();
                        while (pluginListTokenizer.hasMoreTokens()) {
                            pluginClassnameList.add(pluginListTokenizer.nextToken());
                        }
                        continue;
                    }
                    if (kv.equals("?")) {
                        GlobalConfiguration.printUsage();
                        continue;
                    }
                    if (kv.equals("verbose")) {
                        Log.log("[verbose mode on] Full configuration is:" + value);
                        verboseMode = true;
                        reloadMessages = true;
                        continue;
                    }
                    if (kv.equals("investigateSystemClassReflection")) {
                        investigateSystemClassReflection = true;
                        continue;
                    }
                    if (kv.equals("rewriteAllSystemClasses")) {
                        rewriteAllSystemClasses = true;
                        continue;
                    }
                    if (kv.equals("asserts")) {
                        Log.log("[asserts mode on] Will verify system coherence");
                        assertsMode = true;
                        continue;
                    }
                    if (!kv.equals("explain")) continue;
                    Log.log("[explain mode on] Reporting on the decision making process within SpringLoaded");
                    explainMode = true;
                }
            }
            if (profile != null) {
                if (profile.equals("grails")) {
                    if (cacheDir == null) {
                        try {
                            userhome = System.getProperty("user.home");
                            if (userhome != null) {
                                cacheDir = userhome + File.separator + ".grails";
                                new File(cacheDir).mkdir();
                            }
                        }
                        catch (Throwable t) {
                            System.err.println("looks like user.home is not set, or cannot write to it: cannot create cache.");
                            t.printStackTrace(System.err);
                        }
                    }
                    if (!specifiedCaching && cacheDir != null) {
                        isCaching = true;
                    }
                    if (pluginClassnameList == null) {
                        pluginClassnameList = new ArrayList<String>();
                    }
                    pluginClassnameList.add("org.springsource.loaded.SystemPropertyConfiguredIsReloadableTypePlugin");
                    SpringPlugin.support305 = false;
                }
            } else if (isCaching && cacheDir == null) {
                try {
                    userhome = System.getProperty("user.home");
                    if (userhome != null) {
                        cacheDir = userhome;
                    }
                }
                catch (Throwable t) {
                    System.err.println("looks like user.home is not set: cannot create cache.");
                    t.printStackTrace(System.err);
                }
            }
            if (isCaching) {
                try {
                    File cacheDirFile = new File(cacheDir);
                    if (!cacheDirFile.exists()) {
                        boolean created = cacheDirFile.mkdirs();
                        if (!created) {
                            System.err.println("Caching deactivated: failed to create cache directory: " + cacheDir);
                            isCaching = false;
                        }
                    } else if (!cacheDirFile.isDirectory()) {
                        System.err.println("Caching deactivated: unable to use specified cache area, it is not a directory: " + cacheDirFile);
                        isCaching = false;
                    }
                }
                catch (Exception e) {
                    System.err.println("Unexpected problem creating specified cachedir: " + cacheDir);
                    e.printStackTrace();
                }
            }
            if ((value = System.getProperty("springloaded.enumlimit")) != null) {
                enumLimit = GlobalConfiguration.toInt(value, enumLimit);
            }
        }
        catch (Throwable t) {
            System.err.println("Unexpected problem reading global configuration setting:" + t.toString());
            t.printStackTrace();
        }
        debugplugins = debugPlugins;
        InTestMode = false;
        String version = System.getProperty("java.version");
        isJava18orHigher = version.startsWith("1.8");
    }
}

