/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.parser.AngleParser;
import org.apache.batik.parser.DefaultAngleHandler;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAngle;

public class SVGOMAngle
implements SVGAngle {
    private short unitType;
    protected float value;
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected static double[][] K = new double[][]{{1.0, Math.PI / 180, 0.015707963267948967}, {57.29577951308232, 1.0, 63.66197723675813}, {0.9, 0.015707963267948967, 1.0}};

    public short getUnitType() {
        this.revalidate();
        return this.unitType;
    }

    public float getValue() {
        this.revalidate();
        return SVGOMAngle.toUnit(this.getUnitType(), this.value, (short)2);
    }

    public void setValue(float f) throws DOMException {
        this.revalidate();
        this.setUnitType((short)2);
        this.value = f;
        this.reset();
    }

    public float getValueInSpecifiedUnits() {
        this.revalidate();
        return this.value;
    }

    public void setValueInSpecifiedUnits(float f) throws DOMException {
        this.revalidate();
        this.value = f;
        this.reset();
    }

    public String getValueAsString() {
        this.revalidate();
        return Float.toString(this.value) + UNITS[this.getUnitType()];
    }

    public void setValueAsString(String string) throws DOMException {
        this.parse(string);
        this.reset();
    }

    public void newValueSpecifiedUnits(short s, float f) {
        this.setUnitType(s);
        this.value = f;
        this.reset();
    }

    public void convertToSpecifiedUnits(short s) {
        this.value = SVGOMAngle.toUnit(this.getUnitType(), this.value, s);
        this.setUnitType(s);
    }

    protected void reset() {
    }

    protected void revalidate() {
    }

    protected void parse(String string) {
        try {
            AngleParser angleParser = new AngleParser();
            angleParser.setAngleHandler(new DefaultAngleHandler(){

                @Override
                public void angleValue(float f) throws ParseException {
                    SVGOMAngle.this.value = f;
                }

                @Override
                public void deg() throws ParseException {
                    SVGOMAngle.this.setUnitType((short)2);
                }

                @Override
                public void rad() throws ParseException {
                    SVGOMAngle.this.setUnitType((short)3);
                }

                @Override
                public void grad() throws ParseException {
                    SVGOMAngle.this.setUnitType((short)4);
                }
            });
            this.setUnitType((short)1);
            angleParser.parse(string);
        }
        catch (ParseException parseException) {
            this.setUnitType((short)0);
            this.value = 0.0f;
        }
    }

    public static float toUnit(short s, float f, short s2) {
        if (s == 1) {
            s = (short)2;
        }
        if (s2 == 1) {
            s2 = (short)2;
        }
        return (float)(K[s - 2][s2 - 2] * (double)f);
    }

    public void setUnitType(short s) {
        this.unitType = s;
    }
}

