/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import java.util.Hashtable;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.OC;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.export.FormExporter;
import org.jmol.util.Logger;

public class SVGExporter
extends FormExporter {
    private static int svgWidth = 850;
    private static int svgHeight = 400;
    private static int leftInset = 100;
    private static int rightInset = 200;
    private static int bottomInset = 80;
    private static int topInset = 20;

    @Override
    public String exportTheSpectrum(JSViewer jSViewer, ExportType exportType, OC oC, Spectrum spectrum, int n, int n2, PanelData panelData, boolean bl) throws IOException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Hashtable<String, String> hashtable;
        double d6;
        Cloneable cloneable;
        String string;
        String string2;
        double d7;
        double d8;
        double d9;
        GenericColor genericColor;
        GenericColor genericColor2;
        GenericColor genericColor3;
        GenericColor genericColor4;
        GenericColor genericColor5;
        GenericColor genericColor6;
        GenericColor genericColor7;
        this.initForm(jSViewer, oC);
        if (panelData == null) {
            genericColor6 = genericColor7 = ColorParameters.BLACK;
            genericColor5 = genericColor7;
            genericColor4 = genericColor7;
            genericColor3 = genericColor7;
            genericColor2 = genericColor7;
            genericColor = genericColor7;
        } else {
            genericColor = panelData.getColor(ScriptToken.PLOTAREACOLOR);
            genericColor2 = panelData.bgcolor;
            genericColor3 = panelData.getCurrentPlotColor(0);
            genericColor4 = panelData.getColor(ScriptToken.GRIDCOLOR);
            genericColor5 = panelData.getColor(ScriptToken.TITLECOLOR);
            genericColor6 = panelData.getColor(ScriptToken.SCALECOLOR);
            genericColor7 = panelData.getColor(ScriptToken.UNITSCOLOR);
        }
        Coordinate[] coordinateArray = spectrum.getXYCoords();
        ScaleData scaleData = new ScaleData(coordinateArray, n, n2, spectrum.isContinuous(), spectrum.isInverted());
        double d10 = scaleData.maxXOnScale;
        double d11 = scaleData.minXOnScale;
        double d12 = scaleData.maxYOnScale;
        double d13 = scaleData.minYOnScale;
        double d14 = scaleData.steps[0];
        double d15 = scaleData.steps[1];
        int n3 = svgWidth - leftInset - rightInset;
        int n4 = svgHeight - topInset - bottomInset;
        double d16 = (double)n3 / (d10 - d11);
        double d17 = (double)n4 / (d12 - d13);
        int n5 = leftInset;
        int n6 = leftInset + n3;
        int n7 = topInset;
        int n8 = topInset + n4;
        int n9 = n8 + 60;
        this.context.put("titlePosition", new Integer(n9));
        Lst<Cloneable> lst = new Lst<Cloneable>();
        Lst<Cloneable> lst2 = new Lst<Cloneable>();
        for (d9 = d11; d9 < d10 + d14 / 2.0; d9 += d14) {
            d8 = (double)n5 + (d9 - d11) * d16;
            d7 = n7;
            string2 = DF.formatDecimalTrimmed(d8, 6);
            string = DF.formatDecimalTrimmed(d7, 6);
            cloneable = new Hashtable();
            cloneable.put("xVal", string2);
            cloneable.put("yVal", string);
            lst.addLast(cloneable);
        }
        for (d9 = d13; d9 < d12 + d15 / 2.0; d9 += d15) {
            d8 = n5;
            d7 = (double)n7 + (d9 - d13) * d17;
            string2 = DF.formatDecimalTrimmed(d8, 6);
            string = DF.formatDecimalTrimmed(d7, 6);
            cloneable = new Hashtable();
            cloneable.put("xVal", string2);
            cloneable.put("yVal", string);
            lst2.addLast(cloneable);
        }
        Lst lst3 = new Lst();
        Lst lst4 = new Lst();
        cloneable = new Lst();
        int n10 = scaleData.precision[0];
        int n11 = scaleData.precision[1];
        for (d6 = d11; d6 < d10 + d14 / 2.0; d6 += d14) {
            d8 = (double)n5 + (d6 - d11) * d16;
            d7 = n8 + 15;
            string2 = DF.formatDecimalTrimmed(d8 -= 10.0, 6);
            string = DF.formatDecimalTrimmed(d7, 6);
            String string3 = DF.formatDecimalDbl(d6, n10);
            hashtable = new Hashtable<String, String>();
            hashtable.put("xVal", string2);
            hashtable.put("yVal", string);
            hashtable.put("number", string3);
            lst3.addLast(hashtable);
        }
        d6 = d11;
        double d18 = d10;
        while (d6 < d10 + d14 / 2.0) {
            d8 = (double)n5 + (d18 - d11) * d16;
            d7 = n8 + 15;
            string2 = DF.formatDecimalTrimmed(d8 -= 10.0, 6);
            string = DF.formatDecimalTrimmed(d7, 6);
            String string4 = DF.formatDecimalDbl(d6, n10);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("xVal", string2);
            hashtable2.put("yVal", string);
            hashtable2.put("number", string4);
            lst4.addLast(hashtable2);
            d6 += d14;
            d18 -= d14;
        }
        for (d6 = d13; d6 < d12 + d15 / 2.0; d6 += d15) {
            d8 = n5 - 55;
            d7 = (double)n8 - (d6 - d13) * d17;
            string2 = DF.formatDecimalTrimmed(d8, 6);
            string = DF.formatDecimalTrimmed(d7 += 3.0, 6);
            String string5 = DF.formatDecimalDbl(d6, n11);
            hashtable = new Hashtable();
            hashtable.put("xVal", string2);
            hashtable.put("yVal", string);
            hashtable.put("number", string5);
            ((Lst)cloneable).addLast(hashtable);
        }
        boolean bl2 = spectrum.isXIncreasing();
        if (bl2) {
            d6 = n5;
            d5 = n8;
            d4 = d16;
            d3 = -d17;
            d2 = -1.0 * d11;
            d = -1.0 * d13;
        } else {
            d6 = n6;
            d5 = n8;
            d4 = -d16;
            d3 = -d17;
            d2 = -d11;
            d = -d13;
        }
        double d19 = d13 - d15 / 2.0;
        double d20 = d15 / 5.0;
        this.context.put("plotAreaColor", CU.toRGBHexString(genericColor));
        this.context.put("backgroundColor", CU.toRGBHexString(genericColor2));
        this.context.put("plotColor", CU.toRGBHexString(genericColor3));
        this.context.put("gridColor", CU.toRGBHexString(genericColor4));
        this.context.put("titleColor", CU.toRGBHexString(genericColor5));
        this.context.put("scaleColor", CU.toRGBHexString(genericColor6));
        this.context.put("unitsColor", CU.toRGBHexString(genericColor7));
        this.context.put("svgHeight", new Integer(svgHeight));
        this.context.put("svgWidth", new Integer(svgWidth));
        this.context.put("leftPlotArea", new Integer(n5));
        this.context.put("rightPlotArea", new Integer(n6));
        this.context.put("topPlotArea", new Integer(n7));
        this.context.put("bottomPlotArea", new Integer(n8));
        this.context.put("plotAreaHeight", new Integer(n4));
        this.context.put("plotAreaWidth", new Integer(n3));
        this.context.put("minXOnScale", new Double(d11));
        this.context.put("maxXOnScale", new Double(d10));
        this.context.put("minYOnScale", new Double(d13));
        this.context.put("maxYOnScale", new Double(d12));
        this.context.put("yTickA", new Double(d19));
        this.context.put("yTickB", new Double(d20));
        this.context.put("xScaleFactor", new Double(d16));
        this.context.put("yScaleFactor", new Double(d17));
        this.context.put("increasing", new Boolean(bl2));
        this.context.put("verticalGridCoords", lst);
        this.context.put("horizontalGridCoords", lst2);
        Lst<Coordinate> lst5 = new Lst<Coordinate>();
        for (int i = n; i <= n2; ++i) {
            lst5.addLast(coordinateArray[i]);
        }
        double d21 = coordinateArray[n].getXVal();
        double d22 = coordinateArray[n].getYVal();
        double d23 = coordinateArray[n2].getXVal();
        this.context.put("title", genericColor5);
        this.context.put("xyCoords", lst5);
        this.context.put("continuous", new Boolean(spectrum.isContinuous()));
        this.context.put("firstTranslateX", new Double(d6));
        this.context.put("firstTranslateY", new Double(d5));
        this.context.put("scaleX", new Double(d4));
        this.context.put("scaleY", new Double(d3));
        this.context.put("secondTranslateX", new Double(d2));
        this.context.put("secondTranslateY", new Double(d));
        if (bl2) {
            this.context.put("xScaleList", lst3);
            this.context.put("xScaleListReversed", lst4);
        } else {
            this.context.put("xScaleList", lst4);
            this.context.put("xScaleListReversed", lst3);
        }
        this.context.put("yScaleList", cloneable);
        this.context.put("xUnits", spectrum.getXUnits());
        this.context.put("yUnits", spectrum.getYUnits());
        this.context.put("firstX", d21);
        this.context.put("firstY", d22);
        this.context.put("lastX", d23);
        int n12 = n6 - 50;
        int n13 = n8 + 30;
        int n14 = n5 - 80;
        int n15 = n8 / 2;
        int n16 = n14;
        n14 = -n15;
        n15 = n16;
        this.context.put("xUnitLabelX", "" + n12);
        this.context.put("xUnitLabelY", "" + n13);
        this.context.put("yUnitLabelX", "" + n14);
        this.context.put("yUnitLabelY", "" + n15);
        this.context.put("numDecimalPlacesX", new Integer(Math.abs(scaleData.exportPrecision[0])));
        this.context.put("numDecimalPlacesY", new Integer(Math.abs(scaleData.exportPrecision[1])));
        String string6 = exportType == ExportType.SVGI ? "plot_ink.vm" : "plot.vm";
        Logger.info("SVGExporter using " + string6);
        return this.writeForm(string6);
    }
}

