/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jsv;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolJDXMOLParser;
import org.jmol.api.JmolJDXMOLReader;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class JDXMOLParser
implements JmolJDXMOLParser {
    private String line;
    private String lastModel = "";
    private String thisModelID;
    private String baseModel;
    private float vibScale;
    private String piUnitsX;
    private String piUnitsY;
    private JmolJDXMOLReader loader;
    private String modelIdList = "";
    private int[] peakIndex;
    private String peakFilePath;

    public JmolJDXMOLParser set(JmolJDXMOLReader loader, String filePath, Map<String, Object> htParams) {
        this.loader = loader;
        this.peakFilePath = filePath;
        this.peakIndex = new int[1];
        if (htParams != null) {
            htParams.remove("modelNumber");
            if (htParams.containsKey("zipSet")) {
                this.peakIndex = (int[])htParams.get("peakIndex");
                if (this.peakIndex == null) {
                    this.peakIndex = new int[1];
                    htParams.put("peakIndex", this.peakIndex);
                }
                if (!htParams.containsKey("subFileName")) {
                    this.peakFilePath = PT.split((String)filePath, (String)"|")[0];
                }
            }
        }
        return this;
    }

    public String getAttribute(String line, String tag) {
        String attr = PT.getQuotedAttribute((String)line, (String)tag);
        return attr == null ? "" : attr;
    }

    public String getRecord(String key) throws Exception {
        if (this.line == null || this.line.indexOf(key) < 0) {
            return null;
        }
        String s = this.line;
        while (s.indexOf(">") < 0) {
            s = s + " " + this.readLine();
        }
        this.line = s;
        return this.line;
    }

    public boolean readModels() throws Exception {
        if (!this.findRecord("Models")) {
            return false;
        }
        this.line = "";
        this.thisModelID = "";
        boolean isFirst = true;
        while (true) {
            this.line = this.loader.discardLinesUntilNonBlank();
            if (this.getRecord("<ModelData") == null) break;
            this.getModelData(isFirst);
            isFirst = false;
        }
        return true;
    }

    public String readACDMolFile() throws Exception {
        SB sb = new SB();
        sb.append(this.line.substring(this.line.indexOf("=") + 1)).appendC('\n');
        while (this.readLine() != null && !this.line.contains("$$$$")) {
            sb.append(this.line).appendC('\n');
        }
        return PT.rep((String)sb.toString(), (String)"  $$ Empty String", (String)"");
    }

    public Lst<String[]> readACDAssignments(int nPoints, boolean isPeakAssignment) throws Exception {
        Lst list = new Lst();
        try {
            String s;
            this.readLine();
            if (nPoints < 0) {
                nPoints = Integer.MAX_VALUE;
            }
            for (int i = 0; i < nPoints && (s = this.readLine()) != null && s.indexOf("#") != 0; ++i) {
                if (isPeakAssignment) {
                    while (s.indexOf(">") < 0) {
                        s = s + " " + this.readLine();
                    }
                    s = s.trim();
                }
                if ((s = PT.replaceAllCharacters((String)s, (String)"()<>", (String)" ").trim()).length() != 0) {
                    int pt = s.indexOf("'");
                    if (pt >= 0) {
                        int pt2 = s.indexOf("'", pt + 1);
                        s = s.substring(0, pt) + PT.rep((String)s.substring(pt + 1, pt2), (String)",", (String)";") + s.substring(pt2 + 1);
                    }
                    Logger.info((String)("Peak Assignment: " + s));
                    String[] tokens = PT.split((String)s, (String)",");
                    list.addLast((Object)tokens);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Logger.error((String)("Error reading peak assignments at " + this.line + ": " + e));
        }
        return list;
    }

    public int setACDAssignments(String model, String mytype, int peakCount, Lst<String[]> acdlist, String molFile) throws Exception {
        try {
            int pta;
            int ptx;
            int i;
            if (peakCount >= 0) {
                this.peakIndex = new int[]{peakCount};
            }
            boolean isMS = mytype.indexOf("MASS") == 0;
            String file = " file=" + PT.esc((String)this.peakFilePath.replace('\\', '/'));
            model = " model=" + PT.esc((String)(model + " (assigned)"));
            this.piUnitsX = "";
            this.piUnitsY = "";
            float dx = this.getACDPeakWidth(mytype) / 2.0f;
            Hashtable<String, Object[]> htSets = new Hashtable<String, Object[]>();
            Lst list = new Lst();
            Hashtable<String, String> zzcMap = null;
            int nAtoms = 0;
            if (isMS) {
                zzcMap = new Hashtable<String, String>();
                String[] tokens = PT.split((String)molFile, (String)"M  ZZC");
                i = tokens.length;
                while (--i >= 1) {
                    String[] ab = PT.getTokens((String)tokens[i]);
                    nAtoms = Math.max(nAtoms, PT.parseInt((String)ab[0]));
                    zzcMap.put(ab[1], ab[0]);
                }
                ptx = 4;
                pta = 0;
            } else if (mytype.indexOf("NMR") >= 0) {
                ptx = 0;
                pta = 3;
            } else {
                ptx = 0;
                pta = 2;
            }
            int nPeaks = acdlist.size();
            for (i = 0; i < nPeaks; ++i) {
                String[] data = (String[])acdlist.get(i);
                float x = PT.parseFloat((String)data[ptx]);
                String a = data[pta];
                a = isMS ? this.fixACDAtomList(a, zzcMap, nAtoms) : a.replace(';', ',');
                if (a.indexOf("select") >= 0) {
                    int pt = a.indexOf("select atomno=");
                    if (pt < 0) continue;
                    a = PT.split((String)a.substring(pt + 14), (String)" ")[0];
                }
                String title = isMS ? "m/z=" + Math.round(x) + ": " + data[2] + " (" + data[1] + ")" : (pta == 2 ? "" + (float)Math.round(x * 10.0f) / 10.0f : null);
                this.getStringInfo(file, title, mytype, model, a, htSets, "" + x, (Lst<Object[]>)list, " atoms=\"%ATOMS%\" xMin=\"" + (x - dx) + "\" xMax=\"" + (x + dx) + "\">");
            }
            return this.setPeakData((Lst<Object[]>)list, 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String fixACDAtomList(String atoms, Map<String, String> zzcMap, int nAtoms) {
        atoms = atoms.trim();
        String[] tokens = PT.getTokens((String)atoms.replace(';', ' '));
        BS bs = new BS();
        boolean isM = false;
        for (int i = 0; i < tokens.length; ++i) {
            int pt;
            String a = tokens[i];
            boolean bl = isM = a.indexOf("M") >= 0;
            if (isM) {
                a = "1-" + nAtoms;
            }
            if ((pt = a.indexOf(45)) >= 0) {
                int i1 = PT.parseInt((String)a.substring(0, pt));
                int i2 = PT.parseInt((String)a.substring(pt + 1)) + 1;
                for (int k = i1; k < i2; ++k) {
                    bs.set(isM ? k : PT.parseInt((String)zzcMap.get("" + k)));
                }
                continue;
            }
            bs.set(PT.parseInt((String)zzcMap.get(a)));
        }
        String s = bs.toJSON();
        return s.substring(1, s.length() - 1);
    }

    private float getACDPeakWidth(String type) {
        return type.indexOf("HNMR") >= 0 ? 0.05f : (type.indexOf("CNMR") >= 0 ? 1.0f : (type.indexOf("MASS") >= 0 ? 1.0f : 10.0f));
    }

    public int readPeaks(boolean isSignals, int peakCount) throws Exception {
        try {
            String tag2;
            if (peakCount >= 0) {
                this.peakIndex = new int[]{peakCount};
            }
            int offset = isSignals ? 1 : 0;
            String tag1 = isSignals ? "Signals" : "Peaks";
            String string = tag2 = isSignals ? "<Signal" : "<PeakData";
            if (!this.findRecord(tag1)) {
                return 0;
            }
            String file = " file=" + PT.esc((String)this.peakFilePath.replace('\\', '/'));
            String model = PT.getQuotedAttribute((String)this.line, (String)"model");
            model = " model=" + PT.esc((String)(model == null ? this.thisModelID : model));
            String mytype = PT.getQuotedAttribute((String)this.line, (String)"type");
            this.piUnitsX = PT.getQuotedAttribute((String)this.line, (String)"xLabel");
            this.piUnitsY = PT.getQuotedAttribute((String)this.line, (String)"yLabel");
            Hashtable<String, Object[]> htSets = new Hashtable<String, Object[]>();
            Lst list = new Lst();
            while (this.readLine() != null && !(this.line = this.line.trim()).startsWith("</" + tag1)) {
                if (!this.line.startsWith(tag2)) continue;
                this.getRecord(tag2);
                Logger.info((String)this.line);
                String title = PT.getQuotedAttribute((String)this.line, (String)"title");
                if (mytype == null) {
                    mytype = PT.getQuotedAttribute((String)this.line, (String)"type");
                }
                String atoms = PT.getQuotedAttribute((String)this.line, (String)"atoms");
                String key = (int)(PT.parseFloat((String)PT.getQuotedAttribute((String)this.line, (String)"xMin")) * 100.0f) + "_" + (int)(PT.parseFloat((String)PT.getQuotedAttribute((String)this.line, (String)"xMax")) * 100.0f);
                this.getStringInfo(file, title, mytype, PT.getQuotedAttribute((String)this.line, (String)"model") == null ? model : "", atoms, htSets, key, (Lst<Object[]>)list, this.line.substring(tag2.length()).trim());
            }
            return this.setPeakData((Lst<Object[]>)list, offset);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int setPeakData(Lst<Object[]> list, int offset) {
        int nH = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object[] o = (Object[])list.get(i);
            this.peakIndex[0] = this.peakIndex[0] + 1;
            String info = PT.rep((String)((String)o[0]), (String)"%INDEX%", (String)("" + this.peakIndex[0]));
            BS bs = (BS)o[1];
            if (bs != null) {
                String s = "";
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    s = s + "," + (j + offset);
                    j = bs.nextSetBit(j + 1);
                }
                int na = bs.cardinality();
                nH += na;
                info = PT.rep((String)info, (String)"%ATOMS%", (String)s.substring(1));
                info = PT.rep((String)info, (String)"%S%", (String)(na == 1 ? "" : "s"));
                info = PT.rep((String)info, (String)"%NATOMS%", (String)("" + na));
            }
            Logger.info((String)("adding PeakData " + info));
            this.loader.addPeakData(info);
        }
        this.loader.setSpectrumPeaks(nH, this.piUnitsX, this.piUnitsY);
        return n;
    }

    private void getStringInfo(String file, String title, String mytype, String model, String atoms, Map<String, Object[]> htSets, String key, Lst<Object[]> list, String more) {
        Object[] o;
        String type;
        if ("HNMR".equals(mytype)) {
            mytype = "1HNMR";
        } else if ("CNMR".equals(mytype)) {
            mytype = "13CNMR";
        }
        String string = type = mytype == null ? "" : " type=" + PT.esc((String)mytype);
        if (title == null) {
            title = "1HNMR".equals(mytype) ? "atom%S%: %ATOMS%; integration: %NATOMS%" : "";
        }
        title = " title=" + PT.esc((String)title);
        String stringInfo = "<PeakData " + file + " index=\"%INDEX%\"" + title + type + model + " " + more;
        if (atoms != null) {
            stringInfo = PT.rep((String)stringInfo, (String)("atoms=\"" + atoms + "\""), (String)"atoms=\"%ATOMS%\"");
        }
        if ((o = htSets.get(key)) == null) {
            o = new Object[]{stringInfo, atoms == null ? null : new BS()};
            htSets.put(key, o);
            list.addLast((Object)o);
        }
        if (atoms != null) {
            BS bs = (BS)o[1];
            if ((atoms = atoms.replace(',', ' ')).equals("*")) {
                atoms = "0:1000";
            }
            bs.or(BS.unescape((String)("({" + atoms + "})")));
        }
    }

    private void getModelData(boolean isFirst) throws Exception {
        this.lastModel = this.thisModelID;
        this.thisModelID = this.getAttribute(this.line, "id");
        String key = ";" + this.thisModelID + ";";
        if (this.modelIdList.indexOf(key) >= 0) {
            this.line = this.loader.discardLinesUntilContains("</ModelData>");
            return;
        }
        this.modelIdList = this.modelIdList + key;
        this.baseModel = this.getAttribute(this.line, "baseModel");
        while (this.line.indexOf(">") < 0 && this.line.indexOf("type") < 0) {
            this.readLine();
        }
        String modelType = this.getAttribute(this.line, "type").toLowerCase();
        this.vibScale = PT.parseFloat((String)this.getAttribute(this.line, "vibrationScale"));
        if (modelType.equals("xyzvib")) {
            modelType = "xyz";
        } else if (modelType.length() == 0) {
            modelType = null;
        }
        SB sb = new SB();
        while (this.readLine() != null && !this.line.contains("</ModelData>")) {
            sb.append(this.line).appendC('\n');
        }
        this.loader.processModelData(sb.toString(), this.thisModelID, modelType, this.baseModel, this.lastModel, Float.NaN, this.vibScale, isFirst);
    }

    private boolean findRecord(String tag) throws Exception {
        if (this.line == null) {
            this.readLine();
        }
        if (this.line.indexOf("<" + tag) < 0) {
            this.line = this.loader.discardLinesUntilContains2("<" + tag, "##");
        }
        return this.line != null && this.line.indexOf("<" + tag) >= 0;
    }

    private String readLine() throws Exception {
        this.line = this.loader.rd();
        return this.line;
    }

    public void setLine(String s) {
        this.line = s;
    }
}

