/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JTextArea;
import org.openscience.jmol.app.jmolpanel.LoopedStreams;

public class ConsoleTextArea
extends JTextArea {
    public ConsoleTextArea(InputStream[] inStreams) {
        for (int i = 0; i < inStreams.length; ++i) {
            this.startConsoleReaderThread(inStreams[i]);
        }
    }

    public ConsoleTextArea(boolean doRedirect) throws IOException {
        String redirect;
        LoopedStreams ls = new LoopedStreams();
        String string = redirect = doRedirect ? System.getProperty("JmolConsole") : "false";
        if (redirect == null || redirect.equals("true")) {
            PrintStream ps = new PrintStream(ls.getOutputStream());
            System.setOut(ps);
            System.setErr(ps);
        }
        this.startConsoleReaderThread(ls.getInputStream());
    }

    private void startConsoleReaderThread(InputStream inStream) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("ConsoleReaderThread");
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        ConsoleTextArea.this.append(s + "\n");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }
}

