/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;

class UFFAngleCalc
extends Calculation {
    UFFAngleCalc() {
    }

    void setData(Lst<Object[]> calc, int[] angle) {
        double c0;
        double c1;
        double c2;
        this.ia = angle[0];
        this.a = this.calcs.minAtoms[this.ia];
        this.ib = angle[1];
        this.b = this.calcs.minAtoms[this.ib];
        this.ic = angle[2];
        this.c = this.calcs.minAtoms[this.ic];
        double preliminaryMagnification = this.a.sType == "H_" && this.c.sType == "H_" ? 10 : 1;
        this.calcs.parA = (FFParam)this.calcs.getParameter(this.a.sType);
        this.calcs.parB = (FFParam)this.calcs.getParameter(this.b.sType);
        this.calcs.parC = (FFParam)this.calcs.getParameter(this.c.sType);
        int coordination = this.calcs.parB.iVal[0];
        double zi = this.calcs.parA.dVal[5];
        double zk = this.calcs.parC.dVal[5];
        double theta0 = this.calcs.parB.dVal[1];
        double cosT0 = Math.cos(theta0);
        double sinT0 = Math.sin(theta0);
        switch (coordination) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                c2 = 0.0;
                c1 = 0.0;
                c0 = 0.0;
                break;
            }
            default: {
                c2 = 1.0 / (4.0 * sinT0 * sinT0);
                c1 = -4.0 * c2 * cosT0;
                c0 = c2 * (2.0 * cosT0 * cosT0 + 1.0);
            }
        }
        MinBond bond = this.a.getBondTo(this.ib);
        double bondorder = bond.order;
        if (bond.isAromatic) {
            bondorder = 1.5;
        }
        if (bond.isAmide) {
            bondorder = 1.41;
        }
        this.rab = CalculationsUFF.calculateR0(this.calcs.parA.dVal[0], this.calcs.parB.dVal[0], this.calcs.parA.dVal[8], this.calcs.parB.dVal[8], bondorder);
        bond = this.c.getBondTo(this.ib);
        bondorder = bond.order;
        if (bond.isAromatic) {
            bondorder = 1.5;
        }
        if (bond.isAmide) {
            bondorder = 1.41;
        }
        double rbc = CalculationsUFF.calculateR0(this.calcs.parB.dVal[0], this.calcs.parC.dVal[0], this.calcs.parB.dVal[8], this.calcs.parC.dVal[8], bondorder);
        double rac = Math.sqrt(this.rab * this.rab + rbc * rbc - 2.0 * this.rab * rbc * cosT0);
        double ka = 2696.8016159999997 * (zi * zk / Math.pow(rac, 5.0)) * (3.0 * this.rab * rbc * (1.0 - cosT0 * cosT0) - rac * rac * cosT0);
        calc.addLast((Object)new Object[]{new int[]{this.ia, this.ib, this.ic, coordination}, new double[]{ka, theta0 * 57.29577951308232, c0 - c2, c1, 2.0 * c2, preliminaryMagnification * ka}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        int coordination = this.iData[3];
        double ka = this.calcs.isPreliminary ? this.dData[5] : this.dData[0];
        double a0 = this.dData[2];
        double a1 = this.dData[3];
        double a2 = this.dData[4];
        this.calcs.setAngleVariables(this);
        if ((coordination == 4 || coordination == 6) && (this.theta > 2.35619 || this.theta < 0.785398)) {
            coordination = 1;
        }
        double cosT = Math.cos(this.theta);
        double sinT = Math.sin(this.theta);
        switch (coordination) {
            case 0: 
            case 1: {
                this.energy = ka * (1.0 + cosT) * (1.0 + cosT) / 4.0;
                break;
            }
            case 2: {
                this.energy = ka * (1.0 + 4.0 * cosT * (1.0 + cosT)) / 9.0;
                break;
            }
            case 4: 
            case 6: {
                this.energy = ka * cosT * cosT;
                break;
            }
            default: {
                this.energy = ka * (a0 + a1 * cosT + a2 * cosT * cosT);
            }
        }
        if (this.calcs.gradients) {
            switch (coordination) {
                case 0: 
                case 1: {
                    this.dE = -0.5 * ka * sinT * (1.0 + cosT);
                    break;
                }
                case 2: {
                    this.dE = -4.0 * sinT * ka * (1.0 - 2.0 * cosT) / 9.0;
                    break;
                }
                case 4: 
                case 6: {
                    this.dE = -ka * sinT * cosT;
                    break;
                }
                default: {
                    this.dE = -ka * (a1 * sinT - 2.0 * a2 * cosT * sinT);
                }
            }
            this.calcs.addForces(this, 3);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(1, this));
        }
        return this.energy;
    }
}

