/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.CodeRange;
import org.jcodings.EucEncoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.InternalException;
import org.jcodings.util.CaseInsensitiveBytesHash;

abstract class BaseEUCJPEncoding
extends EucEncoding {
    private static final int[] CR_Hiragana = new int[]{1, 42145, 42227};
    private static final int[] CR_Katakana = new int[]{3, 42401, 42486, 43686, 43695, 43697, 43741};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final CaseInsensitiveBytesHash<Integer> CTypeNameHash = new CaseInsensitiveBytesHash();
    static final int[] EUCJPEncLen;

    protected BaseEUCJPEncoding(int[][] Trans) {
        super("EUC-JP", 1, 3, EUCJPEncLen, Trans, AsciiTables.AsciiCtypeTable);
    }

    public int mbcToCode(byte[] bytes2, int p2, int end2) {
        return this.mbnMbcToCode(bytes2, p2, end2);
    }

    public int codeToMbcLength(int code) {
        if (BaseEUCJPEncoding.isAscii(code)) {
            return 1;
        }
        if (code > 0xFFFFFF) {
            throw new EncodingException("too big wide-char value");
        }
        if ((code & 0xFF808080) == 0x808080) {
            return 3;
        }
        if ((code & 0xFFFF8080) == 32896) {
            return 2;
        }
        throw new EncodingException("invalid code point value");
    }

    public int codeToMbc(int code, byte[] bytes2, int p2) {
        int p_ = p2;
        if ((code & 0xFF0000) != 0) {
            bytes2[p_++] = (byte)(code >> 16 & 0xFF);
        }
        if ((code & 0xFF00) != 0) {
            bytes2[p_++] = (byte)(code >> 8 & 0xFF);
        }
        bytes2[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes2, p2, p_) != p_ - p2) {
            throw new EncodingException("invalid code point value");
        }
        return p_ - p2;
    }

    public int mbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] lower) {
        int p2 = pp.value++;
        int lowerP = 0;
        if (BaseEUCJPEncoding.isMbcAscii(bytes2[p2])) {
            lower[lowerP] = AsciiTables.ToLowerCaseTable[bytes2[p2] & 0xFF];
            return 1;
        }
        int len = this.length(bytes2, p2, end2);
        for (int i2 = 0; i2 < len; ++i2) {
            lower[lowerP++] = bytes2[p2++];
        }
        pp.value += len;
        return len;
    }

    protected boolean isLead(int c) {
        return (c - 161 & 0xFF) > 93;
    }

    public boolean isReverseMatchAllowed(byte[] bytes2, int p2, int end2) {
        int c = bytes2[p2] & 0xFF;
        return c <= 126 || c == 142 || c == 143;
    }

    public int propertyNameToCType(byte[] bytes2, int p2, int end2) {
        Integer ctype = CTypeNameHash.get(bytes2, p2, end2);
        if (ctype == null) {
            return super.propertyNameToCType(bytes2, p2, end2);
        }
        return ctype;
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14) {
            if (code < 128) {
                return this.isCodeCTypeInternal(code, ctype);
            }
            if (BaseEUCJPEncoding.isWordGraphPrint(ctype)) {
                return this.codeToMbcLength(code) > 1;
            }
        } else {
            if ((ctype -= 15) >= PropertyList.length) {
                throw new InternalException("undefined type (bug)");
            }
            return CodeRange.isInCodeRange(PropertyList[ctype], code);
        }
        return false;
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        if (ctype <= 14) {
            return null;
        }
        sbOut.value = 128;
        if ((ctype -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[ctype];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        EUCJPEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    }
}

