/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.io.WriterOutputStream;
import org.jruby.embed.variable.TransientLocalVariable;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.util.io.BadDescriptorException;

public class Utils {
    static int getLineNumber(ScriptContext context) {
        Object obj = context.getAttribute(AttributeName.LINENUMBER.toString(), 100);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    static Object getReceiver(ScriptContext context) {
        return context.getAttribute(AttributeName.RECEIVER.toString(), 100);
    }

    static String getFilename(ScriptContext context) {
        Object filename2 = context.getAttribute("javax.script.filename");
        return filename2 != null ? (String)filename2 : "<script>";
    }

    static boolean isTerminationOn(ScriptContext context) {
        Object obj = context.getAttribute(AttributeName.TERMINATION.toString());
        return obj != null && obj instanceof Boolean && (Boolean)obj == true;
    }

    static boolean isClearVariablesOn(ScriptContext context) {
        Object obj = context.getAttribute(AttributeName.CLEAR_VARAIBLES.toString());
        return obj != null && obj instanceof Boolean && (Boolean)obj == true;
    }

    static void preEval(ScriptingContainer container, ScriptContext context) {
        Object receiver2 = Utils.getReceiverObject(context);
        Bindings bindings = context.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            Utils.put(container, receiver2, (String)entry.getKey(), entry.getValue(), context);
        }
        try {
            Utils.setWriter(container, context.getWriter());
            Utils.setErrorWriter(container, context.getErrorWriter());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadDescriptorException ex) {
            throw new RuntimeException(ex);
        }
        bindings = context.getBindings(200);
        if (bindings == null) {
            return;
        }
        for (Map.Entry entry : bindings.entrySet()) {
            if (container.getVarMap().containsKey(entry.getKey())) continue;
            Utils.put(container, receiver2, (String)entry.getKey(), entry.getValue(), context);
        }
    }

    private static Object getReceiverObject(ScriptContext context) {
        if (context == null) {
            return null;
        }
        return context.getAttribute(AttributeName.RECEIVER.toString(), 100);
    }

    private static void setWriter(ScriptingContainer container, Writer writer) throws IOException, BadDescriptorException {
        Writer old;
        if (writer == null) {
            return;
        }
        Map map = container.getAttributeMap();
        if (map.containsKey((Object)AttributeName.WRITER) && (old = (Writer)map.get((Object)AttributeName.WRITER)) == writer) {
            return;
        }
        map.put(AttributeName.WRITER, writer);
        Ruby runtime = container.getProvider().getRuntime();
        RubyIO io2 = Utils.getRubyIO(runtime, writer);
        runtime.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime, "$stdout", io2), GlobalVariable.Scope.GLOBAL);
        runtime.getObject().storeConstant("STDOUT", io2);
        runtime.getGlobalVariables().alias("$>", "$stdout");
        runtime.getGlobalVariables().alias("$defout", "$stdout");
    }

    private static void setErrorWriter(ScriptingContainer container, Writer writer) throws IOException, BadDescriptorException {
        Writer old;
        if (writer == null) {
            return;
        }
        Map map = container.getAttributeMap();
        if (map.containsKey((Object)AttributeName.ERROR_WRITER) && (old = (Writer)map.get((Object)AttributeName.ERROR_WRITER)) == writer) {
            return;
        }
        map.put(AttributeName.ERROR_WRITER, writer);
        Ruby runtime = container.getProvider().getRuntime();
        RubyIO io2 = Utils.getRubyIO(runtime, writer);
        runtime.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime, "$stderr", io2), GlobalVariable.Scope.GLOBAL);
        runtime.getObject().storeConstant("STDERR", io2);
        runtime.getGlobalVariables().alias("$deferr", "$stderr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyIO getRubyIO(Ruby runtime, Writer writer) throws IOException, BadDescriptorException {
        PrintStream pstream = new PrintStream(new WriterOutputStream(writer, runtime.getDefaultCharset().name()), true);
        RubyIO io2 = new RubyIO(runtime, pstream, false);
        boolean locked = io2.getOpenFile().lock();
        try {
            io2.getOpenFile().setSync(true);
            io2.getOpenFile().io_fflush(runtime.getCurrentContext());
            RubyIO rubyIO = io2;
            return rubyIO;
        }
        finally {
            if (locked) {
                io2.getOpenFile().unlock();
            }
        }
    }

    static void postEval(ScriptingContainer container, ScriptContext context) {
        Bindings globalMap;
        if (context == null) {
            return;
        }
        Object receiver2 = Utils.getReceiverObject(context);
        Bindings engineMap = context.getBindings(100);
        int size2 = engineMap.keySet().size();
        String[] names2 = engineMap.keySet().toArray(new String[size2]);
        Iterator iter = engineMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!Utils.shouldLVarBeDeleted(container, (String)entry.getKey())) continue;
            iter.remove();
        }
        Set<String> keys2 = container.getVarMap().keySet();
        if (keys2 != null && keys2.size() > 0) {
            for (String key2 : keys2) {
                Object value2 = container.getVarMap().get(key2);
                engineMap.put(Utils.adjustKey(key2), value2);
            }
        }
        if ((globalMap = context.getBindings(200)) == null) {
            return;
        }
        keys2 = globalMap.keySet();
        if (keys2 != null && keys2.size() > 0) {
            for (String key3 : keys2) {
                if (engineMap.containsKey(key3)) continue;
                Object value3 = container.getVarMap().get(receiver2, key3);
                globalMap.put(key3, value3);
            }
        }
    }

    private static Object put(ScriptingContainer container, Object receiver2, String key2, Object value2, ScriptContext context) {
        Object oldValue = null;
        String adjustedKey = Utils.adjustKey(key2);
        if (Utils.isRubyVariable(container, adjustedKey)) {
            boolean sharing_variables = true;
            Object obj = context.getAttribute(AttributeName.SHARING_VARIABLES.toString(), 100);
            if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                sharing_variables = false;
            }
            if (sharing_variables || "ARGV".equals(adjustedKey)) {
                oldValue = container.put(receiver2, adjustedKey, value2);
            }
        } else {
            oldValue = adjustedKey.equals(AttributeName.SHARING_VARIABLES.toString()) ? container.setAttribute((Object)AttributeName.SHARING_VARIABLES, value2) : container.setAttribute(adjustedKey, value2);
        }
        return oldValue;
    }

    static boolean isRubyVariable(ScriptingContainer container, String name2) {
        return VariableInterceptor.isKindOfRubyVariable(container.getProvider().getLocalVariableBehavior(), name2);
    }

    private static String adjustKey(String key2) {
        if (key2.equals("javax.script.argv")) {
            return "ARGV";
        }
        if ("ARGV".equals(key2)) {
            return "javax.script.argv";
        }
        return key2;
    }

    private static boolean shouldLVarBeDeleted(ScriptingContainer container, String key2) {
        LocalVariableBehavior behavior = container.getProvider().getLocalVariableBehavior();
        if (behavior != LocalVariableBehavior.TRANSIENT) {
            return false;
        }
        return TransientLocalVariable.isValidName(key2);
    }
}

