/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceTemplate {
    public static RubyModule createJavaInterfaceTemplateModule(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyModule JavaInterfaceTemplate2 = runtime.defineModule("JavaInterfaceTemplate");
        RubyClass singleton = JavaInterfaceTemplate2.getSingletonClass();
        singleton.addReadAttribute(context, "java_class");
        singleton.defineAnnotatedMethods(JavaInterfaceTemplate.class);
        JavaInterfaceTemplate2.defineAnnotatedMethods(JavaProxy.ClassMethods.class);
        return JavaInterfaceTemplate2;
    }

    @Deprecated
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject implement(ThreadContext context, IRubyObject self2, IRubyObject clazz) {
        if (!(clazz instanceof RubyModule)) {
            Ruby runtime = context.runtime;
            throw runtime.newTypeError(clazz, runtime.getModule());
        }
        RubyModule targetModule = (RubyModule)clazz;
        JavaClass javaClass = JavaInterfaceTemplate.getJavaClassForInterface(self2);
        Method[] javaInstanceMethods = javaClass.javaClass().getMethods();
        DummyMethodImpl dummyMethodImpl = new DummyMethodImpl(targetModule);
        for (int i2 = 0; i2 < javaInstanceMethods.length; ++i2) {
            Method javaMethod = javaInstanceMethods[i2];
            String name2 = javaMethod.getName();
            if (!targetModule.searchMethod(name2).isUndefined()) continue;
            targetModule.addMethod(name2, dummyMethodImpl);
        }
        return context.nil;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject append_features(ThreadContext context, IRubyObject self2, IRubyObject clazz, Block block) {
        if (clazz instanceof RubyClass) {
            JavaInterfaceTemplate.appendFeaturesToClass(context, self2, (RubyClass)clazz);
        } else if (clazz instanceof RubyModule) {
            JavaInterfaceTemplate.appendFeaturesToModule(context, self2, (RubyModule)clazz);
        } else {
            throw context.runtime.newTypeError("received " + clazz + ", expected Class/Module");
        }
        return Helpers.invokeSuper(context, self2, clazz, block);
    }

    private static void appendFeaturesToClass(ThreadContext context, IRubyObject self2, RubyClass clazz) {
        Ruby runtime = context.runtime;
        JavaInterfaceTemplate.checkAlreadyReified(clazz, runtime);
        JavaClass javaClass = JavaInterfaceTemplate.getJavaClassForInterface(self2);
        if (!clazz.hasInstanceVariable("@java_interfaces")) {
            RubyArray javaInterfaces = RubyArray.newArray(runtime, javaClass);
            clazz.setInstanceVariable("@java_interfaces", javaInterfaces);
            JavaInterfaceTemplate.initInterfaceImplMethods(context, clazz);
        } else {
            RubyArray javaInterfaces = (RubyArray)clazz.getInstanceVariable("@java_interfaces");
            if (!javaInterfaces.isFrozen() && !javaInterfaces.includes(context, javaClass)) {
                javaInterfaces.append(javaClass);
            }
        }
    }

    private static void checkAlreadyReified(RubyClass clazz, Ruby runtime) throws RaiseException {
        if (Java.NEW_STYLE_EXTENSION && clazz.getReifiedClass() != null || clazz.hasInstanceVariable("@java_class") && clazz.getInstanceVariable("@java_class").isTrue() && !clazz.getSingletonClass().isMethodBound("java_proxy_class", false) || clazz.hasInstanceVariable("@java_proxy_class") && clazz.getInstanceVariable("@java_proxy_class").isTrue()) {
            throw runtime.newArgumentError("can not add Java interface to existing Java class");
        }
    }

    private static void initInterfaceImplMethods(ThreadContext context, RubyClass clazz) {
        RubyClass singleton;
        if (!clazz.isMethodBound("__jcreate!", false) && !clazz.isMethodBound("__jcreate_meta!", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addReadAttribute(context, "java_interfaces");
            if (!Java.NEW_STYLE_EXTENSION && clazz.getSuperClass().getRealClass().hasInstanceVariable("@java_class") || RubyInstanceConfig.INTERFACES_USE_PROXY) {
                final ObjectAllocator proxyAllocator = clazz.getAllocator();
                clazz.setAllocator(new ObjectAllocator(){

                    @Override
                    public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                        IRubyObject newObj = proxyAllocator.allocate(runtime, klazz);
                        Helpers.invoke(runtime.getCurrentContext(), newObj, "__jcreate!");
                        return newObj;
                    }
                });
                clazz.addMethod("__jcreate!", new InterfaceProxyFactory(clazz));
            } else {
                JavaInterfaceTemplate.addRealImplClassNew(clazz);
            }
            clazz.addMethod("__jcreate_meta!", new InterfaceProxyFactory(clazz));
            clazz.addMethod("java_class", new JavaClassAccessor(clazz));
        }
        if (!clazz.isMethodBound("implement", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addMethod("implement", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject iface) {
                    RubyArray ifaces = JavaInterfaceTemplate.getJavaInterfaces(self2);
                    if (ifaces != null && ifaces.includes(context, iface)) {
                        return Helpers.invoke(context, iface, "implement", self2);
                    }
                    return context.nil;
                }
            });
            singleton.addMethod("implement_all", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                    RubyArray ifaces = JavaInterfaceTemplate.getJavaInterfaces(self2);
                    if (ifaces == null) {
                        return context.nil;
                    }
                    for (int i2 = 0; i2 < ifaces.size(); ++i2) {
                        RubyModule iface = Java.get_interface_module(context.runtime, ifaces.eltInternal(i2));
                        Helpers.invoke(context, (IRubyObject)iface, "implement", self2);
                    }
                    return ifaces;
                }
            });
        }
    }

    public static void addRealImplClassNew(RubyClass clazz) {
        clazz.setAllocator(new ObjectAllocator(){
            private Constructor proxyConstructor;

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                Class reifiedClass = klazz.getReifiedClass();
                if (this.proxyConstructor == null || this.proxyConstructor.getDeclaringClass() != reifiedClass) {
                    if (reifiedClass == null) {
                        reifiedClass = Java.generateRealClass(klazz);
                    }
                    this.proxyConstructor = Java.getRealClassConstructor(runtime, reifiedClass);
                }
                IRubyObject newObj = Java.constructProxy(runtime, this.proxyConstructor, klazz);
                return newObj;
            }
        });
    }

    private static IRubyObject newInterfaceProxy(IRubyObject self2) {
        RubyClass current2 = self2.getMetaClass();
        JavaObject newObject2 = Java.newInterfaceImpl(self2, Java.getInterfacesFromRubyClass(current2));
        JavaUtilities.set_java_object(self2, self2, newObject2);
        return newObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFeaturesToModule(ThreadContext context, IRubyObject self2, RubyModule module) {
        Ruby runtime = context.runtime;
        IRubyObject java_class2 = module.getInstanceVariables().getInstanceVariable("@java_class");
        if (java_class2 != null && java_class2.isTrue()) {
            throw runtime.newTypeError("can not add Java interface to existing Java interface");
        }
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (JavaInterfaceTemplate.initInterfaceModules(self2, module)) {
                RubyClass singleton = module.getSingletonClass();
                singleton.addMethod("append_features", new AppendFeatures(singleton));
            } else {
                RubyArray interfaceModules = JavaInterfaceTemplate.getInterfaceModules(module);
                if (!interfaceModules.includes(context, self2)) {
                    interfaceModules.append(self2);
                }
            }
        }
    }

    @JRubyMethod
    public static IRubyObject extended(ThreadContext context, IRubyObject self2, IRubyObject object) {
        RubyClass singleton = object.getSingletonClass();
        singleton.include(context, self2);
        return singleton;
    }

    @JRubyMethod(name={"[]"}, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return JavaProxy.op_aref(context, self2, args2);
    }

    @JRubyMethod(name={"impl"}, rest=true)
    public static IRubyObject impl(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block implBlock) {
        Object[] methodNames;
        Ruby runtime = context.runtime;
        if (!implBlock.isGiven()) {
            throw runtime.newArgumentError("block required to call #impl on a Java interface");
        }
        boolean allMethods = true;
        if (args2.length == 0) {
            methodNames = null;
        } else if (args2.length == 1 && args2[0] instanceof RubyBoolean) {
            allMethods = args2[0].isTrue();
            methodNames = null;
        } else {
            methodNames = (IRubyObject[])args2.clone();
            Arrays.sort(methodNames);
        }
        RubyClass implClass = RubyClass.newClass(runtime, runtime.getObject());
        implClass.include(context, self2);
        BlockInterfaceImpl ifaceImpl = new BlockInterfaceImpl(implClass, implBlock, (IRubyObject[])methodNames);
        implClass.addMethod("method_missing", ifaceImpl);
        Class<?> ifaceClass = JavaClass.getJavaClass(context, (RubyModule)self2);
        if (methodNames == null) {
            BlockInterfaceImpl.ConcreteMethod implMethod = ifaceImpl.getConcreteMethod();
            for (Method method : ifaceClass.getMethods()) {
                if (method.isBridge() || method.isSynthetic() || Modifier.isStatic(method.getModifiers()) || !allMethods && !Modifier.isAbstract(method.getModifiers())) continue;
                implClass.addMethodInternal(method.getName(), implMethod);
            }
        } else {
            BlockInterfaceImpl.ConcreteMethod implMethod = ifaceImpl.getConcreteMethod();
            Method[] decMethods = ifaceClass.getDeclaredMethods();
            block1: for (Object methodName : methodNames) {
                String name2 = methodName.toString();
                for (int i2 = 0; i2 < decMethods.length; ++i2) {
                    Method method = decMethods[i2];
                    if (method.isBridge() || method.isSynthetic() || Modifier.isStatic(method.getModifiers()) || !name2.equals(decMethods[i2].getName())) continue;
                    implClass.addMethodInternal(name2, implMethod);
                    continue block1;
                }
                runtime.getWarnings().warn("`" + name2 + "' is not a declared method in interface " + ifaceClass.getName());
            }
        }
        return implClass.callMethod(context, "new");
    }

    private static JavaClass getJavaClassForInterface(IRubyObject module) {
        return (JavaClass)module.getInstanceVariables().getInstanceVariable("@java_class");
    }

    private static RubyArray getJavaInterfaces(IRubyObject clazz) {
        return (RubyArray)clazz.getInstanceVariables().getInstanceVariable("@java_interfaces");
    }

    private static RubyArray getInterfaceModules(IRubyObject module) {
        return (RubyArray)module.getInstanceVariables().getInstanceVariable("@java_interface_mods");
    }

    private static boolean initInterfaceModules(IRubyObject self2, IRubyObject module) {
        if (!module.getInstanceVariables().hasInstanceVariable("@java_interface_mods")) {
            RubyArray interfaceMods = RubyArray.newArray(self2.getRuntime(), self2);
            module.getInstanceVariables().setInstanceVariable("@java_interface_mods", interfaceMods);
            return true;
        }
        return false;
    }

    private static final class BlockInterfaceImpl
    extends JavaMethod {
        private final IRubyObject[] methodNames;
        private final Block implBlock;

        BlockInterfaceImpl(RubyClass implClass, Block implBlock, IRubyObject[] methodNames) {
            super(implClass, Visibility.PUBLIC);
            this.implBlock = implBlock;
            this.methodNames = methodNames;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context.runtime, name2, args2.length, 1, -1);
            return this.callImpl(context, clazz, block, args2);
        }

        private IRubyObject callImpl(ThreadContext context, RubyModule clazz, Block block, IRubyObject ... args2) {
            if (this.methodNames == null) {
                return this.implBlock.call(context, args2);
            }
            if (this.methodNames.length == 1 ? this.methodNames[0].equals(args2[0]) : Arrays.binarySearch(this.methodNames, args2[0]) >= 0) {
                return this.implBlock.call(context, args2);
            }
            return clazz.getSuperClass().callMethod(context, "method_missing", args2, block);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
            return this.callImpl(context, klazz, block, new IRubyObject[0]);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
            return this.callImpl(context, klazz, block, arg0);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.callImpl(context, klazz, block, arg0, arg1);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.callImpl(context, klazz, block, arg0, arg1, arg2);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }

        final ConcreteMethod getConcreteMethod() {
            return new ConcreteMethod();
        }

        private final class ConcreteMethod
        extends JavaMethod {
            ConcreteMethod() {
                super(BlockInterfaceImpl.this.implementationClass, Visibility.PUBLIC);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
                IRubyObject[] nargs = new IRubyObject[]{context.runtime.newSymbol(name2)};
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, nargs);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
                IRubyObject[] nargs = new IRubyObject[]{context.runtime.newSymbol(name2), arg0};
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, nargs);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
                IRubyObject[] nargs = new IRubyObject[]{context.runtime.newSymbol(name2), arg0, arg1};
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, nargs);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
                IRubyObject[] nargs = new IRubyObject[]{context.runtime.newSymbol(name2), arg0, arg1, arg2};
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, nargs);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
                switch (args2.length) {
                    case 0: {
                        return this.call(context, self2, klazz, name2, block);
                    }
                    case 1: {
                        return this.call(context, self2, klazz, name2, args2[0], block);
                    }
                    case 2: {
                        return this.call(context, self2, klazz, name2, args2[0], args2[1], block);
                    }
                    case 3: {
                        return this.call(context, self2, klazz, name2, args2[0], args2[1], args2[2], block);
                    }
                }
                IRubyObject[] nargs = new IRubyObject[args2.length + 1];
                nargs[0] = context.runtime.newSymbol(name2);
                System.arraycopy(args2, 0, nargs, 1, args2.length);
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, nargs);
            }
        }
    }

    private static class AppendFeatures
    extends JavaMethod.JavaMethodOneBlock {
        AppendFeatures(RubyModule singletonClass) {
            super(singletonClass, Visibility.PUBLIC);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2, Block block) {
            if (!(arg2 instanceof RubyModule)) {
                throw context.runtime.newTypeError("append_features called with non-module");
            }
            RubyModule target = (RubyModule)arg2;
            target.include(JavaInterfaceTemplate.getInterfaceModules(self2).toJavaArrayMaybeUnsafe());
            return Helpers.invokeAs(context, clazz.getSuperClass(), self2, name2, arg2, block);
        }
    }

    private static class JavaClassAccessor
    extends JavaMethod.JavaMethodZero {
        JavaClassAccessor(RubyClass klass) {
            super(klass, Visibility.PUBLIC);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            Object wrapped = self2.dataGetStruct();
            Class<?> javaClass = wrapped != null ? ((JavaObject)wrapped).getJavaClass() : self2.getClass();
            return JavaClass.get(context.runtime, javaClass);
        }
    }

    private static final class InterfaceProxyFactory
    extends JavaMethod.JavaMethodN {
        InterfaceProxyFactory(RubyClass clazz) {
            super(clazz, Visibility.PRIVATE);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return JavaInterfaceTemplate.newInterfaceProxy(self2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
            return JavaInterfaceTemplate.newInterfaceProxy(self2);
        }
    }

    private static class DummyMethodImpl
    extends JavaMethod {
        DummyMethodImpl(RubyModule targetModule) {
            super(targetModule, Visibility.PUBLIC);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return context.nil;
        }
    }
}

