/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.URLUtil;

public class LoadServiceResource {
    private final URL resource;
    private final File path;
    private final String name;
    private final boolean absolute;
    private String absolutePath;

    public LoadServiceResource(URL resource2, String name2) {
        this.resource = resource2;
        this.path = null;
        this.name = name2;
        this.absolute = false;
    }

    public LoadServiceResource(URL resource2, String name2, boolean absolute) {
        this.resource = resource2;
        this.path = null;
        this.name = name2;
        this.absolute = absolute;
    }

    public LoadServiceResource(File path2, String name2) {
        this.resource = null;
        this.path = path2;
        this.name = name2;
        this.absolute = false;
    }

    public LoadServiceResource(File path2, String name2, boolean absolute) {
        this.resource = null;
        this.path = path2;
        this.name = name2;
        this.absolute = absolute;
    }

    public InputStream getInputStream() throws IOException {
        if (this.resource != null) {
            try (InputStream is = this.resource.openStream();){
                LoadServiceResourceInputStream loadServiceResourceInputStream = new LoadServiceResourceInputStream(is);
                return loadServiceResourceInputStream;
            }
        }
        byte[] bytes2 = new byte[(int)this.path.length()];
        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
        FileInputStream fis = new FileInputStream(this.path);
        FileChannel fc = fis.getChannel();
        fc.read(buffer);
        fis.close();
        return new LoadServiceResourceInputStream(bytes2);
    }

    public String getName() {
        return this.name;
    }

    public File getPath() {
        return this.path;
    }

    public URL getURL() throws IOException {
        if (this.resource != null) {
            return this.resource;
        }
        String absolutePath = this.path.getAbsolutePath();
        try {
            return new URI("file", absolutePath, null).toURL();
        }
        catch (URISyntaxException e) {
            try {
                return new URI("file", this.escapeReservedChars(absolutePath), null).toURL();
            }
            catch (URISyntaxException ee) {
                throw new IOException(ee.getMessage());
            }
        }
    }

    private String escapeReservedChars(String path2) {
        return path2.replaceAll("\\[", "%5b").replaceAll("\\]", "%5a");
    }

    public String getAbsolutePath() {
        if (this.absolutePath != null) {
            return this.absolutePath;
        }
        try {
            this.absolutePath = new File(URLUtil.getPath(this.getURL())).getCanonicalPath();
            return this.absolutePath;
        }
        catch (IOException e) {
            this.absolutePath = this.resource.toString();
            return this.absolutePath;
        }
    }

    public boolean isAbsolute() {
        return this.absolute;
    }
}

