/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Deprecated
public final class REPLMessage {
    public static final String AST = "ast";
    public static final String AST_DEPTH = "show-max-depth";
    public static final String BACKTRACE = "backtrace";
    public static final String BREAK_AT_LINE = "break-at-line";
    public static final String BREAK_AT_LINE_ONCE = "break-at-line-once";
    @Deprecated
    public static final String BREAK_AT_THROW = "break-at-throw";
    @Deprecated
    public static final String BREAK_AT_THROW_ONCE = "break-at-throw-once";
    public static final String BREAKPOINT_CONDITION = "breakpoint-condition";
    public static final String BREAKPOINT_HIT_COUNT = "breakpoint-hit-count";
    public static final String BREAKPOINT_ID = "breakpoint-id";
    public static final String BREAKPOINT_IGNORE_COUNT = "breakpoint-ignore-count";
    public static final String BREAKPOINT_INFO = "breakpoint-info";
    public static final String BREAKPOINT_STATE = "breakpoint-state";
    public static final String CALL = "call";
    public static final String ARG0 = "call-argument-0";
    public static final String ARG1 = "call-argument-1";
    public static final String ARG2 = "call-argument-2";
    public static final String ARG3 = "call-argument-3";
    public static final String ARG4 = "call-argument-4";
    public static final String ARG5 = "call-argument-5";
    public static final String ARG6 = "call-argument-6";
    public static final String ARG7 = "call-argument-7";
    public static final String ARG8 = "call-argument-8";
    public static final String ARG9 = "call-argument-9";
    public static final String CALL_NAME = "call-name";
    public static final String CLEAR_BREAK = "clear-breakpoint";
    public static final String CODE = "code";
    public static final String CONTINUE = "continue";
    public static final String DEBUG_LEVEL = "debug-level";
    public static final String DELETE_BREAK = "delete-breakpoint";
    public static final String DISABLE_BREAK = "disable-breakpoint";
    public static final String DISPLAY_MSG = "displayable-message";
    public static final String DOWN = "down";
    public static final String ENABLE_BREAK = "enable-breakpoint";
    public static final String EVAL = "eval";
    public static final String FAILED = "failed";
    public static final String FILE = "file";
    public static final String FILE_PATH = "path";
    public static final String FRAME = "frame";
    public static final String FRAME_INFO = "frame-info";
    public static final String FRAME_NUMBER = "frame-number";
    public static final String INFO = "info";
    public static final String INFO_CURRENT_LANGUAGE = "info-current-language";
    public static final String INFO_KEY = "info-key";
    public static final String INFO_SUPPORTED_LANGUAGES = "info-supported-languages";
    public static final String INFO_VALUE = "info-value";
    public static final String KILL = "kill";
    public static final String LANG_NAME = "language-name";
    public static final String LANG_VER = "language-version";
    public static final String LANG_MIME = "language-MIME type";
    public static final String LINE_NUMBER = "line-number";
    public static final String LIST = "list";
    public static final String LOAD_SOURCE = "load-source";
    public static final String METHOD_NAME = "method-name";
    public static final String OP = "op";
    public static final String OPTION = "option";
    public static final String QUIT = "quit";
    public static final String REPEAT = "repeat";
    public static final String SET = "set";
    public static final String SET_BREAK_CONDITION = "set-breakpoint-condition";
    public static final String SET_LANGUAGE = "set-language";
    public static final String SLOT_ID = "slot-identifier";
    public static final String SLOT_INDEX = "slot-index";
    public static final String SLOT_VALUE = "slot-value";
    public static final String SOURCE_LINE_TEXT = "source-line-text";
    public static final String SOURCE_LOCATION = "source-location";
    public static final String SOURCE_NAME = "source-name";
    public static final String SOURCE_TEXT = "source-text";
    public static final String STACK_SIZE = "stack-size";
    public static final String STATUS = "status";
    public static final String STEP_INTO = "step-into";
    public static final String STEP_OUT = "step-out";
    public static final String STEP_OVER = "step-over";
    public static final String STOPPED = "stopped";
    public static final String SUB = "sub";
    public static final String SUBTREE = "subtree";
    public static final String SUCCEEDED = "succeeded";
    public static final String TOPIC = "topic";
    public static final String TRUE = "true";
    public static final String TRUFFLE = "truffle";
    public static final String TRUFFLE_AST = "truffle-ast";
    public static final String TRUFFLE_NODE = "truffle-node";
    public static final String TRUFFLE_SUBTREE = "truffle-subtree";
    public static final String UNSET_BREAK_CONDITION = "unset-breakpoint-condition";
    public static final String UP = "up";
    public static final String VALUE = "value";
    public static final String WARNINGS = "warnings";
    public static final String WELCOME_MESSAGE = "welcome-message";
    public static final String[] ARG_NAMES = new String[]{"call-argument-0", "call-argument-1", "call-argument-2", "call-argument-3", "call-argument-4", "call-argument-5", "call-argument-6", "call-argument-7", "call-argument-8", "call-argument-9"};
    private final Map<String, String> map;

    public REPLMessage() {
        this.map = new TreeMap<String, String>();
    }

    public REPLMessage(String key, String value) {
        this();
        this.map.put(key, value);
    }

    public REPLMessage(REPLMessage message) {
        this.map = new TreeMap<String, String>(message.map);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public Integer getIntValue(String key) {
        String value = this.map.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    public String remove(String key) {
        return this.map.remove(key);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public void print(PrintStream out, String linePrefix) {
        this.map.keySet();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String value = entry.getValue();
            if (value != null && value.length() > 50) {
                value = value.substring(0, 50) + " ...";
            }
            out.println(linePrefix + entry.getKey() + " = \"" + value + "\"");
        }
    }
}

