/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import jnr.constants.platform.Errno;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.exception.ExceptionOperations;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rubinius.ByteArrayNodes;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.util.ByteList;

public abstract class IOBufferPrimitiveNodes {
    private static final int IOBUFFER_SIZE = 32768;
    private static final int STACK_BUF_SZ = 8192;

    @Primitive(name="iobuffer_fill", unsafe={UnsafeGroup.IO})
    public static abstract class IOBufferFillPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public int fill(VirtualFrame frame, DynamicObject ioBuffer, DynamicObject io, @Cached(value="create()") BranchProfile errorProfile) {
            int bytesRead;
            int fd = Layouts.IO.getDescriptor(io);
            byte[] readBuffer = new byte[8192];
            int count = 8192;
            if (this.left(frame, ioBuffer) < count) {
                count = this.left(frame, ioBuffer);
            }
            if ((bytesRead = this.performFill(fd, readBuffer, count)) > 0) {
                if (bytesRead > this.left(frame, ioBuffer)) {
                    errorProfile.enter();
                    throw new RaiseException(this.coreExceptions().internalError("IO buffer overrun", this));
                }
                int used = Layouts.IO_BUFFER.getUsed(ioBuffer);
                ByteList storage = Layouts.BYTE_ARRAY.getBytes(Layouts.IO_BUFFER.getStorage(ioBuffer));
                System.arraycopy(readBuffer, 0, storage.getUnsafeBytes(), storage.getBegin() + used, bytesRead);
                storage.setRealSize(used + bytesRead);
                Layouts.IO_BUFFER.setUsed(ioBuffer, used + bytesRead);
            }
            return bytesRead;
        }

        @CompilerDirectives.TruffleBoundary
        private int performFill(int fd, byte[] readBuffer, int count) {
            int bytesRead;
            while ((bytesRead = this.posix().read(fd, readBuffer, count)) == -1) {
                int errno = this.posix().errno();
                if (errno == Errno.ECONNRESET.intValue() || errno == Errno.ETIMEDOUT.intValue()) {
                    bytesRead = 0;
                    break;
                }
                if (errno == Errno.EAGAIN.intValue() || errno == Errno.EINTR.intValue()) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
                throw new RaiseException(ExceptionOperations.createRubyException(this.coreLibrary().getErrnoClass(Errno.valueOf((long)errno))));
            }
            return bytesRead;
        }

        private int left(VirtualFrame frame, DynamicObject ioBuffer) {
            int total = Layouts.IO_BUFFER.getTotal(ioBuffer);
            int used = Layouts.IO_BUFFER.getUsed(ioBuffer);
            return total - used;
        }
    }

    @Primitive(name="iobuffer_unshift", lowerFixnumParameters={1}, unsafe={UnsafeGroup.IO})
    public static abstract class IOBufferUnshiftPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public int unshift(VirtualFrame frame, DynamicObject ioBuffer, DynamicObject string, int startPosition) {
            Layouts.IO_BUFFER.setWriteSynced(ioBuffer, false);
            Rope rope = StringOperations.rope(string);
            int stringSize = rope.byteLength() - startPosition;
            int usedSpace = Layouts.IO_BUFFER.getUsed(ioBuffer);
            int availableSpace = 32768 - usedSpace;
            if (stringSize > availableSpace) {
                stringSize = availableSpace;
            }
            ByteList storage = Layouts.BYTE_ARRAY.getBytes(Layouts.IO_BUFFER.getStorage(ioBuffer));
            System.arraycopy(rope.getBytes(), startPosition, storage.getUnsafeBytes(), storage.begin() + usedSpace, stringSize);
            Layouts.IO_BUFFER.setUsed(ioBuffer, usedSpace + stringSize);
            return stringSize;
        }
    }

    @Primitive(name="iobuffer_allocate", unsafe={UnsafeGroup.IO})
    public static abstract class IOBufferAllocatePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public IOBufferAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject classToAllocate) {
            return this.allocateNode.allocate(classToAllocate, true, ByteArrayNodes.createByteArray(this.coreLibrary().getByteArrayFactory(), new ByteList(32768)), 0, 32768);
        }
    }
}

