/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.symbol;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.symbol.SymbolLayout;

@GeneratedBy(value=SymbolLayout.class)
public class SymbolLayoutImpl
extends BasicObjectLayoutImpl
implements SymbolLayout {
    public static final SymbolLayout INSTANCE = new SymbolLayoutImpl();
    protected static final Shape.Allocator SYMBOL_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey STRING_IDENTIFIER = new HiddenKey("string");
    protected static final Property STRING_PROPERTY = Property.create(STRING_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(String.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey ROPE_IDENTIFIER = new HiddenKey("rope");
    protected static final Property ROPE_PROPERTY = Property.create(ROPE_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(Rope.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey HASH_CODE_IDENTIFIER = new HiddenKey("hashCode");
    protected static final Property HASH_CODE_PROPERTY = Property.create(HASH_CODE_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected SymbolLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createSymbolShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new SymbolType(logicalClass, metaClass)).addProperty(STRING_PROPERTY).addProperty(ROPE_PROPERTY).addProperty(HASH_CODE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createSymbol(DynamicObjectFactory factory, String string, Rope rope, int hashCode) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (SymbolLayoutImpl.createsSymbol(factory));
        assert (factory.getShape().hasProperty(STRING_IDENTIFIER));
        assert (factory.getShape().hasProperty(ROPE_IDENTIFIER));
        assert (factory.getShape().hasProperty(HASH_CODE_IDENTIFIER));
        assert (string != null);
        assert (rope != null);
        return factory.newInstance(string, rope, hashCode);
    }

    @Override
    public boolean isSymbol(Object object) {
        return object instanceof DynamicObject && this.isSymbol((DynamicObject)object);
    }

    @Override
    public boolean isSymbol(DynamicObject object) {
        return SymbolLayoutImpl.isSymbol(object.getShape().getObjectType());
    }

    private static boolean isSymbol(ObjectType objectType) {
        return objectType instanceof SymbolType;
    }

    private static boolean createsSymbol(DynamicObjectFactory factory) {
        return SymbolLayoutImpl.isSymbol(factory.getShape().getObjectType());
    }

    @Override
    public String getString(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(STRING_IDENTIFIER));
        return (String)STRING_PROPERTY.get(object, this.isSymbol(object));
    }

    @Override
    public Rope getRope(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(ROPE_IDENTIFIER));
        return (Rope)ROPE_PROPERTY.get(object, this.isSymbol(object));
    }

    @Override
    public int getHashCode(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(HASH_CODE_IDENTIFIER));
        return (Integer)HASH_CODE_PROPERTY.get(object, this.isSymbol(object));
    }

    public static class SymbolType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public SymbolType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public SymbolType setLogicalClass(DynamicObject logicalClass) {
            return new SymbolType(logicalClass, this.metaClass);
        }

        @Override
        public SymbolType setMetaClass(DynamicObject metaClass) {
            return new SymbolType(this.logicalClass, metaClass);
        }
    }
}

