/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.ReadConstantNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.literal.ObjectLiteralNode;

public class ReadLiteralConstantNode
extends RubyNode {
    @Node.Child
    private ReadConstantNode readConstantNode;

    public ReadLiteralConstantNode(RubyContext context, SourceSection sourceSection, RubyNode moduleNode, String name) {
        super(context, sourceSection);
        ObjectLiteralNode nameNode = new ObjectLiteralNode(context, sourceSection, name);
        this.readConstantNode = new ReadConstantNode(context, sourceSection, false, false, moduleNode, nameNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readConstantNode.execute(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyConstant constant;
        String name = (String)this.readConstantNode.nameNode.execute(frame);
        Object isModuleDefined = this.readConstantNode.moduleNode.isDefined(frame);
        if (isModuleDefined == this.nil()) {
            return this.nil();
        }
        Object module = this.readConstantNode.moduleNode.execute(frame);
        if (!RubyGuards.isRubyModule(module)) {
            return this.nil();
        }
        try {
            constant = this.readConstantNode.lookupConstantNode.executeLookupConstant(frame, module, name);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (constant == null) {
            return this.nil();
        }
        return this.create7BitString("constant", (Encoding)UTF8Encoding.INSTANCE);
    }
}

