/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;

public class TypeAnnotationInfo
extends ClassFileStruct
implements IBinaryTypeAnnotation {
    private AnnotationInfo annotation;
    private int targetType = 0;
    private int info;
    private int info2;
    private int[] typePath;
    int readOffset = 0;

    TypeAnnotationInfo(byte[] byArray, int[] nArray, int n) {
        super(byArray, nArray, n);
    }

    TypeAnnotationInfo(byte[] byArray, int[] nArray, int n, boolean bl, boolean bl2) {
        this(byArray, nArray, n);
        this.readOffset = 0;
        this.targetType = this.u1At(0);
        switch (this.targetType) {
            case 0: 
            case 1: {
                this.info = this.u1At(1);
                this.readOffset += 2;
                break;
            }
            case 16: {
                this.info = this.u2At(1);
                this.readOffset += 3;
                break;
            }
            case 17: 
            case 18: {
                this.info = this.u1At(1);
                this.info2 = this.u1At(2);
                this.readOffset += 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                ++this.readOffset;
                break;
            }
            case 22: {
                this.info = this.u1At(1);
                this.readOffset += 2;
                break;
            }
            case 23: {
                this.info = this.u2At(1);
                this.readOffset += 3;
                break;
            }
            default: {
                throw new IllegalStateException("Target type not handled " + this.targetType);
            }
        }
        int n2 = this.u1At(this.readOffset);
        ++this.readOffset;
        if (n2 == 0) {
            this.typePath = NO_TYPE_PATH;
        } else {
            this.typePath = new int[n2 * 2];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                this.typePath[n3++] = this.u1At(this.readOffset++);
                this.typePath[n3++] = this.u1At(this.readOffset++);
            }
        }
        this.annotation = new AnnotationInfo(byArray, this.constantPoolOffsets, this.structOffset + this.readOffset, bl, bl2);
        this.readOffset += this.annotation.readOffset;
    }

    @Override
    public IBinaryAnnotation getAnnotation() {
        return this.annotation;
    }

    protected void initialize() {
        this.annotation.initialize();
    }

    @Override
    protected void reset() {
        this.annotation.reset();
        super.reset();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.annotation);
        stringBuffer.append(' ');
        stringBuffer.append("target_type=").append(this.targetType);
        stringBuffer.append(", info=").append(this.info);
        stringBuffer.append(", info2=").append(this.info2);
        if (this.typePath != NO_TYPE_PATH) {
            stringBuffer.append(", location=[");
            int n = this.typePath.length;
            block6: for (int i = 0; i < n; i += 2) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                switch (this.typePath[i]) {
                    case 0: {
                        stringBuffer.append("ARRAY");
                        continue block6;
                    }
                    case 1: {
                        stringBuffer.append("INNER_TYPE");
                        continue block6;
                    }
                    case 2: {
                        stringBuffer.append("WILDCARD");
                        continue block6;
                    }
                    case 3: {
                        stringBuffer.append("TYPE_ARGUMENT(").append(this.typePath[i + 1]).append(')');
                    }
                }
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public int getTargetType() {
        return this.targetType;
    }

    @Override
    public int getSupertypeIndex() {
        return this.info;
    }

    @Override
    public int getTypeParameterIndex() {
        return this.info;
    }

    @Override
    public int getBoundIndex() {
        return this.info2;
    }

    @Override
    public int getMethodFormalParameterIndex() {
        return this.info;
    }

    @Override
    public int getThrowsTypeIndex() {
        return this.info;
    }

    @Override
    public int[] getTypePath() {
        return this.typePath;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.targetType;
        n = 31 * n + this.info;
        n = 31 * n + this.info2;
        if (this.typePath != null) {
            int n2 = this.typePath.length;
            for (int i = 0; i < n2; ++i) {
                n = 31 * n + this.typePath[i];
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TypeAnnotationInfo typeAnnotationInfo = (TypeAnnotationInfo)object;
        if (this.targetType != typeAnnotationInfo.targetType) {
            return false;
        }
        if (this.info != typeAnnotationInfo.info) {
            return false;
        }
        if (this.info2 != typeAnnotationInfo.info2) {
            return false;
        }
        if (!Arrays.equals(this.typePath, typeAnnotationInfo.typePath)) {
            return false;
        }
        return this.annotation.equals(typeAnnotationInfo.annotation);
    }
}

