/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import java.util.Map;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LayoutProcessState;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.AbstractReportTarget;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.ReportTargetState;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.flow.StatefullReportTarget;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class LibLayoutReportTarget
extends AbstractReportTarget
implements StatefullReportTarget {
    private InputFeed feed;
    private NamespaceCollection namespaces;
    private LayoutProcess layoutProcess;

    public LibLayoutReportTarget(ReportJob reportJob, ResourceKey resourceKey, ResourceManager resourceManager, LayoutProcess layoutProcess) {
        super(reportJob, resourceManager, resourceKey);
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.feed = layoutProcess.getInputFeed();
    }

    protected LibLayoutReportTarget(ReportJob reportJob, ResourceKey resourceKey, ResourceManager resourceManager, LayoutProcess layoutProcess, NamespaceCollection namespaceCollection) {
        this(reportJob, resourceKey, resourceManager, layoutProcess);
        this.namespaces = namespaceCollection;
    }

    public ReportTargetState saveState() throws StateException {
        LibLayoutReportTargetState libLayoutReportTargetState = new LibLayoutReportTargetState();
        libLayoutReportTargetState.fill(this);
        return libLayoutReportTargetState;
    }

    public void commit() {
    }

    public NamespaceCollection getNamespaces() {
        return this.namespaces;
    }

    public boolean isPagebreakEncountered() {
        return this.layoutProcess.isPagebreakEncountered();
    }

    protected LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    protected InputFeed getInputFeed() {
        return this.feed;
    }

    public void startReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        try {
            InputFeed inputFeed = this.getInputFeed();
            inputFeed.startDocument();
            inputFeed.startMetaInfo();
            inputFeed.addDocumentAttribute("base-resource", (Object)reportStructureRoot.getBaseResource());
            inputFeed.addDocumentAttribute("resource-manager", (Object)reportStructureRoot.getResourceManager());
            String string = "false";
            if ("true".equals(string)) {
                inputFeed.addDocumentAttribute("strict-style-mode", (Object)Boolean.TRUE);
            }
            NamespaceDefinition[] namespaceDefinitionArray = this.createDefaultNameSpaces();
            for (int i = 0; i < namespaceDefinitionArray.length; ++i) {
                NamespaceDefinition namespaceDefinition = namespaceDefinitionArray[i];
                inputFeed.startMetaNode();
                inputFeed.setMetaNodeAttribute("type", (Object)"namespace");
                inputFeed.setMetaNodeAttribute("definition", (Object)namespaceDefinition);
                inputFeed.endMetaNode();
            }
            if (reportStructureRoot instanceof JFreeReport) {
                JFreeReport jFreeReport = (JFreeReport)reportStructureRoot;
                int n = jFreeReport.getStyleSheetCount();
                for (int i = 0; i < n; ++i) {
                    StyleSheet styleSheet = jFreeReport.getStyleSheet(i);
                    inputFeed.startMetaNode();
                    inputFeed.setMetaNodeAttribute("type", (Object)"style");
                    inputFeed.setMetaNodeAttribute("#content", (Object)styleSheet);
                    inputFeed.endMetaNode();
                }
            }
            inputFeed.endMetaInfo();
            this.namespaces = inputFeed.getNamespaceCollection();
        }
        catch (InputFeedException inputFeedException) {
            inputFeedException.printStackTrace();
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)inputFeedException));
        }
    }

    public void startElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        try {
            String string = ReportTargetUtil.getNamespaceFromAttribute(attributeMap);
            String string2 = ReportTargetUtil.getElemenTypeFromAttribute(attributeMap);
            InputFeed inputFeed = this.getInputFeed();
            inputFeed.startElement(string, string2);
            this.handleAttributes(attributeMap);
        }
        catch (InputFeedException inputFeedException) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)inputFeedException));
        }
    }

    public void processText(String string) throws DataSourceException, ReportProcessingException {
        try {
            InputFeed inputFeed = this.getInputFeed();
            inputFeed.addContent(string);
        }
        catch (InputFeedException inputFeedException) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)inputFeedException));
        }
    }

    public void processContent(DataFlags dataFlags) throws DataSourceException, ReportProcessingException {
        InputFeed inputFeed = this.getInputFeed();
        try {
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "content", dataFlags.getValue());
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isChanged", (Object)String.valueOf(dataFlags.isChanged()));
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isDate", (Object)String.valueOf(dataFlags.isDate()));
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isNegative", (Object)String.valueOf(dataFlags.isNegative()));
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isNull", (Object)String.valueOf(dataFlags.isNull()));
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isNumber", (Object)String.valueOf(dataFlags.isNumeric()));
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isPositive", (Object)String.valueOf(dataFlags.isPositive()));
            inputFeed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isZero", (Object)String.valueOf(dataFlags.isZero()));
        }
        catch (InputFeedException inputFeedException) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)inputFeedException));
        }
    }

    public NamespaceDefinition getNamespaceByUri(String string) {
        if (string == null) {
            return null;
        }
        return this.namespaces.getDefinition(string);
    }

    protected void handleAttributes(AttributeMap attributeMap) throws ReportProcessingException {
        try {
            InputFeed inputFeed = this.getInputFeed();
            String[] stringArray = attributeMap.getNameSpaces();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Map map = attributeMap.getAttributes(string);
                for (Map.Entry entry : map.entrySet()) {
                    inputFeed.setAttribute(string, (String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (InputFeedException inputFeedException) {
            throw new ReportProcessingException("Failed to set attribute", (Exception)((Object)inputFeedException));
        }
    }

    public void endElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        InputFeed inputFeed = this.getInputFeed();
        try {
            inputFeed.endElement();
        }
        catch (InputFeedException inputFeedException) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)inputFeedException));
        }
    }

    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        try {
            this.getInputFeed().endDocument();
        }
        catch (InputFeedException inputFeedException) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)inputFeedException));
        }
    }

    public void resetPagebreakFlag() {
        this.getInputFeed().resetPageBreakFlag();
    }

    public String getExportDescriptor() {
        return this.getLayoutProcess().getOutputMetaData().getExportDescriptor();
    }

    protected static class LibLayoutReportTargetState
    implements ReportTargetState {
        private LayoutProcessState layoutProcess;
        private ReportJob reportJob;
        private ResourceKey baseResourceKey;
        private ResourceManager resourceManager;
        private NamespaceCollection namespaceCollection;

        public void fill(LibLayoutReportTarget libLayoutReportTarget) throws StateException {
            this.layoutProcess = libLayoutReportTarget.getLayoutProcess().saveState();
            this.reportJob = libLayoutReportTarget.getReportJob();
            this.baseResourceKey = libLayoutReportTarget.getBaseResource();
            this.resourceManager = libLayoutReportTarget.getResourceManager();
            this.namespaceCollection = libLayoutReportTarget.getNamespaces();
        }

        public ReportTarget restore(OutputProcessor outputProcessor) throws StateException {
            LayoutProcess layoutProcess = this.layoutProcess.restore(outputProcessor);
            return new LibLayoutReportTarget(this.reportJob, this.baseResourceKey, this.resourceManager, layoutProcess, this.namespaceCollection);
        }
    }
}

