/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final Log defaultLogContext = LogFactory.getLog(LoggingErrorHandler.class);
    private Log logContext;

    public LoggingErrorHandler() {
        this.logContext = defaultLogContext;
    }

    public LoggingErrorHandler(Log logContext) {
        if (logContext == null) {
            throw new NullPointerException();
        }
        this.logContext = logContext;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.logContext.isDebugEnabled()) {
            if (exception.getMessage().startsWith("URI was not reported to parser for entity")) {
                return;
            }
            this.logContext.debug((Object)"Parser-Warning", (Throwable)exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.logContext.isWarnEnabled()) {
            if (this.logContext.isDebugEnabled()) {
                this.logContext.warn((Object)"Recoverable Parser-Error", (Throwable)exception);
            } else {
                this.logContext.warn((Object)("Recoverable Parser-Error:" + exception.getMessage()));
            }
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.logContext.isErrorEnabled()) {
            if (this.logContext.isDebugEnabled()) {
                this.logContext.error((Object)"Fatal Parser-Error", (Throwable)exception);
            } else {
                this.logContext.error((Object)("Fatal Parser-Error:" + exception.getMessage()));
            }
        }
    }
}

