/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.TextUtility;

public class BoxAlignContext
extends AlignContext {
    private long insetsTop;
    private long insetsBottom;
    private long[] baselines;
    private AlignContext firstChild;
    private AlignContext lastChild;

    public BoxAlignContext(RenderBox renderBox) {
        super(renderBox);
        ExtendedBaselineInfo extendedBaselineInfo = renderBox.getBaselineInfo();
        if (extendedBaselineInfo == null) {
            extendedBaselineInfo = renderBox.getNominalBaselineInfo();
        }
        CSSValue cSSValue = renderBox.getDominantBaseline();
        this.setDominantBaseline(TextUtility.translateDominantBaseline(cSSValue, extendedBaselineInfo.getDominantBaseline()));
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        this.insetsTop = computedLayoutProperties.getBorderTop() + computedLayoutProperties.getPaddingTop();
        this.insetsBottom = computedLayoutProperties.getBorderBottom() + computedLayoutProperties.getPaddingBottom();
        this.baselines = (long[])extendedBaselineInfo.getBaselines().clone();
        int n = 1;
        while (n < this.baselines.length) {
            int n2 = n++;
            this.baselines[n2] = this.baselines[n2] + this.insetsTop;
        }
        this.baselines[9] = this.baselines[8] + this.insetsBottom;
    }

    public void addChild(AlignContext alignContext) {
        if (this.lastChild == null) {
            this.firstChild = alignContext;
            this.lastChild = alignContext;
            return;
        }
        this.lastChild.setNext(alignContext);
        this.lastChild = alignContext;
    }

    public AlignContext getFirstChild() {
        return this.firstChild;
    }

    public long getInsetsTop() {
        return this.insetsTop;
    }

    public long getInsetsBottom() {
        return this.insetsBottom;
    }

    public long getBaselineDistance(int n) {
        return this.baselines[n] - this.baselines[this.getDominantBaseline()];
    }

    public void shift(long l) {
        int n = 0;
        while (n < this.baselines.length) {
            int n2 = n++;
            this.baselines[n2] = this.baselines[n2] + l;
        }
        for (AlignContext alignContext = this.getFirstChild(); alignContext != null; alignContext = alignContext.getNext()) {
            alignContext.shift(l);
        }
    }

    public long getAfterEdge() {
        return this.baselines[9];
    }

    public long getBeforeEdge() {
        return this.baselines[0];
    }

    public void setBeforeEdge(long l) {
        this.baselines[0] = l;
    }

    public void setAfterEdge(long l) {
        this.baselines[9] = l;
    }
}

