/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.PackageManager;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.PropertyFileConfiguration;
import org.pentaho.reporting.libraries.base.config.SystemPropertyConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public abstract class AbstractBoot
implements SubSystem {
    private static final Log LOGGER = LogFactory.getLog(AbstractBoot.class);
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;
    private Exception bootFailed;

    protected AbstractBoot() {
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = new PackageManager(this);
        }
        return this.packageManager;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
        }
        return this.globalConfig;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract Configuration loadConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        AbstractBoot abstractBoot = this;
        synchronized (abstractBoot) {
            if (this.isBootDone()) {
                return;
            }
            if (this.isBootFailed()) {
                LOGGER.error((Object)(this.getClass() + " failed to boot: " + this.bootFailed.getMessage()));
            }
            while (this.isBootInProgress()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.isBootDone()) {
                this.notifyAll();
                return;
            }
            this.bootInProgress = true;
        }
        try {
            ProjectInformation info = this.getProjectInfo();
            if (info != null) {
                this.performBootDependencies(info.getLibraries());
                this.performBootDependencies(info.getOptionalLibraries());
            }
            this.performBoot();
            if (info != null) {
                LOGGER.info((Object)(info.getName() + ' ' + info.getVersion() + " started."));
            } else {
                LOGGER.info((Object)(this.getClass() + " started."));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(this.getClass() + " failed to boot: "), (Throwable)e);
            this.bootFailed = e;
        }
        finally {
            AbstractBoot abstractBoot2 = this;
            synchronized (abstractBoot2) {
                this.bootInProgress = false;
                this.bootDone = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBootDependencies(DependencyInformation[] childs) {
        if (childs == null) {
            return;
        }
        for (int i = 0; i < childs.length; ++i) {
            ProjectInformation projectInformation;
            AbstractBoot boot;
            DependencyInformation child = childs[i];
            if (!(child instanceof ProjectInformation) || (boot = this.loadBooter((projectInformation = (ProjectInformation)child).getBootClass())) == null) continue;
            AbstractBoot abstractBoot = boot;
            synchronized (abstractBoot) {
                boot.start();
                while (!boot.isBootDone() && !boot.isBootFailed()) {
                    try {
                        boot.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (boot.isBootFailed()) {
                    this.bootFailed = boot.getBootFailureReason();
                    LOGGER.error((Object)("Dependent project failed to boot up: " + projectInformation.getBootClass() + " failed to boot: "), (Throwable)this.bootFailed);
                    return;
                }
                continue;
            }
        }
    }

    public boolean isBootFailed() {
        return this.bootFailed != null;
    }

    public Exception getBootFailureReason() {
        return this.bootFailed;
    }

    protected abstract void performBoot();

    protected abstract ProjectInformation getProjectInfo();

    protected AbstractBoot loadBooter(String classname) {
        return AbstractBoot.loadBooter(classname, this.getClass());
    }

    public static AbstractBoot loadBooter(String classname, Class source) {
        if (classname == null) {
            return null;
        }
        if (source == null) {
            throw new NullPointerException();
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(source);
            Class<?> c = Class.forName(classname, false, loader);
            Method m = c.getMethod("getInstance", null);
            return (AbstractBoot)m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            LOGGER.info((Object)("Unable to boot dependent class: " + classname));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration createDefaultHierarchicalConfiguration(String staticConfig, String userConfig, boolean addSysProps, Class source) {
        if (source == null) {
            throw new NullPointerException("SourceClass must not be null.");
        }
        HierarchicalConfiguration globalConfig = new HierarchicalConfiguration(this.getClass());
        if (staticConfig != null) {
            PropertyFileConfiguration rootProperty = new PropertyFileConfiguration();
            rootProperty.load(staticConfig, source);
            globalConfig.insertConfiguration(rootProperty);
            globalConfig.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (userConfig != null) {
            String userConfigStripped = userConfig.charAt(0) == '/' ? userConfig.substring(1) : userConfig;
            try {
                PropertyFileConfiguration baseProperty;
                Enumeration<URL> userConfigs = ObjectUtilities.getClassLoader(source).getResources(userConfigStripped);
                ArrayList<PropertyFileConfiguration> configs = new ArrayList<PropertyFileConfiguration>();
                while (userConfigs.hasMoreElements()) {
                    URL url = userConfigs.nextElement();
                    try {
                        baseProperty = new PropertyFileConfiguration();
                        InputStream in = url.openStream();
                        try {
                            baseProperty.load(in);
                        }
                        finally {
                            in.close();
                        }
                        configs.add(baseProperty);
                    }
                    catch (IOException ioe) {
                        LOGGER.warn((Object)("Failed to load the user configuration at " + url), (Throwable)ioe);
                    }
                }
                for (int i = configs.size() - 1; i >= 0; --i) {
                    baseProperty = (PropertyFileConfiguration)configs.get(i);
                    globalConfig.insertConfiguration(baseProperty);
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Failed to lookup the user configurations.", (Throwable)e);
            }
        }
        if (addSysProps) {
            SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
            globalConfig.insertConfiguration(systemConfig);
        }
        return globalConfig;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }
}

