/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.Enumerations;

public final class Exceptions {
    static final Logger LOG = Logger.getLogger(Exceptions.class.getName());
    private static final String LOC_MSG_PLACEHOLDER = "msg";

    private Exceptions() {
    }

    public static <E extends Throwable> E attachMessage(E e, String string) {
        AnnException annException = AnnException.findOrCreate(e, true);
        LogRecord logRecord = new LogRecord(Level.ALL, string);
        annException.addRecord(logRecord);
        return e;
    }

    public static <E extends Throwable> E attachLocalizedMessage(E e, final String string) {
        AnnException annException = AnnException.findOrCreate(e, true);
        LogRecord logRecord = new LogRecord(Level.ALL, LOC_MSG_PLACEHOLDER);
        ResourceBundle resourceBundle = new ResourceBundle(){

            @Override
            public Object handleGetObject(String string2) {
                if (Exceptions.LOC_MSG_PLACEHOLDER.equals(string2)) {
                    return string;
                }
                return null;
            }

            @Override
            public Enumeration<String> getKeys() {
                return Enumerations.singleton(Exceptions.LOC_MSG_PLACEHOLDER);
            }
        };
        logRecord.setResourceBundle(resourceBundle);
        annException.addRecord(logRecord);
        return e;
    }

    public static <E extends Throwable> E attachSeverity(E e, Level level) {
        AnnException annException = AnnException.findOrCreate(e, true);
        annException.addRecord(new LogRecord(level, null));
        return e;
    }

    public static String findLocalizedMessage(Throwable throwable) {
        while (throwable != null) {
            AnnException annException = (AnnException)AnnException.extras.get(throwable);
            String string = annException != null ? Exceptions.extractLocalizedMessage(annException) : Exceptions.extractLocalizedMessage(throwable);
            if (string != null) {
                return string;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    private static String extractLocalizedMessage(Throwable throwable) {
        String string = null;
        if (throwable instanceof Callable) {
            Object var2_2 = null;
            try {
                var2_2 = ((Callable)((Object)throwable)).call();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, throwable);
            }
            if (var2_2 instanceof LogRecord[]) {
                for (LogRecord logRecord : (LogRecord[])var2_2) {
                    ResourceBundle resourceBundle = logRecord.getResourceBundle();
                    if (resourceBundle == null) continue;
                    string = resourceBundle.getString(logRecord.getMessage());
                    break;
                }
            }
        }
        return string;
    }

    public static void printStackTrace(Throwable object) {
        Object object2;
        AnnException annException = AnnException.findOrCreate((Throwable)object, false);
        Level level = null;
        if (annException != null) {
            object2 = annException.records.iterator();
            while (object2.hasNext()) {
                LogRecord logRecord = (LogRecord)object2.next();
                if (logRecord.getLevel() == Level.ALL) continue;
                level = logRecord.getLevel();
                break;
            }
        }
        if (level == null) {
            level = OwnLevel.UNKNOWN;
        }
        if ((object2 = (AnnException)AnnException.extras.get(object)) != null) {
            assert (object == ((Throwable)object2).getCause());
            object = object2;
        }
        LOG.log(level, null, (Throwable)object);
    }

    private static final class OwnLevel
    extends Level {
        public static final Level UNKNOWN = new OwnLevel("SEVERE", Level.SEVERE.intValue() + 1);

        private OwnLevel(String string, int n) {
            super(string, n);
        }
    }

    static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;
        private static Map<Throwable, AnnException> extras = new WeakHashMap<Throwable, AnnException>();

        private AnnException() {
        }

        private AnnException(String string) {
            super(string);
        }

        @Override
        public String getMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            List<LogRecord> list = this.records;
            if (list != null) {
                for (LogRecord logRecord : list) {
                    String string2 = logRecord.getMessage();
                    if (string2 == null || string2.equals(Exceptions.LOC_MSG_PLACEHOLDER)) continue;
                    stringBuilder.append(string);
                    stringBuilder.append(string2);
                    string = "\n";
                }
            }
            return stringBuilder.toString();
        }

        static AnnException findOrCreate(Throwable throwable, boolean bl) {
            AnnException annException;
            block4: {
                try {
                    annException = AnnException.findOrCreate0(throwable, bl);
                    if (annException != null) {
                        return annException;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    assert (bl);
                    annException = extras.get(throwable);
                    if (annException != null) break block4;
                    annException = new AnnException(throwable.getMessage());
                    annException.initCause(throwable);
                    LOG.log(Level.FINE, "getCause was null yet initCause failed for " + throwable, illegalStateException);
                    extras.put(throwable, annException);
                }
            }
            return annException;
        }

        private static AnnException findOrCreate0(Throwable throwable, boolean bl) {
            if (throwable instanceof AnnException) {
                return (AnnException)throwable;
            }
            if (throwable.getCause() == null) {
                if (bl) {
                    AnnException annException = new AnnException();
                    throwable.initCause(annException);
                    if (annException != throwable.getCause()) {
                        throw new IllegalStateException();
                    }
                }
                return (AnnException)throwable.getCause();
            }
            return AnnException.findOrCreate0(throwable.getCause(), bl);
        }

        public synchronized void addRecord(LogRecord logRecord) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(logRecord);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> list = this.records;
            LogRecord[] logRecordArray = new LogRecord[]{};
            return list == null ? logRecordArray : list.toArray(logRecordArray);
        }

        @Override
        public void printStackTrace(PrintStream printStream) {
            super.printStackTrace(printStream);
            this.logRecords(printStream);
        }

        @Override
        public void printStackTrace(PrintWriter printWriter) {
            super.printStackTrace(printWriter);
            this.logRecords(printWriter);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }

        private void logRecords(Appendable appendable) {
            List<LogRecord> list = this.records;
            if (list == null) {
                return;
            }
            try {
                for (LogRecord logRecord : list) {
                    if (logRecord.getMessage() != null) {
                        appendable.append(logRecord.getMessage()).append("\n");
                    }
                    if (logRecord.getThrown() == null) continue;
                    StringWriter stringWriter = new StringWriter();
                    logRecord.getThrown().printStackTrace(new PrintWriter(stringWriter));
                    appendable.append(stringWriter.toString()).append("\n");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

