/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CheckboxInplaceEditor;
import org.openide.explorer.propertysheet.ComboInplaceEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.IconPanel;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.InplaceEditorFactory;
import org.openide.explorer.propertysheet.ModelProperty;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDisplayer;
import org.openide.explorer.propertysheet.PropertyDisplayer_Inline;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.RadioInplaceEditor;
import org.openide.explorer.propertysheet.RendererPropertyDisplayer;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

class EditorPropertyDisplayer
extends JComponent
implements PropertyDisplayer_Inline,
InplaceEditor.Factory {
    private Node.Property prop = null;
    private InplaceEditor inplace = null;
    private JComponent inner = null;
    private int radioButtonMax = 0;
    private boolean showCustomEditorButton = true;
    private boolean tableUI = false;
    private boolean useLabels = true;
    private PropertyEnv env = null;
    private boolean radioBoolean = false;
    protected WeakReference<PropertyModel> modelRef = null;
    protected boolean inReplaceInner = false;
    private InplaceEditorFactory factory1 = null;
    private InplaceEditorFactory factory2 = null;
    private ReusablePropertyEnv reusableEnv = new ReusablePropertyEnv();

    public EditorPropertyDisplayer(Node.Property property) {
        this(property, null);
    }

    EditorPropertyDisplayer(Node.Property property, PropertyModel propertyModel) {
        if (property == null) {
            throw new NullPointerException("Property may not be null");
        }
        this.prop = property;
        if (propertyModel != null) {
            this.modelRef = new WeakReference<PropertyModel>(propertyModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        try {
            if (this.inner == null) {
                this.replaceInner();
            }
        }
        finally {
            super.addNotify();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && this.inner != null) {
            this.inner.requestFocus();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setInplaceEditor(null);
        this.reusableEnv.clear();
    }

    @Override
    public final Component getComponent() {
        return this;
    }

    @Override
    public final Node.Property getProperty() {
        return this.prop;
    }

    @Override
    public final int getRadioButtonMax() {
        return this.radioButtonMax;
    }

    @Override
    public final boolean isShowCustomEditorButton() {
        Boolean bl;
        boolean bl2 = this.showCustomEditorButton;
        if (this.getProperty() != null && (bl = (Boolean)this.getProperty().getValue("suppressCustomEditor")) != null) {
            bl2 = bl == false;
        }
        return bl2;
    }

    @Override
    public final boolean isTableUI() {
        return this.tableUI;
    }

    @Override
    public final void refresh() {
        if (this.isDisplayable()) {
            this.replaceInner();
        }
    }

    @Override
    public final boolean isUseLabels() {
        return this.useLabels;
    }

    @Override
    public final void setRadioButtonMax(int n) {
        if (n != this.radioButtonMax) {
            InplaceEditor inplaceEditor;
            int n2 = this.radioButtonMax;
            boolean bl = false;
            if (this.inplace != null && ((inplaceEditor = PropUtils.findInnermostInplaceEditor(this.inplace)) instanceof JComboBox || inplaceEditor instanceof RadioInplaceEditor)) {
                PropertyEditor propertyEditor = inplaceEditor.getPropertyEditor();
                int n3 = propertyEditor.getTags() == null ? -1 : propertyEditor.getTags().length;
                bl = n2 <= n3 != n <= n3;
            }
            this.radioButtonMax = n;
            if (bl && this.inner != null) {
                this.replaceInner();
                this.firePropertyChange("preferredSize", null, null);
            }
        }
    }

    @Override
    public final void setShowCustomEditorButton(boolean bl) {
        Node.Property property;
        Boolean bl2;
        if (this.getProperty() != null && (bl2 = (Boolean)(property = this.getProperty()).getValue("suppressCustomEditor")) != null) {
            bl = bl2;
            System.err.println("Found explicit value: " + bl);
        }
        if (this.showCustomEditorButton != bl) {
            this.showCustomEditorButton = bl;
            this.replaceInner();
        }
    }

    @Override
    public final void setTableUI(boolean bl) {
        if (bl != this.tableUI) {
            this.tableUI = bl;
            this.replaceInner();
        }
    }

    @Override
    public final void setUseLabels(boolean bl) {
        if (bl != this.useLabels) {
            boolean bl2 = false;
            if (this.isShowing()) {
                InplaceEditor inplaceEditor = PropUtils.findInnermostInplaceEditor(this.inplace);
                bl2 = inplaceEditor instanceof RadioInplaceEditor || inplaceEditor instanceof JCheckBox;
            }
            this.useLabels = bl;
            if (bl2 && this.inner != null) {
                this.replaceInner();
            }
        }
    }

    @Override
    public final void requestFocus() {
        if (this.inner != null) {
            this.inner.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension dimension = this.inner == null ? new RendererPropertyDisplayer(this.getProperty()).getRenderer(this).getPreferredSize() : this.inner.getPreferredSize();
        return dimension;
    }

    @Override
    public final boolean requestFocusInWindow() {
        boolean bl = this.inner != null ? this.inner.requestFocusInWindow() : super.requestFocusInWindow();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installInner(JComponent jComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.inner != null) {
                this.remove(this.inner);
            }
            this.inner = jComponent;
            if (this.inner != null) {
                jComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.add(jComponent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void replaceInner() {
        this.inReplaceInner = true;
        try {
            boolean bl;
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            boolean bl2 = this.isEnabled() && (component == this || this.isAncestorOf(component) || this.getInplaceEditor() != null && this.getInplaceEditor().isKnownComponent(component));
            boolean bl3 = bl = bl2 && component instanceof JComboBox && ((JComboBox)component).isPopupVisible() && EventQueue.getCurrentEvent() instanceof KeyEvent && (((KeyEvent)EventQueue.getCurrentEvent()).getKeyCode() == 38 || ((KeyEvent)EventQueue.getCurrentEvent()).getKeyCode() == 40);
            if (bl2) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            this.setInplaceEditor(this.createInplaceEditor());
            if (bl2) {
                this.requestFocus();
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InplaceEditor inplaceEditor = EditorPropertyDisplayer.this.getInplaceEditor();
                            JComponent jComponent = (inplaceEditor = PropUtils.findInnermostInplaceEditor(inplaceEditor)).getComponent();
                            if (jComponent instanceof JComboBox && jComponent.isShowing()) {
                                ((JComboBox)jComponent).showPopup();
                            }
                        }
                    });
                }
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.inReplaceInner = false;
        }
    }

    protected final JComponent getInner() {
        return this.inner;
    }

    protected void setInplaceEditor(InplaceEditor inplaceEditor) {
        if (this.inplace != inplaceEditor) {
            if (this.inplace != null) {
                this.inplace.clear();
            }
            this.inplace = inplaceEditor;
            if (inplaceEditor == null) {
                this.installInner(null);
            } else {
                JComponent jComponent = this.inplace.getComponent();
                this.prepareComponent(this.inplace);
                this.installInner(jComponent);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.inner != null) {
            this.inner.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.inner != null) {
            if (this.inplace != null && this.inplace.supportsTextEntry()) {
                this.inner.setBackground(PropUtils.getTextFieldBackground());
            } else {
                this.inner.setBackground(color);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.inner != null) {
            if (this.inplace != null && this.inplace.supportsTextEntry()) {
                this.inner.setForeground(PropUtils.getTextFieldForeground());
            } else {
                this.inner.setForeground(color);
            }
        }
    }

    protected void prepareComponent(InplaceEditor inplaceEditor) {
        InplaceEditor inplaceEditor2 = PropUtils.findInnermostInplaceEditor(inplaceEditor);
        JComponent jComponent = inplaceEditor2.getComponent();
        if (!this.isTableUI() && inplaceEditor.supportsTextEntry()) {
            jComponent.setBackground(PropUtils.getTextFieldBackground());
            jComponent.setForeground(PropUtils.getTextFieldForeground());
        } else {
            jComponent.setBackground(this.getBackground());
            if (!this.isEnabled() || !this.prop.canWrite()) {
                jComponent.setForeground(UIManager.getColor("textInactiveText"));
            } else {
                jComponent.setForeground(this.getForeground());
            }
        }
        if (jComponent instanceof ComboInplaceEditor) {
            jComponent.setEnabled(this.isEnabled() && this.getPropertyEnv().isEditable());
        } else {
            jComponent.setEnabled(this.isEnabled() && PropUtils.checkEnabled(this, inplaceEditor.getPropertyEditor(), this.getPropertyEnv()));
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (this.inner != null) {
            this.inner.setBounds(0, 0, n3, n4);
        }
        super.reshape(n, n2, n3, n4);
    }

    protected void setPropertyEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }

    public final PropertyEnv getPropertyEnv() {
        return this.env;
    }

    @Override
    public final InplaceEditor getInplaceEditor() {
        return this.inplace;
    }

    protected void configureButtonPanel(ButtonPanel buttonPanel) {
    }

    static final FeatureDescriptor findFeatureDescriptor(PropertyDisplayer propertyDisplayer) {
        EditorPropertyDisplayer editorPropertyDisplayer;
        if (propertyDisplayer instanceof EditorPropertyDisplayer) {
            FeatureDescriptor featureDescriptor;
            PropertyModel propertyModel;
            editorPropertyDisplayer = (EditorPropertyDisplayer)propertyDisplayer;
            if (editorPropertyDisplayer.modelRef != null && (propertyModel = (PropertyModel)editorPropertyDisplayer.modelRef.get()) instanceof ExPropertyModel && (featureDescriptor = ((ExPropertyModel)propertyModel).getFeatureDescriptor()) != null) {
                return featureDescriptor;
            }
        }
        if ((editorPropertyDisplayer = propertyDisplayer.getProperty()) instanceof ModelProperty) {
            return ((ModelProperty)((Object)editorPropertyDisplayer)).getFeatureDescriptor();
        }
        if (editorPropertyDisplayer instanceof ModelProperty.DPMWrapper) {
            return ((ModelProperty.DPMWrapper)((Object)editorPropertyDisplayer)).getFeatureDescriptor();
        }
        return editorPropertyDisplayer;
    }

    private InplaceEditor createInplaceEditor() {
        Object object;
        Object object2;
        PropertyEnv propertyEnv = new PropertyEnv();
        propertyEnv.setFeatureDescriptor(EditorPropertyDisplayer.findFeatureDescriptor(this));
        Object object3 = this.factory(this).getInplaceEditor(this.getProperty(), propertyEnv, true);
        InplaceEditor inplaceEditor = object3;
        if (this.isShowCustomEditorButton() && inplaceEditor.getPropertyEditor().supportsCustomEditor()) {
            object2 = new ButtonPanel();
            ((ButtonPanel)object2).setInplaceEditor(inplaceEditor);
            this.configureButtonPanel((ButtonPanel)object2);
            object3 = object2;
        }
        object2 = null;
        if (propertyEnv.getState() == PropertyEnv.STATE_INVALID) {
            object2 = ImageUtilities.loadImageIcon((String)"org/openide/resources/propertysheet/invalid.gif", (boolean)false);
        } else if (this.getProperty().getValue("valueIcon") != null) {
            object = this.getProperty().getValue("valueIcon");
            object2 = object instanceof Image ? new ImageIcon((Image)object) : (Icon)object;
        }
        if (object2 != null) {
            object = new IconPanel();
            ((IconPanel)object).setIcon((Icon)object2);
            ((IconPanel)object).setInplaceEditor((InplaceEditor)object3);
            object3 = object;
        }
        this.setPropertyEnv(propertyEnv);
        return object3;
    }

    private InplaceEditorFactory factory(PropertyDisplayer_Inline propertyDisplayer_Inline) {
        InplaceEditorFactory inplaceEditorFactory;
        if (propertyDisplayer_Inline.isTableUI()) {
            if (this.factory1 == null) {
                this.factory1 = new InplaceEditorFactory(propertyDisplayer_Inline.isTableUI(), propertyDisplayer_Inline.getReusablePropertyEnv());
            }
            inplaceEditorFactory = this.factory1;
        } else {
            if (this.factory2 == null) {
                this.factory2 = new InplaceEditorFactory(propertyDisplayer_Inline.isTableUI(), propertyDisplayer_Inline.getReusablePropertyEnv());
            }
            inplaceEditorFactory = this.factory2;
        }
        inplaceEditorFactory.setUseRadioBoolean(propertyDisplayer_Inline.isRadioBoolean());
        inplaceEditorFactory.setRadioButtonMax(propertyDisplayer_Inline.getRadioButtonMax());
        inplaceEditorFactory.setUseLabels(propertyDisplayer_Inline.isUseLabels());
        return inplaceEditorFactory;
    }

    @Override
    public boolean isTitleDisplayed() {
        if (this.isUseLabels()) {
            InplaceEditor inplaceEditor = null;
            inplaceEditor = this.inplace != null ? this.inplace : this.createInplaceEditor();
            InplaceEditor inplaceEditor2 = PropUtils.findInnermostInplaceEditor(inplaceEditor);
            return inplaceEditor2 instanceof RadioInplaceEditor || inplaceEditor2 instanceof CheckboxInplaceEditor;
        }
        return false;
    }

    @Override
    public boolean isRadioBoolean() {
        return this.radioBoolean;
    }

    @Override
    public void setRadioBoolean(boolean bl) {
        this.radioBoolean = bl;
    }

    @Override
    public ReusablePropertyEnv getReusablePropertyEnv() {
        return this.reusableEnv;
    }

    static final Object[] findBeans(PropertyDisplayer propertyDisplayer) {
        EditorPropertyDisplayer editorPropertyDisplayer;
        Object[] objectArray = null;
        if (propertyDisplayer instanceof EditorPropertyDisplayer) {
            PropertyModel propertyModel;
            editorPropertyDisplayer = (EditorPropertyDisplayer)propertyDisplayer;
            if (editorPropertyDisplayer.modelRef != null && (propertyModel = (PropertyModel)editorPropertyDisplayer.modelRef.get()) instanceof ExPropertyModel) {
                objectArray = ((ExPropertyModel)propertyModel).getBeans();
            }
        }
        if (objectArray == null) {
            editorPropertyDisplayer = propertyDisplayer.getProperty();
            if (editorPropertyDisplayer instanceof ModelProperty) {
                objectArray = ((ModelProperty)((Object)editorPropertyDisplayer)).getBeans();
            } else if (editorPropertyDisplayer instanceof ModelProperty.DPMWrapper) {
                objectArray = ((ModelProperty.DPMWrapper)((Object)editorPropertyDisplayer)).getBeans();
            } else if (propertyDisplayer instanceof EditorPropertyDisplayer && ((EditorPropertyDisplayer)propertyDisplayer).getParent() instanceof PropertyPanel) {
                objectArray = ((PropertyPanel)((EditorPropertyDisplayer)propertyDisplayer).getParent()).getBeans();
            } else if (propertyDisplayer instanceof RendererPropertyDisplayer && ((RendererPropertyDisplayer)propertyDisplayer).getParent() instanceof PropertyPanel) {
                objectArray = ((PropertyPanel)((RendererPropertyDisplayer)propertyDisplayer).getParent()).getBeans();
            }
        }
        return objectArray;
    }
}

