/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NumberList {
    private static final int NUMBERS_IN_BLOCK = 3;
    private final File dataFile = File.createTempFile("NBProfiler", ".ref");
    private final RandomAccessFile data = new RandomAccessFile(this.dataFile, "rw");
    private final int numberSize;
    private final int blockSize;
    private final Map blockCache;
    private final Set dirtyBlocks;
    private long blocks;
    private MappedByteBuffer buf;
    private long mappedSize;

    NumberList(long l) throws IOException {
        this(NumberList.bytes(l));
    }

    NumberList(int n) throws IOException {
        this.numberSize = n;
        this.blockCache = new BlockLRUCache();
        this.dirtyBlocks = new HashSet(100000);
        this.blockSize = 4 * this.numberSize;
        this.dataFile.deleteOnExit();
        this.addBlock();
    }

    private static int bytes(long l) {
        if ((l & 0xFFFFFFFFFFFFFF00L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFF0000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFF000000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFF00000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFF0000000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFF000000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 7;
        }
        return 8;
    }

    protected void finalize() throws Throwable {
        this.dataFile.delete();
        super.finalize();
    }

    long addNumber(long l, long l2) throws IOException {
        long l3;
        int n;
        byte[] byArray = this.getBlock(l);
        for (n = 0; n < 3; ++n) {
            l3 = this.readNumber(byArray, n);
            if (l3 == 0L) {
                this.writeNumber(l, byArray, n, l2);
                return l;
            }
            if (l3 != l2) continue;
            return l;
        }
        l3 = this.addBlock();
        byArray = this.getBlock(l3);
        this.writeNumber(l3, byArray, n, l);
        this.writeNumber(l3, byArray, 0, l2);
        return l3;
    }

    long addFirstNumber(long l, long l2) throws IOException {
        long l3 = this.addBlock();
        byte[] byArray = this.getBlock(l3);
        this.writeNumber(l3, byArray, 0, l);
        this.writeNumber(l3, byArray, 1, l2);
        return l3;
    }

    void putFirst(long l, long l2) throws IOException {
        byte[] byArray;
        long l3 = l;
        long l4 = 0L;
        block0: do {
            byArray = this.getBlock(l3);
            for (int i = 0; i < 3; ++i) {
                long l5 = this.readNumber(byArray, i);
                if (l3 == l && i == 0) {
                    if (l2 == l5) {
                        return;
                    }
                    l4 = l5;
                    this.writeNumber(l3, byArray, i, l2);
                    continue;
                }
                if (l5 == 0L) continue block0;
                if (l5 != l2) continue;
                this.writeNumber(l3, byArray, i, l4);
                return;
            }
        } while ((l3 = this.getOffsetToNextBlock(byArray)) != 0L);
        System.out.println("Error - number not found at end");
    }

    long getFirstNumber(long l) throws IOException {
        byte[] byArray = this.getBlock(l);
        return this.readNumber(byArray, 0);
    }

    List getNumbers(long l) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (true) {
            long l2;
            byte[] byArray = this.getBlock(l);
            for (int i = 0; i < 3 && (l2 = this.readNumber(byArray, i)) != 0L; ++i) {
                arrayList.add(new Long(l2));
            }
            l2 = this.getOffsetToNextBlock(byArray);
            if (l2 == 0L) {
                return arrayList;
            }
            l = l2;
        }
    }

    private void mmapData() {
        if (this.buf == null && (long)this.blockSize * this.blocks < Integer.MAX_VALUE) {
            try {
                this.buf = this.data.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.data.length());
                this.mappedSize = (long)this.blockSize * this.blocks;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void flush() {
        try {
            this.flushDirtyBlocks();
            this.blockCache.clear();
            this.mmapData();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private long getOffsetToNextBlock(byte[] byArray) {
        return this.readNumber(byArray, 3);
    }

    private long readNumber(byte[] byArray, int n) {
        int n2 = n * this.numberSize;
        long l = 0L;
        if (this.numberSize == 4) {
            return (long)this.getInt(byArray, n2) & 0xFFFFFFFFL;
        }
        if (this.numberSize == 8) {
            return this.getLong(byArray, n2);
        }
        return l;
    }

    private int getInt(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    private long getLong(byte[] byArray, int n) {
        return ((long)byArray[n++] << 56) + ((long)(byArray[n++] & 0xFF) << 48) + ((long)(byArray[n++] & 0xFF) << 40) + ((long)(byArray[n++] & 0xFF) << 32) + ((long)(byArray[n++] & 0xFF) << 24) + (long)((byArray[n++] & 0xFF) << 16) + (long)((byArray[n++] & 0xFF) << 8) + (long)((byArray[n++] & 0xFF) << 0);
    }

    private void writeNumber(long l, byte[] byArray, int n, long l2) throws IOException {
        if (l < this.mappedSize) {
            long l3 = l + (long)(n * this.numberSize);
            this.buf.position((int)l3);
            for (int i = this.numberSize - 1; i >= 0; --i) {
                byte by = (byte)(l2 >> i * 8);
                this.buf.put(by);
            }
        } else {
            Long l4 = new Long(l);
            int n2 = n * this.numberSize;
            for (int i = this.numberSize - 1; i >= 0; --i) {
                byte by = (byte)(l2 >> i * 8);
                byArray[n2++] = by;
            }
            this.dirtyBlocks.add(l4);
            if (this.dirtyBlocks.size() > 10000) {
                this.flushDirtyBlocks();
            }
        }
    }

    private byte[] getBlock(long l) throws IOException {
        if (l < this.mappedSize) {
            byte[] byArray = new byte[this.blockSize];
            this.buf.position((int)l);
            this.buf.get(byArray);
            return byArray;
        }
        Long l2 = new Long(l);
        byte[] byArray = (byte[])this.blockCache.get(l2);
        if (byArray == null) {
            byArray = new byte[this.blockSize];
            this.data.seek(l);
            this.data.readFully(byArray);
            this.blockCache.put(l2, byArray);
        }
        return byArray;
    }

    private long addBlock() throws IOException {
        long l = this.blocks * (long)this.blockSize;
        this.blockCache.put(new Long(l), new byte[this.blockSize]);
        ++this.blocks;
        return l;
    }

    private void flushDirtyBlocks() throws IOException {
        if (this.dirtyBlocks.isEmpty()) {
            return;
        }
        Object[] objectArray = new Long[this.dirtyBlocks.size()];
        this.dirtyBlocks.toArray(objectArray);
        Arrays.sort(objectArray);
        byte[] byArray = new byte[1024 * this.blockSize];
        int n = 0;
        long l = 0L;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            byte[] byArray2 = (byte[])this.blockCache.get(object);
            long l2 = (Long)object;
            if (l + (long)n == l2 && n <= byArray.length - this.blockSize) {
                System.arraycopy(byArray2, 0, byArray, n, this.blockSize);
                n += this.blockSize;
                continue;
            }
            this.data.seek(l);
            this.data.write(byArray, 0, n);
            n = 0;
            System.arraycopy(byArray2, 0, byArray, n, this.blockSize);
            n += this.blockSize;
            l = l2;
        }
        this.data.seek(l);
        this.data.write(byArray, 0, n);
        this.dirtyBlocks.clear();
    }

    private class BlockLRUCache
    extends LinkedHashMap {
        private static final int MAX_CAPACITY = 10000;

        private BlockLRUCache() {
            super(10000, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > 10000) {
                Object k = entry.getKey();
                if (!NumberList.this.dirtyBlocks.contains(k)) {
                    return true;
                }
                this.get(k);
            }
            return false;
        }
    }
}

