/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DiplomacyMessage
extends DOMMessage {
    private final String ourId;
    private final String otherId;
    private DiplomaticTrade agreement;
    private Unit extraUnit;

    public DiplomacyMessage(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement) {
        super(DiplomacyMessage.getXMLElementTagName());
        this.ourId = our.getId();
        this.otherId = other.getId();
        this.agreement = agreement;
        this.extraUnit = null;
    }

    public DiplomacyMessage(Unit unit, Unit otherUnit, DiplomaticTrade agreement) {
        this((FreeColGameObject)unit, (FreeColGameObject)otherUnit, agreement);
    }

    public DiplomacyMessage(Unit unit, Colony colony, DiplomaticTrade agreement) {
        this((FreeColGameObject)unit, (FreeColGameObject)colony, agreement);
    }

    public DiplomacyMessage(Colony colony, Unit unit, DiplomaticTrade agreement) {
        this((FreeColGameObject)colony, (FreeColGameObject)unit, agreement);
    }

    public DiplomacyMessage(Game game, Element element) {
        super(DiplomacyMessage.getXMLElementTagName());
        this.ourId = element.getAttribute("ourId");
        this.otherId = element.getAttribute("otherId");
        NodeList nodes = element.getChildNodes();
        DiplomaticTrade diplomaticTrade = this.agreement = nodes.getLength() < 1 ? null : new DiplomaticTrade(game, (Element)nodes.item(0));
        if (nodes.getLength() < 2) {
            this.extraUnit = null;
        } else {
            Element ue = (Element)nodes.item(1);
            String id = FreeColObject.readId(ue);
            this.extraUnit = game.getFreeColGameObject(id, Unit.class);
            if (this.extraUnit == null) {
                this.extraUnit = new Unit(game, ue);
            }
        }
    }

    public Unit getExtraUnit() {
        return this.extraUnit;
    }

    public FreeColGameObject getOurFCGO(Game game) {
        return game.getFreeColGameObject(this.ourId);
    }

    public FreeColGameObject getOtherFCGO(Game game) {
        return game.getFreeColGameObject(this.otherId);
    }

    public DiplomaticTrade getAgreement() {
        return this.agreement;
    }

    public DiplomacyMessage setAgreement(DiplomaticTrade agreement) {
        this.agreement = agreement;
        return this;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = serverPlayer.getGame();
        if (this.agreement == null) {
            return DOMMessage.clientError("Null diplomatic agreement.");
        }
        Unit ourUnit = null;
        Colony ourColony = null;
        FreeColGameObject our = this.getOurFCGO(game);
        if (our == null) {
            return DOMMessage.clientError("Missing our object: " + this.ourId);
        }
        if (our instanceof Unit) {
            ourUnit = (Unit)our;
            if (!serverPlayer.owns(ourUnit)) {
                return DOMMessage.clientError("Not our unit: " + this.ourId);
            }
            if (!ourUnit.hasTile()) {
                return DOMMessage.clientError("Our unit is not on the map: " + this.ourId);
            }
        } else if (our instanceof Colony) {
            ourColony = (Colony)our;
            if (!serverPlayer.owns(ourColony)) {
                return DOMMessage.clientError("Not our settlement: " + this.ourId);
            }
        } else {
            return DOMMessage.clientError("Our object is bogus: " + our);
        }
        Unit otherUnit = null;
        Colony otherColony = null;
        Player otherPlayer = null;
        FreeColGameObject other = this.getOtherFCGO(game);
        if (other == null) {
            return DOMMessage.clientError("Missing other object: " + this.otherId);
        }
        if (other instanceof Unit) {
            otherUnit = (Unit)other;
            if (serverPlayer.owns(otherUnit)) {
                return DOMMessage.clientError("Contacting our unit? " + this.otherId);
            }
            if (!otherUnit.hasTile()) {
                return DOMMessage.clientError("Other unit is not on the map: " + this.otherId);
            }
            if (ourUnit != null && !ourUnit.getTile().isAdjacent(otherUnit.getTile())) {
                return DOMMessage.clientError("Our unit " + this.ourId + " is not adjacent to other unit " + this.otherId);
            }
            if (ourColony != null && !ourColony.getTile().isAdjacent(otherUnit.getTile())) {
                return DOMMessage.clientError("Our colony " + this.ourId + " is not adjacent to other unit " + this.otherId);
            }
            otherPlayer = otherUnit.getOwner();
        } else if (other instanceof Colony) {
            otherColony = (Colony)other;
            if (serverPlayer.owns(otherColony)) {
                return DOMMessage.clientError("Contacting our colony? " + this.otherId);
            }
            if (ourUnit != null && !ourUnit.getTile().isAdjacent(otherColony.getTile())) {
                return DOMMessage.clientError("Our unit " + this.ourId + " is not adjacent to other colony " + this.otherId);
            }
            if (ourColony != null && !ourColony.getTile().isAdjacent(otherColony.getTile())) {
                return DOMMessage.clientError("Our colony " + this.ourId + " is not adjacent to other colony " + this.otherId);
            }
            otherPlayer = otherColony.getOwner();
        } else {
            return DOMMessage.clientError("Other object is bogus: " + other);
        }
        if (ourUnit == null && otherUnit == null) {
            return DOMMessage.clientError("Both units null");
        }
        Player senderPlayer = this.agreement.getSender();
        Player recipientPlayer = this.agreement.getRecipient();
        Player refPlayer = serverPlayer.getREFPlayer();
        if (senderPlayer == null) {
            return DOMMessage.clientError("Null sender in agreement.");
        }
        if (recipientPlayer == null) {
            return DOMMessage.clientError("Null recipient in agreement.");
        }
        if (senderPlayer != serverPlayer) {
            return DOMMessage.clientError("Sender is not our player: " + senderPlayer.getId());
        }
        if (recipientPlayer != otherPlayer) {
            return DOMMessage.clientError("Recipient is not other player: " + recipientPlayer.getId());
        }
        if (senderPlayer == refPlayer || recipientPlayer == refPlayer) {
            return DOMMessage.clientError("The REF does not negotiate: " + refPlayer.getId());
        }
        InGameController igc = server.getInGameController();
        switch (this.agreement.getContext()) {
            case CONTACT: {
                return ourColony != null ? igc.europeanFirstContact(serverPlayer, ourColony, otherUnit, this.agreement) : (otherUnit != null ? igc.europeanFirstContact(serverPlayer, ourUnit, otherUnit, this.agreement) : igc.europeanFirstContact(serverPlayer, ourUnit, otherColony, this.agreement));
            }
            case DIPLOMATIC: {
                return ourUnit != null ? (!ourUnit.hasAbility("model.ability.negotiate") ? DOMMessage.clientError("Unit lacks ability to negotiate: " + ourUnit) : (otherColony == null ? DOMMessage.clientError("Null other settlement") : igc.diplomacy(serverPlayer, ourUnit, otherColony, this.agreement))) : (!otherUnit.hasAbility("model.ability.negotiate") ? DOMMessage.clientError("Unit lacks ability to negotiate: " + otherUnit) : igc.diplomacy(serverPlayer, ourColony, otherUnit, this.agreement));
            }
            case TRADE: {
                return ourUnit != null ? (!ourUnit.isCarrier() ? DOMMessage.clientError("Unit is not a carrier: " + ourUnit) : (!serverPlayer.hasAbility("model.ability.tradeWithForeignColonies") ? DOMMessage.clientError("Player lacks ability to trade with other Europeans: " + serverPlayer) : (otherColony == null ? DOMMessage.clientError("Null other settlement") : igc.diplomacy(serverPlayer, ourUnit, otherColony, this.agreement)))) : (!otherUnit.isCarrier() ? DOMMessage.clientError("Unit is not a carrier: " + otherUnit) : (!otherPlayer.hasAbility("model.ability.tradeWithForeignColonies") ? DOMMessage.clientError("Player lacks ability to trade with other Europeans: " + otherPlayer) : igc.diplomacy(serverPlayer, ourColony, otherUnit, this.agreement)));
            }
            case TRIBUTE: {
                return ourUnit != null ? (!ourUnit.isOffensiveUnit() || ourUnit.isNaval() ? DOMMessage.clientError("Unit is not an offensive land unit: " + ourUnit) : (otherColony == null ? DOMMessage.clientError("Null other settlement") : igc.diplomacy(serverPlayer, ourUnit, otherColony, this.agreement))) : (!otherUnit.isOffensiveUnit() || otherUnit.isNaval() ? DOMMessage.clientError("Unit is not an offensive land unit: " + otherUnit) : igc.diplomacy(serverPlayer, ourColony, otherUnit, this.agreement));
            }
        }
        return DOMMessage.clientError("Invalid diplomacy for " + (Object)((Object)this.agreement.getContext()));
    }

    @Override
    public Element toXMLElement() {
        Element result = DiplomacyMessage.createMessage(DiplomacyMessage.getXMLElementTagName(), "ourId", this.ourId, "otherId", this.otherId);
        Document doc = result.getOwnerDocument();
        result.appendChild(this.agreement.toXMLElement(doc));
        if (this.extraUnit != null) {
            result.appendChild(this.extraUnit.toXMLElement(doc));
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "diplomacy";
    }
}

