/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.awt.Font;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export._VrmlExporter;
import org.jmol.java.BS;
import org.jmol.viewer.Viewer;

public class _X3dExporter
extends _VrmlExporter {
    public _X3dExporter() {
        this.useTable = new UseTable("USE='");
    }

    @Override
    protected void outputHeader() {
        this.output("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.output("<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.1//EN\" \"http://www.web3d.org/specifications/x3d-3.1.dtd\">\n");
        this.output("<X3D profile='Immersive' version='3.1' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation=' http://www.web3d.org/specifications/x3d-3.1.xsd '>\n");
        this.output("<head>\n");
        this.output("<meta name='title' content=" + PT.esc(this.vwr.ms.modelSetName).replace('<', ' ').replace('>', ' ').replace('&', ' ') + "/>\n");
        this.output("<meta name='description' content='Jmol rendering'/>\n");
        this.output("<meta name='creator' content=' '/>\n");
        this.output("<meta name='created' content='" + this.getExportDate() + "'/>\n");
        this.output("<meta name='generator' content='Jmol " + Viewer.getJmolVersion() + ", http://www.jmol.org'/>\n");
        this.output("<meta name='license' content='http://www.gnu.org/licenses/licenses.html#LGPL'/>\n");
        this.output("</head>\n");
        this.output("<Scene>\n");
        this.output("<NavigationInfo type='EXAMINE'/>\n");
        this.output("<Background skyColor='" + this.rgbFractionalFromColix(this.backgroundColix) + "'/>\n");
        float angle = this.getViewpoint();
        this.output("<Viewpoint fieldOfView='" + angle);
        this.output("' position='");
        this.output(this.cameraPosition);
        this.output("' orientation='");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle + "'\n jump='true' description='v1'/>\n");
        this.output("\n  <!-- ");
        this.output(this.getJmolPerspective());
        this.output("\n  -->\n\n");
        this.output("<Transform translation='");
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0f);
        this.output(this.tempP1);
        this.output("'>\n");
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("</Transform>\n");
        this.output("</Scene>\n");
        this.output("</X3D>\n");
    }

    @Override
    protected void outputAppearance(short colix, boolean isText) {
        String def = this.useTable.getDef((isText ? "T" : "") + colix);
        this.output("<Appearance ");
        if (def.charAt(0) == '_') {
            String color = this.rgbFractionalFromColix(colix);
            this.output("DEF='" + def + "'><Material diffuseColor='");
            if (isText) {
                this.output("0 0 0' specularColor='0 0 0' ambientIntensity='0.0' shininess='0.0' emissiveColor='" + color + "'/>");
            } else {
                this.output(color + "' transparency='" + _X3dExporter.translucencyFractionalFromColix(colix) + "'/>");
            }
        } else {
            this.output(def + ">");
        }
        this.output("</Appearance>");
    }

    @Override
    protected void outputTransRot(P3 pt1, P3 pt2, int x, int y, int z) {
        this.output(" ");
        this.outputTransRot(pt1, pt2, x, y, z, "='", "'");
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
        if (doFill) {
            this.output("<Transform translation='");
            this.tempV1.ave(this.tempP3, pt1);
            this.output(this.tempV1);
            this.output("'><Billboard axisOfRotation='0 0 0'><Transform rotation='1 0 0 1.5708'>");
            this.outputCylinderChildScaled(pt1, this.tempP3, colix, (byte)2, radius);
            this.output("</Transform></Billboard>");
            this.output("</Transform>\n");
            return;
        }
        String child = this.useTable.getDef("C" + colix + "_" + radius);
        this.output("<Transform");
        this.outputTransRot(this.tempP3, pt1, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(radius);
        this.output(" scale='");
        this.output(this.tempP3);
        this.output("'>\n<Billboard ");
        if (child.charAt(0) == '_') {
            int i;
            this.output("DEF='" + child + "'");
            this.output(" axisOfRotation='0 0 0'><Transform>");
            this.output("<Shape><Extrusion beginCap='false' convex='false' endCap='false' creaseAngle='1.57'");
            this.output(" crossSection='");
            float rpd = (float)Math.PI / 180;
            float scale = 0.02f / radius;
            for (i = 0; i <= 360; i += 10) {
                this.output(_X3dExporter.round(Math.cos((float)i * rpd) * (double)scale) + " ");
                this.output(_X3dExporter.round(Math.sin((float)i * rpd) * (double)scale) + " ");
            }
            this.output("' spine='");
            for (i = 0; i <= 360; i += 10) {
                this.output(_X3dExporter.round(Math.cos((float)i * rpd)) + " ");
                this.output(_X3dExporter.round(Math.sin((float)i * rpd)) + " 0 ");
            }
            this.output("'/>");
            this.outputAppearance(colix, false);
            this.output("</Shape></Transform>");
        } else {
            this.output(child + ">");
        }
        this.output("</Billboard>\n");
        this.output("</Transform>\n");
    }

    @Override
    protected void outputCone(P3 ptBase, P3 ptTip, float radius, short colix) {
        radius = this.scale(radius);
        float height = this.scale(ptBase.distance(ptTip));
        this.output("<Transform");
        this.outputTransRot(ptBase, ptTip, 0, 1, 0);
        this.output(">\n<Shape ");
        String cone = "o" + (int)(height * 100.0f) + "_" + (int)(radius * 100.0f);
        String child = this.useTable.getDef("c" + cone + "_" + colix);
        if (child.charAt(0) == '_') {
            this.output("DEF='" + child + "'>");
            cone = this.useTable.getDef(cone);
            this.output("<Cone ");
            if (cone.charAt(0) == '_') {
                this.output("DEF='" + cone + "' height='" + _X3dExporter.round(height) + "' bottomRadius='" + _X3dExporter.round(radius) + "'/>");
            } else {
                this.output(cone + "/>");
            }
            this.outputAppearance(colix, false);
        } else {
            this.output(child + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    @Override
    protected boolean outputCylinder(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY, boolean checkRadius) {
        this.output("<Transform");
        if (ptX == null) {
            this.outputTransRot(pt1, pt2, 0, 1, 0);
        } else {
            this.output(" translation='");
            this.output(ptCenter);
            this.output("'");
            this.outputQuaternionFrame(ptCenter, ptY, pt1, ptX, 2.0f, "='", "'");
            pt1.set(0.0f, 0.0f, -1.0f);
            pt2.set(0.0f, 0.0f, 1.0f);
        }
        this.output(">\n");
        this.outputCylinderChildScaled(pt1, pt2, colix, endcaps, radius);
        this.output("\n</Transform>\n");
        if (endcaps == 3) {
            this.outputSphere(pt1, radius * 1.01f, colix, true);
            this.outputSphere(pt2, radius * 1.01f, colix, true);
        }
        return true;
    }

    @Override
    protected void outputCylinderChildScaled(P3 pt1, P3 pt2, short colix, byte endcaps, float radius) {
        float length = this.scale(pt1.distance(pt2));
        radius = this.scale(radius);
        String child = this.useTable.getDef("C" + colix + "_" + (int)(length * 100.0f) + "_" + radius + "_" + endcaps);
        this.output("<Shape ");
        if (child.charAt(0) == '_') {
            this.output("DEF='" + child + "'>");
            this.output("<Cylinder ");
            String cyl = this.useTable.getDef("c" + _X3dExporter.round(length) + "_" + endcaps + "_" + radius);
            if (cyl.charAt(0) == '_') {
                this.output("DEF='" + cyl + "' height='" + _X3dExporter.round(length) + "' radius='" + radius + "'" + (endcaps == 2 ? "" : " top='false' bottom='false'") + "/>");
            } else {
                this.output(cyl + "/>");
            }
            this.outputAppearance(colix, false);
        } else {
            this.output(child + ">");
        }
        this.output("</Shape>");
    }

    @Override
    protected void outputEllipsoid(P3 center, P3[] points, short colix) {
        this.output("<Transform translation='");
        this.output(center);
        this.output("'");
        this.outputQuaternionFrame(center, points[1], points[3], points[5], 1.0f, "='", "'");
        this.output(">");
        this.tempP3.set(0.0f, 0.0f, 0.0f);
        this.outputSphereChildUnscaled(this.tempP3, 1.0f, colix);
        this.output("</Transform>\n");
    }

    @Override
    protected void outputSphereChildUnscaled(T3 center, float radius, short colix) {
        this.output("<Transform translation='");
        this.output(center);
        this.output("'>\n<Shape ");
        String child = this.useTable.getDef("S" + colix + "_" + (int)(radius * 100.0f));
        if (child.charAt(0) == '_') {
            this.output("DEF='" + child + "'>");
            this.output("<Sphere radius='" + radius + "'/>");
            this.outputAppearance(colix, false);
        } else {
            this.output(child + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nFaces, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        this.output("<Shape>\n");
        this.outputAppearance(colix, false);
        this.output("<IndexedFaceSet \n");
        if (polygonColixes != null) {
            this.output(" colorPerVertex='false'\n");
        }
        this.output("coordIndex='\n");
        int[] map = new int[nVertices];
        this.getCoordinateMap(vertices, map, null);
        this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        this.output("'\n");
        Lst<String> vNormals = null;
        if (normals != null) {
            vNormals = new Lst<String>();
            map = this.getNormalMap(normals, nVertices, null, vNormals);
            this.output("  solid='false'\n  normalPerVertex='true'\n  normalIndex='\n");
            this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
            this.output("'\n");
        }
        map = null;
        if (colorList != null) {
            this.output("  colorIndex='\n");
            this.outputColorIndices(indices, nPolygons, bsPolygons, faceVertexMax, htColixes, colixes, polygonColixes);
            this.output("'\n");
        }
        this.output(">\n");
        this.output("<Coordinate point='\n");
        this.outputVertices(vertices, nVertices, offset);
        this.output("'/>\n");
        if (normals != null) {
            this.output("<Normal vector='\n");
            this.outputNormals(vNormals);
            vNormals = null;
            this.output("'/>\n");
        }
        if (colorList != null) {
            this.output("<Color color='\n");
            this.outputColors(colorList);
            this.output("'/>\n");
        }
        this.output("</IndexedFaceSet>\n");
        this.output("</Shape>\n");
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        this.output("<Shape>\n");
        this.output("<IndexedFaceSet solid='false' ");
        this.output("coordIndex='0 1 2 -1'>");
        this.output("<Coordinate point='");
        this.output(pt1);
        this.output(" ");
        this.output(pt2);
        this.output(" ");
        this.output(pt3);
        this.output("'/>");
        this.output("</IndexedFaceSet>\n");
        this.outputAppearance(colix, false);
        this.output("\n</Shape>\n");
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.output("<Transform translation='");
        this.output(this.setFont(x, y, z, colix, text, font3d));
        this.output("'>");
        this.output("<Billboard ");
        if (this.fontChild.charAt(0) == '_') {
            this.output("DEF='" + this.fontChild + "' axisOfRotation='0 0 0'>" + "<Transform translation='0.0 0.0 0.0'>" + "<Shape>");
            this.outputAppearance(colix, true);
            this.output("<Text string=" + PT.esc(text) + ">");
            this.output("<FontStyle ");
            String fontstyle = this.useTable.getDef("F" + this.fontFace + this.fontStyle);
            if (fontstyle.charAt(0) == '_') {
                this.output("DEF='" + fontstyle + "' size='" + this.fontSize + "' family='" + this.fontFace + "' style='" + this.fontStyle + "'/>");
            } else {
                this.output(fontstyle + "/>");
            }
            this.output("</Text>");
            this.output("</Shape>");
            this.output("</Transform>");
        } else {
            this.output(this.fontChild + ">");
        }
        this.output("</Billboard>\n");
        this.output("</Transform>\n");
    }
}

