/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.geom.Area;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.Utils;

public class GpxData
extends WithAttributes
implements Data {
    public File storageFile;
    public boolean fromServer;
    public String creator;
    public final Collection<GpxTrack> tracks = new LinkedList<GpxTrack>();
    public final Collection<GpxRoute> routes = new LinkedList<GpxRoute>();
    public final Collection<WayPoint> waypoints = new LinkedList<WayPoint>();
    public final Set<DataSource> dataSources = new HashSet<DataSource>();

    public void mergeFrom(GpxData gpxData) {
        if (this.storageFile == null && gpxData.storageFile != null) {
            this.storageFile = gpxData.storageFile;
        }
        this.fromServer = this.fromServer && gpxData.fromServer;
        for (Map.Entry entry : gpxData.attr.entrySet()) {
            String string = (String)entry.getKey();
            if ("meta.links".equals(string) && this.attr.containsKey("meta.links")) {
                Collection collection = super.getCollection("meta.links");
                Collection collection2 = (Collection)entry.getValue();
                collection.addAll(collection2);
                continue;
            }
            this.put(string, entry.getValue());
        }
        this.tracks.addAll(gpxData.tracks);
        this.routes.addAll(gpxData.routes);
        this.waypoints.addAll(gpxData.waypoints);
        this.dataSources.addAll(gpxData.dataSources);
    }

    public boolean hasTrackPoints() {
        for (GpxTrack gpxTrack : this.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                if (gpxTrackSegment.getWayPoints().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRoutePoints() {
        for (GpxRoute gpxRoute : this.routes) {
            if (gpxRoute.routePoints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.hasRoutePoints() && !this.hasTrackPoints() && this.waypoints.isEmpty();
    }

    public Bounds getMetaBounds() {
        Object object = this.get("meta.bounds");
        if (object instanceof Bounds) {
            return (Bounds)object;
        }
        return null;
    }

    public Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint iWithAttributes : this.waypoints) {
            if (bounds == null) {
                bounds = new Bounds(iWithAttributes.getCoor());
                continue;
            }
            bounds.extend(iWithAttributes.getCoor());
        }
        for (GpxRoute gpxRoute : this.routes) {
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wayPoint.getCoor());
                    continue;
                }
                bounds.extend(wayPoint.getCoor());
            }
        }
        for (GpxTrack gpxTrack : this.tracks) {
            Bounds bounds2 = gpxTrack.getBounds();
            if (bounds2 == null) continue;
            if (bounds == null) {
                bounds = new Bounds(bounds2);
                continue;
            }
            bounds.extend(bounds2);
        }
        return bounds;
    }

    public double length() {
        double d = 0.0;
        for (GpxTrack gpxTrack : this.tracks) {
            d += gpxTrack.length();
        }
        return d;
    }

    public static Date[] getMinMaxTimeForTrack(GpxTrack gpxTrack) {
        WayPoint wayPoint = null;
        WayPoint wayPoint2 = null;
        for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
            for (WayPoint wayPoint3 : gpxTrackSegment.getWayPoints()) {
                if (wayPoint2 == null) {
                    wayPoint2 = wayPoint = wayPoint3;
                    continue;
                }
                if (wayPoint3.compareTo(wayPoint) < 0) {
                    wayPoint = wayPoint3;
                    continue;
                }
                if (wayPoint3.compareTo(wayPoint2) <= 0) continue;
                wayPoint2 = wayPoint3;
            }
        }
        if (wayPoint == null || wayPoint2 == null) {
            return null;
        }
        return new Date[]{wayPoint.getTime(), wayPoint2.getTime()};
    }

    public Date[] getMinMaxTimeForAllTracks() {
        double d = 1.0E100;
        double d2 = -1.0E100;
        double d3 = (double)System.currentTimeMillis() / 1000.0;
        for (GpxTrack gpxTrack : this.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    double d4 = wayPoint.time;
                    if (!(d4 > 0.0) || !(d4 <= d3)) continue;
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    if (!(d4 < d)) continue;
                    d = d4;
                }
            }
        }
        if (Utils.equalsEpsilon(d, 1.0E100) || Utils.equalsEpsilon(d2, -1.0E100)) {
            return new Date[0];
        }
        return new Date[]{new Date((long)(d * 1000.0)), new Date((long)(d2 * 1000.0))};
    }

    public WayPoint nearestPointOnTrack(EastNorth eastNorth, double d) {
        double d2 = d * d;
        Object object = null;
        double d3 = 0.0;
        double d4 = eastNorth.east();
        double d5 = eastNorth.north();
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.tracks == null) {
            return null;
        }
        for (GpxTrack gpxTrack : this.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                double d8;
                double d9;
                double d10;
                WayPoint wayPoint = null;
                Object object2 = gpxTrackSegment.getWayPoints().iterator();
                while (object2.hasNext()) {
                    double d11;
                    WayPoint wayPoint2 = object2.next();
                    EastNorth eastNorth2 = wayPoint2.getEastNorth();
                    if (wayPoint == null) {
                        wayPoint = wayPoint2;
                        d6 = eastNorth2.east();
                        d10 = d4 - d6;
                        d11 = d10 * d10 + (d9 = d5 - (d7 = eastNorth2.north())) * d9;
                        if (!(d11 < d2)) continue;
                        d2 = d11;
                        object = eastNorth2;
                        d3 = wayPoint.time;
                        continue;
                    }
                    double d12 = eastNorth2.east();
                    double d13 = eastNorth2.north();
                    d11 = d13 - d7;
                    double d14 = d6 - d12;
                    double d15 = -d11 * d6 - d14 * d7;
                    double d16 = d11 * d11 + d14 * d14;
                    if (d16 == 0.0) continue;
                    double d17 = d11 * d4 + d14 * d5 + d15;
                    if ((d17 = d17 * d17 / d16) < d2) {
                        d10 = d4 - d6;
                        d9 = d5 - d7;
                        double d18 = d10 * d10 + d9 * d9;
                        d10 = d4 - d12;
                        d9 = d5 - d13;
                        double d19 = d10 * d10 + d9 * d9;
                        if (d18 - d17 <= d16 && d19 - d17 <= d16) {
                            double d20 = Math.sqrt((d18 - d17) / d16);
                            double d21 = d6 - d20 * d14;
                            double d22 = d7 + d20 * d11;
                            object = new EastNorth(d21, d22);
                            d3 = wayPoint.time + d20 * (wayPoint2.time - wayPoint.time);
                            d2 = d17;
                        }
                    }
                    wayPoint = wayPoint2;
                    d6 = d12;
                    d7 = d13;
                }
                if (wayPoint == null || !((d8 = (d10 = d4 - (d6 = ((EastNorth)(object2 = wayPoint.getEastNorth())).east())) * d10 + (d9 = d5 - (d7 = ((EastNorth)object2).north())) * d9) < d2)) continue;
                d2 = d8;
                object = object2;
                d3 = wayPoint.time;
            }
        }
        if (object == null) {
            return null;
        }
        WayPoint wayPoint = new WayPoint(Main.getProjection().eastNorth2latlon((EastNorth)object));
        wayPoint.time = d3;
        return wayPoint;
    }

    public Iterable<Collection<WayPoint>> getLinesIterable(boolean ... blArray) {
        return () -> new LinesIterator(this, blArray);
    }

    public void resetEastNorthCache() {
        if (this.waypoints != null) {
            for (WayPoint iWithAttributes : this.waypoints) {
                iWithAttributes.invalidateEastNorthCache();
            }
        }
        if (this.tracks != null) {
            for (GpxTrack gpxTrack : this.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        wayPoint.invalidateEastNorthCache();
                    }
                }
            }
        }
        if (this.routes != null) {
            for (GpxRoute gpxRoute : this.routes) {
                if (gpxRoute.routePoints == null) continue;
                for (WayPoint wayPoint : gpxRoute.routePoints) {
                    wayPoint.invalidateEastNorthCache();
                }
            }
        }
    }

    @Override
    public Collection<DataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public Area getDataSourceArea() {
        return DataSource.getDataSourceArea(this.dataSources);
    }

    @Override
    public List<Bounds> getDataSourceBounds() {
        return DataSource.getDataSourceBounds(this.dataSources);
    }

    public static class LinesIterator
    implements Iterator<Collection<WayPoint>> {
        private Iterator<GpxTrack> itTracks;
        private int idxTracks;
        private Iterator<GpxTrackSegment> itTrackSegments;
        private final Iterator<GpxRoute> itRoutes;
        private Collection<WayPoint> next;
        private final boolean[] trackVisibility;

        public LinesIterator(GpxData gpxData, boolean ... blArray) {
            this.itTracks = gpxData.tracks.iterator();
            this.idxTracks = -1;
            this.itRoutes = gpxData.routes.iterator();
            this.trackVisibility = blArray;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Collection<WayPoint> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Collection<WayPoint> collection = this.next;
            this.next = this.getNext();
            return collection;
        }

        private Collection<WayPoint> getNext() {
            if (this.itTracks != null) {
                if (this.itTrackSegments != null && this.itTrackSegments.hasNext()) {
                    return this.itTrackSegments.next().getWayPoints();
                }
                while (this.itTracks.hasNext()) {
                    GpxTrack gpxTrack = this.itTracks.next();
                    ++this.idxTracks;
                    if (this.trackVisibility != null && !this.trackVisibility[this.idxTracks]) continue;
                    this.itTrackSegments = gpxTrack.getSegments().iterator();
                    if (!this.itTrackSegments.hasNext()) continue;
                    return this.itTrackSegments.next().getWayPoints();
                }
                this.itTracks = null;
            }
            if (this.itRoutes.hasNext()) {
                return this.itRoutes.next().routePoints;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

