/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.tests.Addresses;
import org.openstreetmap.josm.data.validation.tests.ApiCapabilitiesTest;
import org.openstreetmap.josm.data.validation.tests.BarriersEntrances;
import org.openstreetmap.josm.data.validation.tests.Coastlines;
import org.openstreetmap.josm.data.validation.tests.ConditionalKeys;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.DuplicateNode;
import org.openstreetmap.josm.data.validation.tests.DuplicateRelation;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.data.validation.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.data.validation.tests.Highways;
import org.openstreetmap.josm.data.validation.tests.InternetTags;
import org.openstreetmap.josm.data.validation.tests.Lanes;
import org.openstreetmap.josm.data.validation.tests.LongSegment;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.NameMismatch;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.PowerLines;
import org.openstreetmap.josm.data.validation.tests.PublicTransportRouteTest;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.data.validation.tests.UnconnectedWays;
import org.openstreetmap.josm.data.validation.tests.UntaggedNode;
import org.openstreetmap.josm.data.validation.tests.UntaggedWay;
import org.openstreetmap.josm.data.validation.tests.WayConnectedToArea;
import org.openstreetmap.josm.data.validation.tests.WronglyOrderedWays;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class OsmValidator {
    public static volatile ValidatorLayer errorLayer;
    public static final ValidateAction validateAction;
    public static double griddetail;
    private static final Collection<String> ignoredErrors;
    private static final Collection<Class<? extends Test>> allTests;
    private static final Map<String, Test> allTestsMap;
    private static final Class<Test>[] CORE_TEST_CLASSES;
    private static boolean testsInitialized;

    private OsmValidator() {
    }

    public static void addTest(Class<? extends Test> clazz) {
        allTests.add(clazz);
        try {
            allTestsMap.put(clazz.getName(), clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Main.error(reflectiveOperationException);
        }
    }

    public static void initialize() {
        OsmValidator.checkValidatorDir();
        OsmValidator.initializeGridDetail();
        OsmValidator.loadIgnoredErrors();
    }

    public static String getValidatorDir() {
        return new File(Main.pref.getUserDataDirectory(), "validator").getAbsolutePath();
    }

    private static void checkValidatorDir() {
        File file = new File(OsmValidator.getValidatorDir());
        if (!file.exists()) {
            Utils.mkDirs(file);
        }
    }

    private static void loadIgnoredErrors() {
        Path path;
        ignoredErrors.clear();
        if (Main.pref.getBoolean("validator.ignore", true) && Files.exists(path = Paths.get(OsmValidator.getValidatorDir(), new String[0]).resolve("ignorederrors"), new LinkOption[0])) {
            try {
                ignoredErrors.addAll(Files.readAllLines(path, StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Main.debug(Main.getErrorMessage(fileNotFoundException));
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
        }
    }

    public static void addIgnoredError(String string) {
        ignoredErrors.add(string);
    }

    public static boolean hasIgnoredError(String string) {
        return ignoredErrors.contains(string);
    }

    public static void saveIgnoredErrors() {
        try (PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(OsmValidator.getValidatorDir(), "ignorederrors")), StandardCharsets.UTF_8), false);){
            for (String string : ignoredErrors) {
                printWriter.println(string);
            }
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    public static synchronized void initializeErrorLayer() {
        if (!Main.pref.getBoolean("validator.layer", true)) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ValidatorLayer();
            Main.getLayerManager().addLayer(errorLayer);
        }
    }

    public static SortedMap<String, Test> getAllTestsMap() {
        OsmValidator.applyPrefs(allTestsMap, false);
        OsmValidator.applyPrefs(allTestsMap, true);
        return new TreeMap<String, Test>(allTestsMap);
    }

    public static <T extends Test> T getTest(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return (T)allTestsMap.get(clazz.getName());
    }

    private static void applyPrefs(Map<String, Test> map, boolean bl) {
        for (String string : Main.pref.getCollection(bl ? "validator.skipBeforeUpload" : "validator.skip")) {
            Test test = map.get(string);
            if (test == null) continue;
            if (bl) {
                test.testBeforeUpload = false;
                continue;
            }
            test.enabled = false;
        }
    }

    public static Collection<Test> getTests() {
        return OsmValidator.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean bl) {
        Collection<Test> collection = OsmValidator.getTests();
        for (Test test : new ArrayList<Test>(collection)) {
            if (bl ? test.testBeforeUpload : test.enabled) continue;
            collection.remove(test);
        }
        return collection;
    }

    public static Collection<Class<? extends Test>> getAllAvailableTestClasses() {
        return Collections.unmodifiableCollection(allTests);
    }

    public static void initializeGridDetail() {
        String string = Main.getProjection().toCode();
        griddetail = Arrays.asList(ProjectionPreference.wgs84.allCodes()).contains(string) ? 10000.0 : (Arrays.asList(ProjectionPreference.mercator.allCodes()).contains(string) ? 0.01 : (Arrays.asList(ProjectionPreference.lambert.allCodes()).contains(string) ? 0.1 : 1.0));
    }

    public static synchronized void initializeTests() {
        if (!testsInitialized) {
            Main.debug("Initializing validator tests");
            long l = System.currentTimeMillis();
            OsmValidator.initializeTests(OsmValidator.getTests());
            testsInitialized = true;
            if (Main.isDebugEnabled()) {
                long l2 = System.currentTimeMillis() - l;
                Main.debug("Initializing validator tests completed in " + Utils.getDurationString(l2));
            }
        }
    }

    public static void initializeTests(Collection<? extends Test> collection) {
        for (Test test : collection) {
            try {
                if (!test.enabled) continue;
                test.initialize();
            }
            catch (Exception exception) {
                Main.error(exception);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error initializing test {0}:\n {1}", test.getClass().getSimpleName(), exception), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    static {
        validateAction = new ValidateAction();
        ignoredErrors = new TreeSet<String>();
        allTests = new ArrayList<Class<? extends Test>>();
        allTestsMap = new HashMap<String, Test>();
        for (Class<Test> clazz : CORE_TEST_CLASSES = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.Ways.class, CrossingWays.Boundaries.class, CrossingWays.Barrier.class, SimilarNamedWays.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.UnconnectedHighways.class, UnconnectedWays.UnconnectedRailways.class, UnconnectedWays.UnconnectedWaterways.class, UnconnectedWays.UnconnectedNaturalOrLanduse.class, UnconnectedWays.UnconnectedPower.class, DuplicateWay.class, NameMismatch.class, MultipolygonTest.class, RelationChecker.class, TurnrestrictionTest.class, DuplicateRelation.class, WayConnectedToArea.class, PowerLines.class, Addresses.class, Highways.class, BarriersEntrances.class, OpeningHourTest.class, MapCSSTagChecker.class, Lanes.class, ConditionalKeys.class, InternetTags.class, ApiCapabilitiesTest.class, LongSegment.class, PublicTransportRouteTest.class}) {
            OsmValidator.addTest(clazz);
        }
    }
}

