/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public final class PrimitiveDataPaster
extends AbstractOsmDataPaster {
    public PrimitiveDataPaster() {
        super(PrimitiveTransferData.DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport, OsmDataLayer osmDataLayer, EastNorth eastNorth) throws UnsupportedFlavorException, IOException {
        PrimitiveTransferData primitiveTransferData = (PrimitiveTransferData)transferSupport.getTransferable().getTransferData(this.df);
        if (primitiveTransferData.hasIncompleteData() && !PrimitiveDataPaster.confirmDeleteIncomplete()) {
            return false;
        }
        EastNorth eastNorth2 = primitiveTransferData.getCenter();
        EastNorth eastNorth3 = eastNorth2 == null || eastNorth == null ? new EastNorth(0.0, 0.0) : eastNorth.subtract(eastNorth2);
        AddPrimitivesCommand addPrimitivesCommand = PrimitiveDataPaster.createNewPrimitives(primitiveTransferData, eastNorth3, osmDataLayer);
        Main.main.undoRedo.add(addPrimitivesCommand);
        return true;
    }

    private static AddPrimitivesCommand createNewPrimitives(PrimitiveTransferData primitiveTransferData, EastNorth eastNorth, OsmDataLayer osmDataLayer) {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>();
        ArrayList<PrimitiveData> arrayList2 = new ArrayList<PrimitiveData>();
        EnumMap<OsmPrimitiveType, Map<Long, Long>> enumMap = PrimitiveDataPaster.generateNewPrimitives(primitiveTransferData, arrayList, arrayList2);
        for (PrimitiveData primitiveData : arrayList) {
            if (primitiveData instanceof NodeData) {
                NodeData nodeData = (NodeData)primitiveData;
                nodeData.setEastNorth(nodeData.getEastNorth().add(eastNorth));
                continue;
            }
            if (primitiveData instanceof WayData) {
                PrimitiveDataPaster.updateNodes(enumMap.get((Object)OsmPrimitiveType.NODE), primitiveData);
                continue;
            }
            if (!(primitiveData instanceof RelationData)) continue;
            PrimitiveDataPaster.updateMembers(enumMap, primitiveData);
        }
        return new AddPrimitivesCommand(arrayList, arrayList2, osmDataLayer);
    }

    private static EnumMap<OsmPrimitiveType, Map<Long, Long>> generateNewPrimitives(PrimitiveTransferData primitiveTransferData, List<PrimitiveData> list, List<PrimitiveData> list2) {
        EnumMap<OsmPrimitiveType, Map<Long, Long>> enumMap = new EnumMap<OsmPrimitiveType, Map<Long, Long>>(OsmPrimitiveType.class);
        enumMap.put(OsmPrimitiveType.NODE, new HashMap());
        enumMap.put(OsmPrimitiveType.WAY, new HashMap());
        enumMap.put(OsmPrimitiveType.RELATION, new HashMap());
        for (PrimitiveData primitiveData : primitiveTransferData.getAll()) {
            if (primitiveData.isIncomplete()) continue;
            PrimitiveData primitiveData2 = primitiveData.makeCopy();
            boolean bl = primitiveData2.isIncomplete();
            primitiveData2.clearOsmMetadata();
            primitiveData2.setIncomplete(bl);
            enumMap.get((Object)primitiveData.getType()).put(primitiveData.getUniqueId(), primitiveData2.getUniqueId());
            list.add(primitiveData2);
            if (!primitiveTransferData.getDirectlyAdded().contains(primitiveData)) continue;
            list2.add(primitiveData2);
        }
        return enumMap;
    }

    private static void updateMembers(EnumMap<OsmPrimitiveType, Map<Long, Long>> enumMap, PrimitiveData primitiveData) {
        ArrayList<RelationMemberData> arrayList = new ArrayList<RelationMemberData>();
        for (RelationMemberData relationMemberData : ((RelationData)primitiveData).getMembers()) {
            OsmPrimitiveType osmPrimitiveType = relationMemberData.getMemberType();
            Long l = enumMap.get((Object)osmPrimitiveType).get(relationMemberData.getMemberId());
            if (l == null) continue;
            arrayList.add(new RelationMemberData(relationMemberData.getRole(), osmPrimitiveType, l));
        }
        ((RelationData)primitiveData).setMembers(arrayList);
    }

    private static void updateNodes(Map<Long, Long> map, PrimitiveData primitiveData) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Long l : ((WayData)primitiveData).getNodes()) {
            Long l2 = map.get(l);
            if (l2 == null) continue;
            arrayList.add(l2);
        }
        ((WayData)primitiveData).setNodes(arrayList);
    }

    private static boolean confirmDeleteIncomplete() {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Delete incomplete members?", new Object[0]), I18n.tr("Paste without incomplete members", new Object[0]), I18n.tr("Cancel", new Object[0]));
        extendedDialog.setButtonIcons("dialogs/relation/deletemembers", "cancel");
        extendedDialog.setContent(I18n.tr("The copied data contains incomplete objects.  When pasting the incomplete objects are removed.  Do you want to paste the data without the incomplete objects?", new Object[0]));
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }
}

