/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.AbstractSizeAdjustingIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;

public class LayeredIcon
extends AbstractSizeAdjustingIcon {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private float myScale;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;

    public LayeredIcon(int layerCount) {
        this.myScale = 1.0f;
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "com/intellij/ui/LayeredIcon", "<init>"));
        }
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        if (!Arrays.equals(this.myVShifts, icon.myVShifts)) {
            return false;
        }
        return this.myScale == icon.myScale;
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.adjustSize();
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.getOrScale(i);
            if (icon == null || this.myDisabledLayers[i]) continue;
            int xOffset = x + this.scale(this.myXShift + this.myHShifts[i]);
            int yOffset = y + this.scale(this.myYShift + this.myVShifts[i]);
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    private Icon getOrScale(int i) {
        Icon icon;
        if (this.myScale == 1.0f) {
            return this.myIcons[i];
        }
        if (this.myScaledIcons == null) {
            this.myScaledIcons = new Icon[this.myIcons.length];
        }
        if ((icon = this.myScaledIcons[i]) == null && this.myIcons[i] != null && (icon = this.myIcons[i]) instanceof ScalableIcon) {
            icon = this.myScaledIcons[i] = ((ScalableIcon)icon).scale(this.myScale);
        }
        return icon;
    }

    @Override
    public int getIconWidth() {
        if (this.myWidth <= 1) {
            this.adjustSize();
            return this.scale(this.myWidth);
        }
        return this.scale(super.getIconWidth());
    }

    @Override
    public int getIconHeight() {
        if (this.myHeight <= 1) {
            this.adjustSize();
            return this.scale(this.myHeight);
        }
        return this.scale(super.getIconHeight());
    }

    private int scale(int n) {
        return this.myScale == 1.0f ? n : (int)((float)n * this.myScale);
    }

    @Override
    protected void adjustSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean hasNotNullIcons = false;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            hasNotNullIcons = true;
            int hShift = this.myHShifts[i];
            int vShift = this.myVShifts[i];
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (!hasNotNullIcons) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    public String toString() {
        return "Layered icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    @Override
    public Icon scale(float scaleFactor) {
        if (this.myScale != scaleFactor) {
            this.myScale = scaleFactor;
            if (this.myScaledIcons != null) {
                Arrays.fill(this.myScaledIcons, null);
            }
            this.adjustSize();
        }
        return this;
    }
}

