/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.zoom.ZoomDrawingView;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.DecoratorFigure;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class JHotDrawTextTool
extends CreationTool
implements ActionListener {
    private FloatingTextField fTextField;
    private TextHolder fTypingTarget;

    public JHotDrawTextTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor, prototype);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
        this.view().clearSelection();
    }

    protected void beginEdit(TextHolder figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addActionListener(this);
        }
        if (figure != this.getTypingTarget() && this.getTypingTarget() != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), figure.getFont());
        Rectangle rect = this.fieldBounds(figure);
        double scale = 1.0;
        DrawingView v = this.view();
        if (v instanceof ZoomDrawingView) {
            scale = ((ZoomDrawingView)v).getScale();
        }
        rect.x = (int)((double)rect.x * scale);
        rect.y = (int)((double)rect.y * scale);
        this.fTextField.setBounds(rect, figure.getText());
        this.setTypingTarget(figure);
        this.setUndoActivity(this.createUndoActivity());
    }

    @Override
    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    @Override
    public void deactivate() {
        this.endEdit();
        super.deactivate();
    }

    protected void endEdit() {
        if (this.getTypingTarget() != null) {
            if (this.fTextField.getText().length() > 0) {
                this.getTypingTarget().setText(this.fTextField.getText());
            } else {
                this.drawing().orphan(this.getAddedFigure());
            }
            this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
            ((UndoActivity)this.getUndoActivity()).setBackupText(this.getTypingTarget().getText());
            this.setTypingTarget(null);
            this.fTextField.endOverlay();
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        Rectangle box = figure.textDisplayBox();
        int nChars = figure.overlayColumns();
        Dimension d = this.fTextField.getPreferredSize(nChars);
        return new Rectangle(box.x, box.y, d.width, d.height);
    }

    protected TextHolder getTypingTarget() {
        return this.fTypingTarget;
    }

    public boolean isActivated() {
        return this.getTypingTarget() != null;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        TextHolder textHolder = null;
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure instanceof TextHolder && !(textHolder = (TextHolder)((Object)pressedFigure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.getTypingTarget() != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            super.mouseDown(e, x, y);
            this.view().checkDamage();
            textHolder = (TextHolder)((Object)this.getCreatedFigure());
            this.beginEdit(textHolder);
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
    }

    protected void setTypingTarget(TextHolder newTypingTarget) {
        this.fTypingTarget = newTypingTarget;
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private String myOriginalText;
        private String myBackupText;

        public UndoActivity(DrawingView newDrawingView, String newOriginalText) {
            super(newDrawingView);
            this.setOriginalText(newOriginalText);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        @Override
        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            if (!this.isValidText(this.getOriginalText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasMoreElements()) {
                    this.getDrawingView().drawing().orphan(fe.nextFigure());
                }
            } else if (!this.isValidText(this.getBackupText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasMoreElements()) {
                    this.getDrawingView().add(fe.nextFigure());
                }
                this.setText(this.getOriginalText());
            } else {
                this.setText(this.getOriginalText());
            }
            return true;
        }

        @Override
        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            if (!this.isValidText(this.getBackupText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasMoreElements()) {
                    this.getDrawingView().drawing().orphan(fe.nextFigure());
                }
            } else if (!this.isValidText(this.getOriginalText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasMoreElements()) {
                    this.getDrawingView().drawing().add(fe.nextFigure());
                    this.setText(this.getBackupText());
                }
            } else {
                this.setText(this.getBackupText());
            }
            return true;
        }

        protected boolean isValidText(String toBeChecked) {
            return toBeChecked != null && toBeChecked.length() > 0;
        }

        protected void setText(String newText) {
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure instanceof DecoratorFigure) {
                    currentFigure = ((DecoratorFigure)currentFigure).getDecoratedFigure();
                }
                if (!(currentFigure instanceof TextHolder)) continue;
                ((TextHolder)((Object)currentFigure)).setText(newText);
            }
        }

        public void setBackupText(String newBackupText) {
            this.myBackupText = newBackupText;
        }

        public String getBackupText() {
            return this.myBackupText;
        }

        public void setOriginalText(String newOriginalText) {
            this.myOriginalText = newOriginalText;
        }

        public String getOriginalText() {
            return this.myOriginalText;
        }
    }
}

