/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.XmlErrorHandler;
import com.sun.rowset.internal.XmlReaderContentHandler;
import com.sun.rowset.internal.XmlResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.XmlReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class WebRowSetXmlReader
implements XmlReader,
Serializable {
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = -9127058392819008014L;

    public WebRowSetXmlReader() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void readXML(WebRowSet caller, Reader reader) throws SQLException {
        try {
            InputSource is = new InputSource(reader);
            XmlErrorHandler dh = new XmlErrorHandler();
            XmlReaderContentHandler hndr = new XmlReaderContentHandler(caller);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            XMLReader reader1 = parser.getXMLReader();
            reader1.setEntityResolver(new XmlResolver());
            reader1.setContentHandler(hndr);
            reader1.setErrorHandler(dh);
            reader1.parse(is);
        }
        catch (SAXParseException err) {
            System.out.println(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.parseerr").toString(), err.getMessage(), err.getLineNumber(), err.getSystemId()));
            err.printStackTrace();
            throw new SQLException(err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            x.printStackTrace();
            throw new SQLException(x.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            throw new SQLException(this.resBundle.handleGetObject("wrsxmlreader.invalidcp").toString());
        }
        catch (Throwable e) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.readxml").toString(), e.getMessage()));
        }
    }

    public void readXML(WebRowSet caller, InputStream iStream) throws SQLException {
        try {
            InputSource is = new InputSource(iStream);
            XmlErrorHandler dh = new XmlErrorHandler();
            XmlReaderContentHandler hndr = new XmlReaderContentHandler(caller);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            XMLReader reader1 = parser.getXMLReader();
            reader1.setEntityResolver(new XmlResolver());
            reader1.setContentHandler(hndr);
            reader1.setErrorHandler(dh);
            reader1.parse(is);
        }
        catch (SAXParseException err) {
            System.out.println(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.parseerr").toString(), err.getLineNumber(), err.getSystemId()));
            System.out.println("   " + err.getMessage());
            err.printStackTrace();
            throw new SQLException(err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            x.printStackTrace();
            throw new SQLException(x.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            throw new SQLException(this.resBundle.handleGetObject("wrsxmlreader.invalidcp").toString());
        }
        catch (Throwable e) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.readxml").toString(), e.getMessage()));
        }
    }

    @Override
    public void readData(RowSetInternal caller) {
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

