/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;
    private int selRow;
    private int selCol;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setFocusable(true);
        this.setInheritsPopupMenu(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwatchPanel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SwatchPanel.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int typed = e.getKeyCode();
                switch (typed) {
                    case 38: {
                        if (SwatchPanel.this.selRow <= 0) break;
                        SwatchPanel.this.selRow--;
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 40: {
                        if (SwatchPanel.this.selRow >= SwatchPanel.this.numSwatches.height - 1) break;
                        SwatchPanel.this.selRow++;
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 37: {
                        if (SwatchPanel.this.selCol > 0 && SwatchPanel.this.getComponentOrientation().isLeftToRight()) {
                            SwatchPanel.this.selCol--;
                            SwatchPanel.this.repaint();
                            break;
                        }
                        if (SwatchPanel.this.selCol >= SwatchPanel.this.numSwatches.width - 1 || SwatchPanel.this.getComponentOrientation().isLeftToRight()) break;
                        SwatchPanel.this.selCol++;
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 39: {
                        if (SwatchPanel.this.selCol < SwatchPanel.this.numSwatches.width - 1 && SwatchPanel.this.getComponentOrientation().isLeftToRight()) {
                            SwatchPanel.this.selCol++;
                            SwatchPanel.this.repaint();
                            break;
                        }
                        if (SwatchPanel.this.selCol <= 0 || SwatchPanel.this.getComponentOrientation().isLeftToRight()) break;
                        SwatchPanel.this.selCol--;
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 36: {
                        SwatchPanel.this.selCol = 0;
                        SwatchPanel.this.selRow = 0;
                        SwatchPanel.this.repaint();
                        break;
                    }
                    case 35: {
                        SwatchPanel.this.selCol = SwatchPanel.this.numSwatches.width - 1;
                        SwatchPanel.this.selRow = SwatchPanel.this.numSwatches.height - 1;
                        SwatchPanel.this.repaint();
                    }
                }
            }
        });
    }

    public Color getSelectedColor() {
        return this.getColorForCell(this.selCol, this.selRow);
    }

    protected void initValues() {
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int row = 0; row < this.numSwatches.height; ++row) {
            int y = row * (this.swatchSize.height + this.gap.height);
            for (int column = 0; column < this.numSwatches.width; ++column) {
                Color c = this.getColorForCell(column, row);
                g.setColor(c);
                int x = !this.getComponentOrientation().isLeftToRight() ? (this.numSwatches.width - column - 1) * (this.swatchSize.width + this.gap.width) : column * (this.swatchSize.width + this.gap.width);
                g.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                g.setColor(Color.black);
                g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                if (this.selRow != row || this.selCol != column || !this.isFocusOwner()) continue;
                Color c2 = new Color(c.getRed() < 125 ? 255 : 0, c.getGreen() < 125 ? 255 : 0, c.getBlue() < 125 ? 255 : 0);
                g.setColor(c2);
                g.drawLine(x, y, x + this.swatchSize.width - 1, y);
                g.drawLine(x, y, x, y + this.swatchSize.height - 1);
                g.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g.drawLine(x, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(x, y);
    }

    protected void initColors() {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Color color = this.getColorForLocation(e.getX(), e.getY());
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public void setSelectedColorFromLocation(int x, int y) {
        this.selCol = !this.getComponentOrientation().isLeftToRight() ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : x / (this.swatchSize.width + this.gap.width);
        this.selRow = y / (this.swatchSize.height + this.gap.height);
        this.repaint();
    }

    public Color getColorForLocation(int x, int y) {
        int column = !this.getComponentOrientation().isLeftToRight() ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : x / (this.swatchSize.width + this.gap.width);
        int row = y / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(column, row);
    }

    private Color getColorForCell(int column, int row) {
        return this.colors[row * this.numSwatches.width + column];
    }
}

