/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class ChannelRequestInterface
 * \headerfile TelepathyQt/channel-request.h <TelepathyQt/ChannelRequest>
 * \ingroup clientchannelrequest
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.ChannelRequest".
 */
class TP_QT_EXPORT ChannelRequestInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.ChannelRequest", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.ChannelRequest");
    }

    /**
     * Creates a ChannelRequestInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelRequestInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelRequestInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelRequestInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelRequestInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelRequestInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Account of type \c QDBusObjectPath.
     *
     * 
     * The Account on which this request was made. This property cannot change.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyAccount() const
    {
        return internalRequestProperty(QLatin1String("Account"));
    }

    /**
     * Asynchronous getter for the remote object property \c UserActionTime of type \c qlonglong.
     *
     * 
     * \htmlonly
     * <p>The time at which user action occurred, or 0 if this channel
     *   request is for some reason not involving user action.</p>
     * 
     * <p>This property is set when the channel request is created,
     *   and can never change.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyUserActionTime() const
    {
        return internalRequestProperty(QLatin1String("UserActionTime"));
    }

    /**
     * Asynchronous getter for the remote object property \c PreferredHandler of type \c QString.
     *
     * 
     * \htmlonly
     *   <p>Either the well-known bus name (starting with
     *     <code>org.freedesktop.Telepathy.Client.</code>)
     *     of the preferred handler for this
     *     channel, or an empty string to indicate that any handler would be
     *     acceptable.</p>
     * 
     * <p>This property is set when the channel request is created,
     *   and can never change.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPreferredHandler() const
    {
        return internalRequestProperty(QLatin1String("PreferredHandler"));
    }

    /**
     * Asynchronous getter for the remote object property \c Requests of type \c Tp::QualifiedPropertyValueMapList.
     *
     * 
     * \htmlonly
     * <p>An array of dictionaries containing desirable properties for
     *   the channel or channels to be created.</p>
     * 
     * <div class="rationale">
     *   <p>This is an array so that we could add a CreateChannels method in
     *     future without redefining the API of ChannelRequest.</p>
     * </div>
     * 
     * <p>This property is set when the channel request is created,
     *   and can never change.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequests() const
    {
        return internalRequestProperty(QLatin1String("Requests"));
    }

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * A list of the extra interfaces provided by this channel request. This 
     * property cannot change.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c Hints of type \c QVariantMap.
     *
     * 
     * \htmlonly
     * <p>A dictionary of metadata provided by the channel
     *   requester, which the handler and other clients MAY choose to
     *   interpret.  Clients MAY
     *   choose to use platform-specific keys for their own purposes, but MUST
     *   ignore unknown keys and MUST cope with expected keys being
     *   missing. Clients SHOULD namespace hint names by having them
     *   start with a reversed domain name, in the same way as D-Bus
     *   interface names.</p>
     * 
     * <div class="rationale">This property might be used to pass a contact ID for a
     *   telephone number shared between two contacts from the address book to
     *   the call UI, so that if you try to call “Mum”, the call UI knows this
     *   rather than having to guess or show “Calling Mum or Dad”. The format
     *   of these contact IDs would be platform-specific, so we leave the
     *   definition of the dictionary entry up to the platform in question.
     *   But third-party channel requesters might not include the contact ID,
     *   so the call UI has to be able to deal with it not being
     *   there.</div>
     * 
     * <p>The channel dispatcher does not currently interpret any of these
     *   hints: they are solely for communication between cooperating
     *   clients. If hints that do affect the channel dispatcher are added in
     *   future, their names will start with an appropriate reversed domain
     *   name (e.g. <code>org.freedesktop.Telepathy</code> for hints defined
     *   by this specification, or an appropriate vendor name for third-party
     *   plugins).</p>
     * 
     * <p>This property may be set when the channel request is created, and
     *   can never change. Since it is immutable, it SHOULD be included in the
     *   dictionary of properties passed to  \endhtmlonly ClientInterfaceRequestsInterface::AddRequest() \htmlonly 
     *   by the  \endhtmlonly ChannelDispatcherInterface \htmlonly .</p>
     * <p>The following standardised hints are defined:</p>
     * 
     * <dl>
     *   <dt>org.freedesktop.Telepathy.ChannelRequest.DelegateToPreferredHandler - b</dt>
     *   <dd>If present and True the client currently handling the channel
     *     SHOULD pass the channel to the
     *      \endhtmlonly \link requestPropertyPreferredHandler() PreferredHandler \endlink \htmlonly  using
     *      \endhtmlonly ChannelDispatcherInterface::DelegateChannels() \htmlonly .
     * 
     *     <div class="rationale">
     *       This hint allows the user to request a channel in their
     *       preferred client in a situation where there are two chat
     *       handlers (for example: requesting a channel in Empathy which is
     *       currently being handled by gnome-shell).
     *     </div>
     * 
     *     If the channel is currently unhandled, clients SHOULD ignore this
     *     hint.
     * 
     *     <div class="rationale">
     *       It is assumed that Mission Control will correctly delegate an
     *       unhandled channel to the preferred Handler. This allows
     *       requesting clients to always include this hint in their channel
     *       request.
     *     </div>
     * 
     *     The Handler should check each
     *      \endhtmlonly ChannelRequestInterface \htmlonly 
     *     of the Requests_Satisfied parameter of
     *      \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *     for the hint. The first request containing the hint SHOULD be used
     *     and all further hints SHOULD be ignored.
     * 
     *     <div class="rationale">
     *       This covers the very unlikely case where
     *        \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *       satisfies two separate requests which have different
     *        \endhtmlonly \link requestPropertyPreferredHandler() PreferredHandler \endlink \htmlonly s.
     *     </div>
     *   </dd>
     * </dl>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHints() const
    {
        return internalRequestProperty(QLatin1String("Hints"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Proceed on the remote object.
     * 
     * \htmlonly
     * <p>Proceed with the channel request.</p>
     * 
     * <div class="rationale">
     *   <p>The client that created this object calls this method
     *     when it has connected signal handlers for
     *      \endhtmlonly Succeeded() \htmlonly  and
     *      \endhtmlonly Failed() \htmlonly .</p>
     * </div>
     * 
     * <p>Clients other than the client which created the ChannelRequest
     *   MUST NOT call this method.</p>
     * 
     * <p>This method SHOULD return immediately; on success, the request
     *   might still fail, but this will be indicated asynchronously
     *   by the  \endhtmlonly Failed() \htmlonly  signal.</p>
     * 
     * <p>Proceed cannot fail, unless clients have got the life-cycle
     *   of a ChannelRequest seriously wrong (e.g. a client calls this
     *   method twice, or a client that did not create the ChannelRequest
     *   calls this method). If it fails, clients SHOULD assume that the
     *   whole ChannelRequest has become useless.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Proceed(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Proceed"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Cancel on the remote object.
     * 
     * \htmlonly
     * <p>Cancel the channel request. The precise effect depends on the
     *   current progress of the request.</p>
     * 
     * <p>If the connection manager has not already been asked to create
     *   a channel, then  \endhtmlonly Failed() \htmlonly  is emitted
     *   immediately, and the channel request is removed.</p>
     * 
     * <p>If the connection manager has already been asked to create a
     *   channel but has not produced one yet (e.g. if  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly 
     *   has been called, but has not yet returned), then the
     *   ChannelDispatcher will remember that the request has been cancelled.
     *   When the channel appears, it will be closed (if it was newly
     *   created and can be closed), and will not be dispatched to a
     *   handler.</p>
     * 
     * <p>If the connection manager has already returned a channel, but the
     *   channel has not yet been dispatched to a handler
     *   then the channel dispatcher will not dispatch that
     *   channel to a handler. If the channel was newly created for this
     *   request, the channel dispatcher will close it with  \endhtmlonly ChannelInterface::Close() \htmlonly ;
     *   otherwise, the channel dispatcher will ignore it. In either case,
     *    \endhtmlonly Failed() \htmlonly  will be emitted when processing
     *   has been completed.</p>
     * 
     * <p>If  \endhtmlonly Failed() \htmlonly  is emitted in response to
     *   this method, the error SHOULD be
     *   <code>org.freedesktop.Telepathy.Error.Cancelled</code>.</p>
     * 
     * <p>If the channel has already been dispatched to a handler, then
     *   it's too late to call this method, and the channel request will
     *   no longer exist.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Cancel(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Cancel"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c Failed on the remote object.
     * 
     * \htmlonly
     * <p>The channel request has failed. It is no longer present,
     *   and further methods must not be called on it.</p>
     * \endhtmlonly
     *
     * \param error
     *     
     *     \htmlonly
     *     <p>The name of a D-Bus error. This can come from various sources,
     *       including the error raised by  \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly ,
     *       or an error generated
     *       to represent failure to establish the  \endhtmlonly ConnectionInterface \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param message
     *     
     *     If the first argument of the D-Bus error message was a string, that 
     *     string. Otherwise, an empty string.
     */
    void Failed(const QString& error, const QString& message);

    /**
     * Represents the signal \c Succeeded on the remote object.
     * 
     * \htmlonly
     * <p>The channel request has succeeded. It is no longer present,
     *   and further methods must not be called on it.</p>
     * \endhtmlonly
     */
    void Succeeded();

    /**
     * Represents the signal \c SucceededWithChannel on the remote object.
     * 
     * \htmlonly
     * <p>Variant of the  \endhtmlonly ChannelRequestInterface::Succeeded() \htmlonly  signal
     * allowing to get the channel which has been created.</p>
     * 
     * <p>This signal MUST be emitted if the
     *    \endhtmlonly ChannelDispatcherInterface \htmlonly 's
     *    \endhtmlonly \link ChannelDispatcherInterface::requestPropertySupportsRequestHints() ChannelDispatcherInterface::SupportsRequestHints \endlink \htmlonly 
     *   property is true. If supported, it MUST be emitted before
     *   the  \endhtmlonly Succeeded() \htmlonly  signal.</p>
     * \endhtmlonly
     *
     * \param connection
     *     
     *     \htmlonly
     *     <p>The Connection owning the channel.</p>
     *     \endhtmlonly
     *
     * \param connectionProperties
     *     
     *     \htmlonly
     *     <p>A subset of the Connection's properties, currently unused.
     *       This parameter may be used in future.</p>
     *     \endhtmlonly
     *
     * \param channel
     *     
     *     \htmlonly
     *     <p>The channel which has been created.</p>
     *     \endhtmlonly
     *
     * \param channelProperties
     *     
     *     \htmlonly
     *     <p>The same immutable properties of the Channel that would appear
     *       in a  \endhtmlonly ConnectionInterfaceRequestsInterface::NewChannels() \htmlonly  signal.</p>
     *     \endhtmlonly
     */
    void SucceededWithChannel(const QDBusObjectPath& connection, const QVariantMap& connectionProperties, const QDBusObjectPath& channel, const QVariantMap& channelProperties);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::ChannelRequestInterface*)
