/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.WindowManager;

public final class ExportAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(ExportAction.class.getName());
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.Export");
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_XML = "xml";
    private static final String FILE_EXTENSION_HTML = "html";
    private static final String FILE_EXTENSION_NPS = "nps";
    public static final int MODE_CSV = 1;
    public static final int MODE_EXCEL = 2;
    public static final int MODE_XML = 3;
    public static final int MODE_HTML = 4;
    public static final int MODE_NPS = 5;
    private static File exportDir;
    private JFileChooser fileChooser;
    private ExportProvider exportProvider;
    private int exportedFileType;
    private LoadedSnapshot snapshot;

    public ExportAction(ExportProvider exportProvider, LoadedSnapshot loadedSnapshot) {
        this.putValue("Name", Bundle.ExportAction_ExportActionName());
        this.putValue("ShortDescription", Bundle.ExportAction_ExportActionDescr());
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.exportProvider = exportProvider;
        if (loadedSnapshot != null) {
            this.snapshot = loadedSnapshot;
        }
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasExportableView()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogXMLFilter();
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".html");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogHTMLFilter();
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogExcelFilter();
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogCSVFilter();
                }
            });
        }
        if (this.exportProvider.hasLoadedSnapshot()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".nps");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogNPSFilter();
                }
            });
            FileFilter[] fileFilterArray = this.fileChooser.getChoosableFileFilters();
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (!fileFilterArray[i].getDescription().equals(Bundle.ExportAction_ExportDialogNPSFilter())) continue;
                this.fileChooser.setFileFilter(fileFilterArray[i]);
            }
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.ExportAction_ExportDialogTitle());
            this.fileChooser.setApproveButtonText(Bundle.ExportAction_ExportDialogButton());
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File file, File file2) {
        if (file2.exists()) {
            if (file != null && file.equals(file2)) {
                ProfilerDialogs.displayError((String)Bundle.ExportAction_ExportToItselfMsg());
                return false;
            }
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.ExportAction_OverwriteFileMsg(file2.getName()), (String)Bundle.ExportAction_OverwriteFileCaption())) {
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        String string;
        File file;
        String string2;
        int n;
        String string3 = exportProvider.getViewName();
        JFileChooser jFileChooser = this.getFileChooser();
        if (exportDir != null) {
            jFileChooser.setCurrentDirectory(exportDir);
        }
        if ((n = jFileChooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated())) != 0) {
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (fileFilter == null || fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogXMLFilter())) {
            string2 = FILE_EXTENSION_XML;
            this.exportedFileType = 3;
        } else if (fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogHTMLFilter())) {
            string2 = FILE_EXTENSION_HTML;
            this.exportedFileType = 4;
        } else if (fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogExcelFilter())) {
            string2 = FILE_EXTENSION_CSV;
            this.exportedFileType = 2;
        } else if (fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogNPSFilter())) {
            string2 = FILE_EXTENSION_NPS;
            this.exportedFileType = 5;
        } else {
            string2 = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        }
        if (file2.isDirectory()) {
            exportDir = file2;
            file = file2;
            string = string3;
        } else {
            file = this.fileChooser.getCurrentDirectory();
            String string4 = file2.getName();
            if (string4.endsWith("." + string2)) {
                int n2 = string4.lastIndexOf(46);
                string = string4.substring(0, n2);
            } else {
                string = string4;
            }
        }
        return new SelectedFile(file, string, string2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        SelectedFile selectedFile;
        if (!this.exportProvider.hasExportableView() && !this.exportProvider.hasLoadedSnapshot()) {
            ProfilerDialogs.displayError((String)Bundle.ExportAction_NoViewMsg());
            return;
        }
        final LiveResultsWindow liveResultsWindow = this.exportProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.exportProvider : null;
        final AppStatusHandler appStatusHandler = Profiler.getDefault().getTargetAppRunner().getAppStatusHandler();
        if (liveResultsWindow != null) {
            appStatusHandler.pauseLiveUpdates();
        }
        if ((selectedFile = this.selectExportTargetFile(this.exportProvider)) == null) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (!this.checkFileExists(this.snapshot == null ? null : this.snapshot.getFile(), file = selectedFile.getSelectedFile())) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (this.exportedFileType == 5) {
            new NBSwingWorker(true){
                private final ProgressHandle ph;
                {
                    super(bl);
                    this.ph = ProgressHandleFactory.createHandle((String)Bundle.ExportAction_SavingSnapshot());
                }

                protected void doInBackground() {
                    try {
                        this.ph.setInitialDelay(500);
                        this.ph.start();
                        if (!file.getAbsolutePath().toLowerCase().endsWith(".nps")) {
                            ProfilerDialogs.displayError((String)Bundle.ExportAction_InvalidLocationForFileMsg());
                            return;
                        }
                        FileObject fileObject = FileUtil.createData((File)file);
                        if (fileObject == null) {
                            ProfilerDialogs.displayError((String)Bundle.ExportAction_InvalidLocationForFileMsg());
                            return;
                        }
                        ResultsManager.getDefault().saveSnapshot(ExportAction.this.snapshot, fileObject);
                    }
                    catch (IOException iOException) {
                        ProfilerDialogs.displayError((String)Bundle.ExportAction_CannotWriteFileMsg(iOException.getLocalizedMessage()));
                        LOGGER.log(Level.WARNING, iOException.toString());
                    }
                }

                protected void done() {
                    this.ph.finish();
                    if (liveResultsWindow != null) {
                        appStatusHandler.resumeLiveUpdates();
                    }
                }
            }.execute();
        } else {
            new NBSwingWorker(true){
                private final ProgressHandle ph;
                {
                    super(bl);
                    this.ph = ProgressHandleFactory.createHandle((String)Bundle.ExportAction_ExportingViewMsg());
                }

                protected void doInBackground() {
                    this.ph.setInitialDelay(500);
                    this.ph.start();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        ExportDataDumper exportDataDumper = new ExportDataDumper(fileOutputStream);
                        ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, exportDataDumper);
                        if (exportDataDumper.getCaughtException() != null) {
                            ProfilerDialogs.displayError((String)(exportDataDumper.getNumExceptions() + Bundle.ExportAction_IOException_Exporting_Msg()));
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        ProfilerDialogs.displayError((String)(Bundle.ExportAction_OomeExportingMsg() + outOfMemoryError.getMessage()));
                    }
                    catch (IOException iOException) {
                        ProfilerDialogs.displayError((String)Bundle.ExportAction_CannotWriteFileMsg(iOException.getLocalizedMessage()));
                        LOGGER.log(Level.WARNING, iOException.toString());
                    }
                }

                protected void done() {
                    this.ph.finish();
                    if (liveResultsWindow != null) {
                        appStatusHandler.resumeLiveUpdates();
                    }
                }
            }.execute();
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File file, String string, String string2) {
            this.folder = file;
            this.fileName = string;
            this.fileExt = string2;
        }

        File getSelectedFile() {
            String string = this.folder.getAbsolutePath();
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            return new File(string + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean hasExportableView();

        public boolean hasLoadedSnapshot();
    }
}

