/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jmol.api.JmolAppAPI;
import org.jmol.api.JmolDialogInterface;
import org.jmol.dialog.FileChooser;
import org.jmol.dialog.FilePreview;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class Dialog
extends JPanel
implements JmolDialogInterface {
    String[] extensions = new String[10];
    String choice;
    String extension;
    private static int defaultChoice;
    static int qualityJPG;
    static int qualityPNG;
    private JSlider qSliderJPEG;
    private JSlider qSliderPNG;
    private JComboBox<String> cb;
    JPanel qPanelJPEG;
    JPanel qPanelPNG;
    static JFileChooser imageChooser;
    static JFileChooser saveChooser;
    private static FileChooser openChooser;
    private FilePreview openPreview;
    File initialFile;
    static boolean haveTranslations;
    private static boolean isMac;
    protected String[] imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM"};
    protected String[] imageExtensions = new String[]{"jpg", "png", "gif", "ppm"};
    protected String outputFileName;
    protected String dialogType;
    protected String inputFileName;
    protected Viewer vwr;
    protected int qualityJ = -1;
    protected int qualityP = -1;
    protected String imageType;

    @Override
    public String getOpenFileNameFromDialog(Map<String, Object> vwrOptions, Viewer vwr, String fileName, JmolAppAPI jmolApp, String windowName, boolean allowAppend) {
        String url;
        if (openChooser == null) {
            openChooser = new FileChooser();
            Object temp = UIManager.get("FileChooser.fileNameLabelText");
            UIManager.put("FileChooser.fileNameLabelText", GT._("File or URL:"));
            Dialog.getXPlatformLook(openChooser);
            UIManager.put("FileChooser.fileNameLabelText", temp);
        }
        if (this.openPreview == null && (vwr.isApplet || Boolean.valueOf(System.getProperty("openFilePreview", "true")).booleanValue())) {
            this.openPreview = new FilePreview(vwr, openChooser, allowAppend, vwrOptions);
        }
        if (jmolApp != null) {
            Point loc;
            Dimension dim = jmolApp.getHistoryWindowSize(windowName);
            if (dim != null) {
                openChooser.setDialogSize(dim);
            }
            if ((loc = jmolApp.getHistoryWindowPosition(windowName)) != null) {
                openChooser.setDialogLocation(loc);
            }
        }
        openChooser.resetChoosableFileFilters();
        if (this.openPreview != null) {
            this.openPreview.setPreviewOptions(allowAppend);
        }
        if (fileName != null) {
            int pt = fileName.lastIndexOf(".");
            String sType = fileName.substring(pt + 1);
            if (pt >= 0 && sType.length() > 0) {
                openChooser.addChoosableFileFilter(new TypeFilter(sType));
            }
            if (fileName.indexOf(".") == 0) {
                fileName = "Jmol" + fileName;
            }
            if (fileName.length() > 0) {
                openChooser.setSelectedFile(new File(fileName));
            }
        }
        if (fileName == null || fileName.indexOf(":") < 0 && fileName.indexOf("/") != 0) {
            File dir = (File)((Object)FileManager.getLocalDirectory(vwr, true));
            openChooser.setCurrentDirectory(dir);
        }
        File file = null;
        if (openChooser.showOpenDialog(this) == 0) {
            file = openChooser.getSelectedFile();
        }
        if (file == null) {
            return this.closePreview();
        }
        if (jmolApp != null) {
            jmolApp.addHistoryWindowInfo(windowName, openChooser.getDialog(), null);
        }
        if ((url = vwr.getLocalUrl(file.getAbsolutePath())) != null) {
            fileName = url;
        } else {
            FileManager.setLocalPath(vwr, file.getParent(), true);
            fileName = file.getAbsolutePath();
        }
        if (fileName.startsWith("/")) {
            fileName = "file://" + fileName;
        }
        boolean doCartoons = jmolApp == null || allowAppend && this.openPreview != null && this.openPreview.isCartoonsSelected();
        boolean doAppend = allowAppend && !FileManager.isScriptType(fileName) && this.openPreview != null && this.openPreview.isAppendSelected();
        this.closePreview();
        return (doCartoons ? "" : "#NOCARTOONS#;") + (doAppend ? "#APPEND#;" : "") + fileName;
    }

    String closePreview() {
        if (this.openPreview != null) {
            this.openPreview.updatePreview(this.vwr, null);
        }
        return null;
    }

    @Override
    public String getSaveFileNameFromDialog(Viewer vwr, String fileName, String type) {
        if (saveChooser == null) {
            saveChooser = new JFileChooser();
            Dialog.getXPlatformLook(saveChooser);
        }
        saveChooser.setCurrentDirectory((File)((Object)FileManager.getLocalDirectory(vwr, true)));
        File file = null;
        saveChooser.resetChoosableFileFilters();
        if (fileName != null) {
            int pt = fileName.lastIndexOf(".");
            String sType = fileName.substring(pt + 1);
            if (pt >= 0 && sType.length() > 0) {
                saveChooser.addChoosableFileFilter(new TypeFilter(sType));
            }
            if (fileName.equals("*")) {
                fileName = vwr.getModelSetFileName();
            }
            if (fileName.indexOf(".") == 0) {
                fileName = "Jmol" + fileName;
            }
            file = new File(fileName);
        }
        if (type != null) {
            saveChooser.addChoosableFileFilter(new TypeFilter(type));
        }
        saveChooser.setSelectedFile(file);
        file = this.showSaveDialog(this, saveChooser, file);
        if (file == null) {
            return null;
        }
        FileManager.setLocalPath(vwr, file.getParent(), true);
        return file.getAbsolutePath();
    }

    @Override
    public String getImageFileNameFromDialog(Viewer vwr, String fileName, String type, String[] imageChoices, String[] imageExtensions, int qualityJPG0, int qualityPNG0) {
        File file;
        block12: {
            block11: {
                if (qualityJPG0 < 0 || qualityJPG0 > 100) {
                    qualityJPG0 = qualityJPG;
                }
                if (qualityPNG0 < 0) {
                    qualityPNG0 = qualityPNG;
                }
                if (qualityPNG0 > 9) {
                    qualityPNG0 = 2;
                }
                qualityJPG = qualityJPG0;
                qualityPNG = qualityPNG0;
                if (this.extension == null) {
                    this.extension = "jpg";
                }
                if (imageChooser == null) {
                    imageChooser = new JFileChooser();
                    Dialog.getXPlatformLook(imageChooser);
                }
                imageChooser.setCurrentDirectory((File)((Object)FileManager.getLocalDirectory(vwr, true)));
                imageChooser.resetChoosableFileFilters();
                file = null;
                if (fileName != null) break block11;
                fileName = vwr.getModelSetFileName();
                if (fileName.indexOf("?") >= 0) {
                    fileName = fileName.substring(0, fileName.indexOf("?"));
                }
                String pathName = imageChooser.getCurrentDirectory().getPath();
                if (fileName == null || pathName == null) break block12;
                int extensionStart = fileName.lastIndexOf(46);
                if (extensionStart != -1) {
                    fileName = fileName.substring(0, extensionStart) + "." + this.extension;
                }
                file = new File(pathName, fileName);
                break block12;
            }
            if (fileName.indexOf(".") == 0) {
                fileName = "Jmol" + fileName;
            }
            file = new File(fileName);
            type = fileName.substring(fileName.lastIndexOf(".") + 1);
            for (int i = 0; i < imageExtensions.length; ++i) {
                if (!type.equals(imageChoices[i]) && !type.toLowerCase().equals(imageExtensions[i])) continue;
                type = imageChoices[i];
                break;
            }
        }
        this.createExportPanel(imageChoices, imageExtensions, type);
        this.initialFile = file;
        imageChooser.setSelectedFile(this.initialFile);
        file = this.showSaveDialog(this, imageChooser, file);
        if (file == null) {
            return null;
        }
        qualityJPG = this.qSliderJPEG.getValue();
        qualityPNG = this.qSliderPNG.getValue();
        if (this.cb.getSelectedIndex() >= 0) {
            defaultChoice = this.cb.getSelectedIndex();
        }
        FileManager.setLocalPath(vwr, file.getParent(), true);
        return file.getAbsolutePath();
    }

    private void createExportPanel(String[] choices, String[] extensions, String type) {
        imageChooser.setAccessory(this);
        this.setLayout(new BorderLayout());
        if (type == null || type.equals("JPG")) {
            type = "JPEG";
        }
        defaultChoice = choices.length;
        while (--defaultChoice >= 1 && !choices[defaultChoice].equals(type)) {
        }
        this.extension = extensions[defaultChoice];
        this.choice = choices[defaultChoice];
        this.extensions = extensions;
        imageChooser.resetChoosableFileFilters();
        imageChooser.addChoosableFileFilter(new TypeFilter(this.extension));
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(new FlowLayout());
        cbPanel.setBorder(new TitledBorder(GT._("Image Type")));
        this.cb = new JComboBox();
        for (int i = 0; i < choices.length; ++i) {
            this.cb.addItem(choices[i]);
        }
        cbPanel.add(this.cb);
        this.cb.setSelectedIndex(defaultChoice);
        this.cb.addItemListener(new ExportChoiceListener());
        this.add((Component)cbPanel, "North");
        JPanel qPanel2 = new JPanel();
        qPanel2.setLayout(new BorderLayout());
        this.qPanelJPEG = new JPanel();
        this.qPanelJPEG.setLayout(new BorderLayout());
        this.qPanelJPEG.setBorder(new TitledBorder(GT.i(GT._("JPEG Quality ({0})"), qualityJPG)));
        this.qSliderJPEG = new JSlider(0, 50, 100, qualityJPG);
        this.qSliderJPEG.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.qSliderJPEG.setPaintTicks(true);
        this.qSliderJPEG.setMajorTickSpacing(10);
        this.qSliderJPEG.setPaintLabels(true);
        this.qSliderJPEG.addChangeListener(new QualityListener(true, this.qSliderJPEG));
        this.qPanelJPEG.add((Component)this.qSliderJPEG, "South");
        qPanel2.add((Component)this.qPanelJPEG, "North");
        this.qPanelPNG = new JPanel();
        this.qPanelPNG.setLayout(new BorderLayout());
        this.qPanelPNG.setBorder(new TitledBorder(GT.i(GT._("PNG Compression  ({0})"), qualityPNG)));
        this.qSliderPNG = new JSlider(0, 0, 9, qualityPNG);
        this.qSliderPNG.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.qSliderPNG.setPaintTicks(true);
        this.qSliderPNG.setMajorTickSpacing(2);
        this.qSliderPNG.setPaintLabels(true);
        this.qSliderPNG.addChangeListener(new QualityListener(false, this.qSliderPNG));
        this.qPanelPNG.add((Component)this.qSliderPNG, "South");
        qPanel2.add((Component)this.qPanelPNG, "South");
        this.add((Component)qPanel2, "South");
    }

    @Override
    public String getType() {
        return this.choice;
    }

    @Override
    public int getQuality(String sType) {
        return sType.equals("JPEG") || sType.equals("JPG") ? qualityJPG : (sType.equals("PNG") ? qualityPNG : -1);
    }

    private static boolean doOverWrite(JFileChooser chooser, File file) {
        Object[] options = new Object[]{GT._("Yes"), GT._("No")};
        int opt = JOptionPane.showOptionDialog(chooser, GT.o(GT._("Do you want to overwrite file {0}?"), file.getAbsolutePath()), GT._("Warning"), -1, 2, null, options, options[0]);
        return opt == 0;
    }

    private File showSaveDialog(Component c, JFileChooser chooser, File file) {
        do {
            if (chooser.showSaveDialog(c) != 0) {
                return null;
            }
            if (this.cb == null || this.cb.getSelectedIndex() < 0) continue;
            defaultChoice = this.cb.getSelectedIndex();
        } while ((file = chooser.getSelectedFile()) != null && file.exists() && !Dialog.doOverWrite(chooser, file));
        return file;
    }

    @Override
    public void setupUI(boolean forceNewTranslation) {
        if (forceNewTranslation || !haveTranslations) {
            Dialog.setupUIManager();
        }
        haveTranslations = true;
    }

    public static void setupUIManager() {
        UIManager.put("FileChooser.acceptAllFileFilterText", GT._("All Files"));
        UIManager.put("FileChooser.cancelButtonText", GT._("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", GT._("Abort file chooser dialog"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", GT._("Details"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", GT._("Details"));
        UIManager.put("FileChooser.directoryDescriptionText", GT._("Directory"));
        UIManager.put("FileChooser.directoryOpenButtonText", GT._("Open"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", GT._("Open selected directory"));
        UIManager.put("FileChooser.fileAttrHeaderText", GT._("Attributes"));
        UIManager.put("FileChooser.fileDateHeaderText", GT._("Modified"));
        UIManager.put("FileChooser.fileDescriptionText", GT._("Generic File"));
        UIManager.put("FileChooser.fileNameHeaderText", GT._("Name"));
        UIManager.put("FileChooser.fileNameLabelText", GT._("File Name:"));
        UIManager.put("FileChooser.fileSizeHeaderText", GT._("Size"));
        UIManager.put("FileChooser.filesOfTypeLabelText", GT._("Files of Type:"));
        UIManager.put("FileChooser.fileTypeHeaderText", GT._("Type"));
        UIManager.put("FileChooser.helpButtonText", GT._("Help"));
        UIManager.put("FileChooser.helpButtonToolTipText", GT._("FileChooser help"));
        UIManager.put("FileChooser.homeFolderAccessibleName", GT._("Home"));
        UIManager.put("FileChooser.homeFolderToolTipText", GT._("Home"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", GT._("List"));
        UIManager.put("FileChooser.listViewButtonToolTipText", GT._("List"));
        UIManager.put("FileChooser.lookInLabelText", GT._("Look In:"));
        UIManager.put("FileChooser.newFolderErrorText", GT._("Error creating new folder"));
        UIManager.put("FileChooser.newFolderAccessibleName", GT._("New Folder"));
        UIManager.put("FileChooser.newFolderToolTipText", GT._("Create New Folder"));
        UIManager.put("FileChooser.openButtonText", GT._("Open"));
        UIManager.put("FileChooser.openButtonToolTipText", GT._("Open selected file"));
        UIManager.put("FileChooser.openDialogTitleText", GT._("Open"));
        UIManager.put("FileChooser.saveButtonText", GT._("Save"));
        UIManager.put("FileChooser.saveButtonToolTipText", GT._("Save selected file"));
        UIManager.put("FileChooser.saveDialogTitleText", GT._("Save"));
        UIManager.put("FileChooser.saveInLabelText", GT._("Save In:"));
        UIManager.put("FileChooser.updateButtonText", GT._("Update"));
        UIManager.put("FileChooser.updateButtonToolTipText", GT._("Update directory listing"));
        UIManager.put("FileChooser.upFolderAccessibleName", GT._("Up"));
        UIManager.put("FileChooser.upFolderToolTipText", GT._("Up One Level"));
        UIManager.put("OptionPane.cancelButtonText", GT._("Cancel"));
        UIManager.put("OptionPane.noButtonText", GT._("No"));
        UIManager.put("OptionPane.okButtonText", GT._("OK"));
        UIManager.put("OptionPane.yesButtonText", GT._("Yes"));
    }

    private static void getXPlatformLook(JFileChooser fc) {
        if (isMac) {
            LookAndFeel lnf = UIManager.getLookAndFeel();
            if (lnf.isNativeLookAndFeel()) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                fc.updateUI();
                try {
                    UIManager.setLookAndFeel(lnf);
                }
                catch (UnsupportedLookAndFeelException e) {
                    System.out.println(e.getMessage());
                }
            }
        } else {
            fc.updateUI();
        }
    }

    @Override
    public void setImageInfo(int qualityJPG, int qualityPNG, String imageType) {
        this.qualityJ = qualityJPG;
        this.qualityP = qualityPNG;
        this.imageType = imageType;
    }

    @Override
    public String getFileNameFromDialog(Viewer v, String dType, String iFileName) {
        this.vwr = v;
        this.dialogType = dType;
        this.inputFileName = iFileName;
        this.outputFileName = null;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Dialog.this.dialogType.equals("Load")) {
                        Dialog.this.outputFileName = Dialog.this.getOpenFileNameFromDialog(Dialog.this.vwr.vwrOptions, Dialog.this.vwr, Dialog.this.inputFileName, null, null, false);
                        return;
                    }
                    if (Dialog.this.dialogType.equals("Save")) {
                        Dialog.this.outputFileName = Dialog.this.getSaveFileNameFromDialog(Dialog.this.vwr, Dialog.this.inputFileName, null);
                        return;
                    }
                    if (Dialog.this.dialogType.startsWith("Save Image")) {
                        Dialog.this.outputFileName = Dialog.this.getImageFileNameFromDialog(Dialog.this.vwr, Dialog.this.inputFileName, Dialog.this.imageType, Dialog.this.imageChoices, Dialog.this.imageExtensions, Dialog.this.qualityJ, Dialog.this.qualityP);
                        return;
                    }
                    Dialog.this.outputFileName = null;
                }
            });
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return this.outputFileName;
    }

    static {
        qualityJPG = 75;
        qualityPNG = 2;
        haveTranslations = false;
        isMac = System.getProperty("os.name", "").startsWith("Mac");
    }

    public static class TypeFilter
    extends FileFilter {
        String thisType;

        TypeFilter(String type) {
            this.thisType = type.toLowerCase();
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory() || this.thisType == null) {
                return true;
            }
            String ext = f.getName();
            int pt = ext.lastIndexOf(".");
            return pt >= 0 && ext.substring(pt + 1).toLowerCase().equals(this.thisType);
        }

        @Override
        public String getDescription() {
            return this.thisType.toUpperCase() + " (*." + this.thisType + ")";
        }
    }

    public class ExportChoiceListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            JComboBox source = (JComboBox)e.getSource();
            File selectedFile = imageChooser.getSelectedFile();
            if (selectedFile == null) {
                selectedFile = Dialog.this.initialFile;
            }
            File newFile = null;
            String newExt = Dialog.this.extensions[source.getSelectedIndex()];
            String name = selectedFile.getName();
            if (name != null && name.endsWith("." + Dialog.this.extension)) {
                name = name.substring(0, name.length() - Dialog.this.extension.length());
                name = name + newExt;
                Dialog.this.initialFile = newFile = new File(selectedFile.getParent(), name);
            }
            Dialog.this.extension = newExt;
            imageChooser.resetChoosableFileFilters();
            imageChooser.addChoosableFileFilter(new TypeFilter(Dialog.this.extension));
            if (newFile != null) {
                imageChooser.setSelectedFile(newFile);
            }
            Dialog.this.choice = (String)source.getSelectedItem();
        }
    }

    public class QualityListener
    implements ChangeListener {
        private boolean isJPEG;
        private JSlider slider;

        public QualityListener(boolean isJPEG, JSlider slider) {
            this.isJPEG = isJPEG;
            this.slider = slider;
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            int value = this.slider.getValue();
            if (this.isJPEG) {
                qualityJPG = value;
                Dialog.this.qPanelJPEG.setBorder(new TitledBorder(GT.i(GT._("JPEG Quality ({0})"), value)));
            } else {
                qualityPNG = value;
                Dialog.this.qPanelPNG.setBorder(new TitledBorder(GT.i(GT._("PNG Quality ({0})"), value)));
            }
        }
    }
}

