/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.text;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class TextKashidaSpaceResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (!(cSSValue instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (!CSSNumericType.PERCENTAGE.equals(cSSNumericValue.getType())) {
            return;
        }
        double d = cSSNumericValue.getValue();
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 100.0) {
            d = 100.0;
        }
        layoutContext.setValue(TextStyleKeys.TEXT_KASHIDA_SPACE, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, d));
    }
}

