/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Arrays;
import java.util.HashMap;
import org.jfree.report.DataSet;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;

public class CachingReportDataFactory
implements ReportDataFactory {
    private HashMap queryCache;
    private ReportDataFactory backend;

    public CachingReportDataFactory(ReportDataFactory reportDataFactory) {
        if (reportDataFactory == null) {
            throw new NullPointerException();
        }
        this.backend = reportDataFactory;
        this.queryCache = new HashMap();
    }

    public void open() {
        this.backend.open();
    }

    public ReportData queryData(String string, DataSet dataSet) throws ReportDataFactoryException {
        try {
            HashMap hashMap = (HashMap)this.queryCache.get(string);
            if (hashMap == null) {
                HashMap<Parameters, ReportData> hashMap2 = new HashMap<Parameters, ReportData>();
                this.queryCache.put(string, hashMap2);
                Parameters parameters = new Parameters(dataSet);
                ReportData reportData = this.backend.queryData(string, parameters);
                hashMap2.put(parameters, reportData);
                reportData.setCursorPosition(0);
                return reportData;
            }
            Parameters parameters = new Parameters(dataSet);
            ReportData reportData = (ReportData)hashMap.get(parameters);
            if (reportData != null) {
                reportData.setCursorPosition(0);
                return reportData;
            }
            ReportData reportData2 = this.backend.queryData(string, parameters);
            hashMap.put(parameters, reportData2);
            reportData2.setCursorPosition(0);
            return reportData2;
        }
        catch (DataSourceException dataSourceException) {
            dataSourceException.printStackTrace();
            throw new ReportDataFactoryException("Failed to query data", (Exception)((Object)dataSourceException));
        }
    }

    public void close() {
        for (HashMap hashMap : this.queryCache.values()) {
            for (ReportData reportData : hashMap.values()) {
                try {
                    reportData.close();
                }
                catch (DataSourceException dataSourceException) {}
            }
        }
        this.backend.close();
    }

    public ReportDataFactory derive() {
        throw new UnsupportedOperationException("The CachingReportDataFactory cannot be derived.");
    }

    private static class Parameters
    implements DataSet {
        private Object[] dataStore;
        private String[] nameStore;
        private Integer hashCode;

        protected Parameters(DataSet dataSet) throws DataSourceException {
            int n = dataSet.getColumnCount();
            this.dataStore = new Object[n];
            this.nameStore = new String[n];
            for (int i = 0; i < n; ++i) {
                this.nameStore[i] = dataSet.getColumnName(i);
                this.dataStore[i] = dataSet.get(i);
            }
        }

        public int getColumnCount() throws DataSourceException {
            return this.dataStore.length;
        }

        public String getColumnName(int n) throws DataSourceException {
            return this.nameStore[n];
        }

        public Object get(int n) throws DataSourceException {
            return this.dataStore[n];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Parameters parameters = (Parameters)object;
            if (!Arrays.equals(this.dataStore, parameters.dataStore)) {
                return false;
            }
            return Arrays.equals(this.nameStore, parameters.nameStore);
        }

        public synchronized int hashCode() {
            Object object;
            int n;
            if (this.hashCode != null) {
                return this.hashCode;
            }
            int n2 = 0;
            for (n = 0; n < this.dataStore.length; ++n) {
                object = this.dataStore[n];
                if (object != null) {
                    n2 = n2 * 23 + object.hashCode();
                    continue;
                }
                n2 *= 23;
            }
            for (n = 0; n < this.nameStore.length; ++n) {
                object = this.nameStore[n];
                if (object != null) {
                    n2 = n2 * 23 + object.hashCode();
                    continue;
                }
                n2 *= 23;
            }
            this.hashCode = new Integer(n2);
            return n2;
        }
    }
}

