/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.EscapeUserArgs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VisualCppCompilerArgsTransformer<T extends NativeCompileSpec>
implements ArgsTransformer<T> {
    VisualCppCompilerArgsTransformer() {
    }

    public List<String> transform(T spec) {
        ArrayList args = Lists.newArrayList();
        this.addToolSpecificArgs(spec, args);
        this.addMacroArgs(spec, args);
        this.addUserArgs(spec, args);
        this.addIncludeArgs(spec, args);
        return args;
    }

    private void addUserArgs(T spec, List<String> args) {
        args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
    }

    protected void addToolSpecificArgs(T spec, List<String> args) {
        args.add(this.getLanguageOption());
        args.add("/nologo");
        args.add("/c");
    }

    protected void addIncludeArgs(T spec, List<String> args) {
        for (File file : spec.getIncludeRoots()) {
            args.add("/I" + file.getAbsolutePath());
        }
    }

    protected void addMacroArgs(T spec, List<String> args) {
        for (String macroArg : new MacroArgsConverter().transform(spec.getMacros())) {
            args.add(EscapeUserArgs.escapeUserArg("/D" + macroArg));
        }
    }

    protected String getLanguageOption() {
        return "";
    }
}

