/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.AnyDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonIdleTimeoutExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonRegistryUnavailableExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonServices;

public class ForegroundDaemonAction
implements Runnable {
    private final ServiceRegistry loggingRegistry;
    private final DaemonServerConfiguration configuration;

    public ForegroundDaemonAction(ServiceRegistry loggingRegistry, DaemonServerConfiguration configuration) {
        this.loggingRegistry = loggingRegistry;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LoggingManagerInternal loggingManager = this.loggingRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.start();
        DaemonServices daemonServices = new DaemonServices(this.configuration, this.loggingRegistry, loggingManager, new DefaultClassPath(new File[0]));
        Daemon daemon = daemonServices.get(Daemon.class);
        daemon.start();
        try {
            daemonServices.get(DaemonRegistry.class).markIdle(daemon.getAddress());
            daemon.stopOnExpiration(this.initializeExpirationStrategy(this.configuration), this.configuration.getPeriodicCheckIntervalMs());
        }
        finally {
            daemon.stop();
        }
    }

    private DaemonExpirationStrategy initializeExpirationStrategy(DaemonServerConfiguration config) {
        DaemonIdleTimeoutExpirationStrategy timeoutStrategy = new DaemonIdleTimeoutExpirationStrategy(config.getIdleTimeout(), TimeUnit.MILLISECONDS);
        DaemonRegistryUnavailableExpirationStrategy registryUnavailableStrategy = new DaemonRegistryUnavailableExpirationStrategy();
        return new AnyDaemonExpirationStrategy((List<DaemonExpirationStrategy>)ImmutableList.of((Object)timeoutStrategy, (Object)registryUnavailableStrategy));
    }
}

