/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.ClassFoldersCreator;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.ProjectDependencyBuilder;
import org.gradle.plugins.ide.eclipse.model.internal.SourceFoldersCreator;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathFactory {
    private final ClasspathEntryBuilder outputCreator = new ClasspathEntryBuilder(){

        @Override
        public void update(List<ClasspathEntry> entries, EclipseClasspath eclipseClasspath) {
            entries.add(new Output(eclipseClasspath.getProject().relativePath((Object)eclipseClasspath.getDefaultOutputDir())));
        }
    };
    private final ClasspathEntryBuilder containersCreator = new ClasspathEntryBuilder(){

        @Override
        public void update(List<ClasspathEntry> entries, EclipseClasspath eclipseClasspath) {
            for (String container : eclipseClasspath.getContainers()) {
                Container entry = new Container(container);
                entries.add(entry);
            }
        }
    };
    private final ClasspathEntryBuilder projectDependenciesCreator = new ClasspathEntryBuilder(){

        @Override
        public void update(List<ClasspathEntry> entries, EclipseClasspath eclipseClasspath) {
            Collection<IdeProjectDependency> projectDependencies = ClasspathFactory.this.dependenciesExtractor.extractProjectDependencies(eclipseClasspath.getProject(), eclipseClasspath.getPlusConfigurations(), eclipseClasspath.getMinusConfigurations());
            for (IdeProjectDependency projectDependency : projectDependencies) {
                entries.add(new ProjectDependencyBuilder().build(projectDependency));
            }
        }
    };
    private final ClasspathEntryBuilder librariesCreator = new ClasspathEntryBuilder(){

        @Override
        public void update(List<ClasspathEntry> entries, EclipseClasspath classpath) {
            Collection<IdeExtendedRepoFileDependency> repoFileDependencies = ClasspathFactory.this.dependenciesExtractor.extractRepoFileDependencies(classpath.getProject().getDependencies(), classpath.getPlusConfigurations(), classpath.getMinusConfigurations(), classpath.isDownloadSources(), classpath.isDownloadJavadoc());
            for (IdeExtendedRepoFileDependency dependency : repoFileDependencies) {
                entries.add(ClasspathFactory.createLibraryEntry(dependency.getFile(), dependency.getSourceFile(), dependency.getJavadocFile(), dependency.getDeclaredConfiguration(), classpath, dependency.getId()));
            }
            Collection<IdeLocalFileDependency> localFileDependencies = ClasspathFactory.this.dependenciesExtractor.extractLocalFileDependencies(classpath.getPlusConfigurations(), classpath.getMinusConfigurations());
            for (IdeLocalFileDependency it : localFileDependencies) {
                entries.add(ClasspathFactory.createLibraryEntry(it.getFile(), null, null, it.getDeclaredConfiguration(), classpath, null));
            }
        }
    };
    private final SourceFoldersCreator sourceFoldersCreator = new SourceFoldersCreator();
    private final IdeDependenciesExtractor dependenciesExtractor = new IdeDependenciesExtractor();
    private final ClassFoldersCreator classFoldersCreator = new ClassFoldersCreator();

    public List<ClasspathEntry> createEntries(EclipseClasspath classpath) {
        ArrayList entries = Lists.newArrayList();
        this.outputCreator.update(entries, classpath);
        this.sourceFoldersCreator.populateForClasspath(entries, classpath);
        this.containersCreator.update(entries, classpath);
        if (classpath.isProjectDependenciesOnly()) {
            this.projectDependenciesCreator.update(entries, classpath);
        } else {
            this.projectDependenciesCreator.update(entries, classpath);
            this.librariesCreator.update(entries, classpath);
            entries.addAll(this.classFoldersCreator.create(classpath));
        }
        return entries;
    }

    public Collection<UnresolvedIdeRepoFileDependency> getUnresolvedDependencies(EclipseClasspath classpath) {
        return this.dependenciesExtractor.unresolvedExternalDependencies(classpath.getPlusConfigurations(), classpath.getMinusConfigurations());
    }

    private static AbstractLibrary createLibraryEntry(File binary, File source, File javadoc, final String declaredConfigurationName, EclipseClasspath classpath, ModuleVersionIdentifier id) {
        FileReferenceFactory referenceFactory = classpath.getFileReferenceFactory();
        FileReference binaryRef = referenceFactory.fromFile(binary);
        FileReference sourceRef = referenceFactory.fromFile(source);
        FileReference javadocRef = referenceFactory.fromFile(javadoc);
        final AbstractLibrary out = binaryRef.isRelativeToPathVariable() ? new Variable(binaryRef) : new Library(binaryRef);
        out.setJavadocPath(javadocRef);
        out.setSourcePath(sourceRef);
        out.setExported(false);
        DeprecationLogger.whileDisabled((Runnable)new Runnable(){

            public void run() {
                out.setDeclaredConfigurationName(declaredConfigurationName);
            }
        });
        out.setModuleVersion(id);
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClasspathEntryBuilder {
        public void update(List<ClasspathEntry> var1, EclipseClasspath var2);
    }
}

