/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Factory;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.repository.GradlePluginPortal;
import org.gradle.plugin.repository.IvyPluginRepository;
import org.gradle.plugin.repository.MavenPluginRepository;
import org.gradle.plugin.repository.internal.DefaultGradlePluginPortal;
import org.gradle.plugin.repository.internal.DefaultIvyPluginRepository;
import org.gradle.plugin.repository.internal.DefaultMavenPluginRepository;
import org.gradle.plugin.repository.internal.PluginRepositoryFactory;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRepositoryFactory
implements PluginRepositoryFactory {
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;
    private final Factory<DependencyResolutionServices> dependencyResolutionServicesFactory;
    private final VersionSelectorScheme versionSelectorScheme;
    private final PluginResolutionServiceResolver pluginResolutionServiceResolver;
    private final Instantiator instantiator;

    public DefaultPluginRepositoryFactory(PluginResolutionServiceResolver pluginResolutionServiceResolver, Factory<DependencyResolutionServices> dependencyResolutionServicesFactory, VersionSelectorScheme versionSelectorScheme, Instantiator instantiator, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        this.pluginResolutionServiceResolver = pluginResolutionServiceResolver;
        this.instantiator = instantiator;
        this.dependencyResolutionServicesFactory = dependencyResolutionServicesFactory;
        this.versionSelectorScheme = versionSelectorScheme;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
    }

    public MavenPluginRepository maven(Action<? super MavenPluginRepository> configurationAction, FileResolver fileResolver) {
        AuthenticationContainer authenticationContainer = this.makeAuthenticationContainer(this.instantiator, this.authenticationSchemeRegistry);
        AuthenticationSupporter delegate = new AuthenticationSupporter(this.instantiator, authenticationContainer);
        DefaultMavenPluginRepository mavenPluginRepository = (DefaultMavenPluginRepository)this.instantiator.newInstance(DefaultMavenPluginRepository.class, new Object[]{fileResolver, this.dependencyResolutionServicesFactory.create(), this.versionSelectorScheme, delegate});
        configurationAction.execute((Object)mavenPluginRepository);
        return mavenPluginRepository;
    }

    public IvyPluginRepository ivy(Action<? super IvyPluginRepository> configurationAction, FileResolver fileResolver) {
        AuthenticationContainer authenticationContainer = this.makeAuthenticationContainer(this.instantiator, this.authenticationSchemeRegistry);
        AuthenticationSupporter delegate = new AuthenticationSupporter(this.instantiator, authenticationContainer);
        DefaultIvyPluginRepository ivyPluginRepository = (DefaultIvyPluginRepository)this.instantiator.newInstance(DefaultIvyPluginRepository.class, new Object[]{fileResolver, this.dependencyResolutionServicesFactory.create(), this.versionSelectorScheme, delegate});
        configurationAction.execute((Object)ivyPluginRepository);
        return ivyPluginRepository;
    }

    public GradlePluginPortal gradlePluginPortal() {
        return new DefaultGradlePluginPortal(this.pluginResolutionServiceResolver);
    }

    private AuthenticationContainer makeAuthenticationContainer(Instantiator instantiator, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        DefaultAuthenticationContainer container = (DefaultAuthenticationContainer)instantiator.newInstance(DefaultAuthenticationContainer.class, new Object[]{instantiator});
        for (Map.Entry e : authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            container.registerBinding((Class)e.getKey(), (Class)e.getValue());
        }
        return container;
    }
}

