/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.commons.Remapper;

class ImplementationDependencyRelocator
extends Remapper {
    private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+)");

    ImplementationDependencyRelocator() {
    }

    public String map(String name) {
        String relocated;
        String value = name;
        String prefix = "";
        Matcher m = this.classPattern.matcher(name);
        if (m.matches()) {
            prefix = m.group(1) + "L";
            name = m.group(2);
        }
        if ((relocated = this.maybeRelocateResource(name)) == null) {
            return value;
        }
        return prefix.concat(relocated);
    }

    public String maybeRelocateResource(String resource) {
        if (resource.startsWith("META-INF") || resource.startsWith("org/gradle") || resource.startsWith("java") || resource.startsWith("javax") || resource.startsWith("groovy") || resource.startsWith("groovyjarjarantlr") || resource.startsWith("net/rubygrapefruit") || resource.startsWith("org/codehaus/groovy") || resource.startsWith("org/apache/tools/ant") || resource.startsWith("org/apache/commons/logging") || resource.startsWith("org/slf4j") || resource.startsWith("org/apache/log4j") || resource.startsWith("org/apache/xerces") || resource.startsWith("org/cyberneko/html") || resource.startsWith("org/w3c/dom") || resource.startsWith("org/xml/sax")) {
            return null;
        }
        return "org/gradle/internal/impldep/" + resource;
    }

    public boolean keepOriginalResource(String resource) {
        return resource == null || this.maybeRelocateResource(resource) == null || !resource.startsWith("com/sun/jna");
    }

    public ClassLiteralRemapping maybeRemap(String literal) {
        if (literal.startsWith("class$")) {
            String className = literal.substring(6).replace('$', '.');
            String replacement = this.maybeRelocateResource(className.replace('.', '/'));
            if (replacement == null) {
                return null;
            }
            String fieldNameReplacement = "class$" + replacement.replace('/', '$');
            return new ClassLiteralRemapping(className, replacement, fieldNameReplacement);
        }
        return null;
    }

    public static class ClassLiteralRemapping {
        private final String literal;
        private final String literalReplacement;
        private final String fieldNameReplacement;

        public ClassLiteralRemapping(String literal, String literalReplacement, String fieldNameReplacement) {
            this.literal = literal;
            this.literalReplacement = literalReplacement;
            this.fieldNameReplacement = fieldNameReplacement;
        }

        public String getLiteral() {
            return this.literal;
        }

        public String getLiteralReplacement() {
            return this.literalReplacement;
        }

        public String getFieldNameReplacement() {
            return this.fieldNameReplacement;
        }
    }
}

