/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.internal.FindBugsReportsImpl;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsClasspathValidator;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsResult;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpecBuilder;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsWorkerManager;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.internal.worker.WorkerProcessFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugs
extends SourceTask
implements VerificationTask,
Reporting<FindBugsReports>,
GroovyObject {
    @SkipWhenEmpty
    @InputFiles
    private FileCollection classes;
    @InputFiles
    private FileCollection classpath;
    @InputFiles
    private FileCollection findbugsClasspath;
    @InputFiles
    private FileCollection pluginClasspath;
    private boolean ignoreFailures;
    @Input
    @Optional
    private String effort;
    @Input
    @Optional
    private String reportLevel;
    @Input
    @Optional
    private String maxHeapSize;
    @Input
    @Optional
    private Collection<String> visitors;
    @Input
    @Optional
    private Collection<String> omitVisitors;
    @Incubating
    @Nested
    @Optional
    private TextResource includeFilterConfig;
    @Incubating
    @Nested
    @Optional
    private TextResource excludeFilterConfig;
    @Incubating
    @Nested
    @Optional
    private TextResource excludeBugsFilterConfig;
    @Input
    @Optional
    private Collection<String> extraArgs;
    @Nested
    private final FindBugsReportsImpl reports;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public FindBugs() {
        MetaClass metaClass;
        List list;
        List list2;
        List list3;
        this.visitors = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.omitVisitors = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.extraArgs = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = this.getInstantiator().newInstance(FindBugsReportsImpl.class, new Object[]{this});
        this.reports = (FindBugsReportsImpl)ScriptBytecodeAdapter.castToType((Object)object, FindBugsReportsImpl.class);
    }

    @Inject
    public Instantiator getInstantiator() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @Inject
    public WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public FindBugsReports getReports() {
        return this.reports;
    }

    public FindBugsReports reports(Closure closure) {
        return (FindBugsReports)ScriptBytecodeAdapter.castToType((Object)this.reports.configure(closure), FindBugsReports.class);
    }

    public File getIncludeFilter() {
        TextResource textResource = this.getIncludeFilterConfig();
        return textResource != null ? textResource.asFile() : null;
    }

    public void setIncludeFilter(File filter) {
        this.setIncludeFilterConfig(((ProjectInternal)this.getProject()).getResources().getText().fromFile((Object)filter));
    }

    public File getExcludeFilter() {
        TextResource textResource = this.getExcludeFilterConfig();
        return textResource != null ? textResource.asFile() : null;
    }

    public void setExcludeFilter(File filter) {
        this.setExcludeFilterConfig(((ProjectInternal)this.getProject()).getResources().getText().fromFile((Object)filter));
    }

    public File getExcludeBugsFilter() {
        TextResource textResource = this.getExcludeBugsFilterConfig();
        return textResource != null ? textResource.asFile() : null;
    }

    public void setExcludeBugsFilter(File filter) {
        this.setExcludeBugsFilterConfig(((ProjectInternal)this.getProject()).getResources().getText().fromFile((Object)filter));
    }

    @TaskAction
    public void run() {
        new FindBugsClasspathValidator(JavaVersion.current()).validateClasspath((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(FindBugs.class, (Object)this.getFindbugsClasspath().getFiles(), (String)"name"), Iterable.class));
        FindBugsSpec spec = this.generateSpec();
        FindBugsWorkerManager manager = new FindBugsWorkerManager();
        this.getLogging().captureStandardOutput(LogLevel.DEBUG);
        this.getLogging().captureStandardError(LogLevel.DEBUG);
        FindBugsResult result = manager.runWorker(this.getProject().getProjectDir(), this.getWorkerProcessBuilderFactory(), this.getFindbugsClasspath(), spec);
        this.evaluateResult(result);
    }

    FindBugsSpec generateSpec() {
        FindBugsSpecBuilder specBuilder = new FindBugsSpecBuilder(this.getClasses()).withPluginsList(this.getPluginClasspath()).withSources((FileCollection)this.getSource()).withClasspath(this.getClasspath()).withDebugging(this.getLogger().isDebugEnabled()).withEffort(this.getEffort()).withReportLevel(this.getReportLevel()).withMaxHeapSize(this.getMaxHeapSize()).withVisitors(this.getVisitors()).withOmitVisitors(this.getOmitVisitors()).withExcludeFilter(this.getExcludeFilter()).withIncludeFilter(this.getIncludeFilter()).withExcludeBugsFilter(this.getExcludeBugsFilter()).withExtraArgs(this.getExtraArgs()).configureReports(this.getReports());
        return specBuilder.build();
    }

    void evaluateResult(FindBugsResult result) {
        if (DefaultTypeTransformation.booleanUnbox((Object)result.getException())) {
            throw (Throwable)new GradleException("FindBugs encountered an error. Run with --debug to get more information.", result.getException());
        }
        if (result.getErrorCount() != 0) {
            throw (Throwable)new GradleException("FindBugs encountered an error. Run with --debug to get more information.");
        }
        if (result.getBugCount() != 0) {
            String message = "FindBugs rule violations were found.";
            SingleFileReport report = (SingleFileReport)ScriptBytecodeAdapter.castToType((Object)this.reports.getFirstEnabled(), SingleFileReport.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)report)) {
                String string;
                String reportUrl = new ConsoleRenderer().asClickableFileUrl(report.getDestination());
                message = string = StringGroovyMethods.plus((String)message, (CharSequence)new GStringImpl(new Object[]{reportUrl}, new String[]{" See the report at: ", ""}));
            }
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
            } else {
                throw (Throwable)new GradleException(message);
            }
        }
    }

    public FindBugs extraArgs(Iterable<String> arguments) {
        String argument = null;
        Iterator<String> iterator = arguments.iterator();
        while (iterator.hasNext()) {
            argument = ShortTypeHandling.castToString((Object)iterator.next());
            this.extraArgs.add(argument);
        }
        return this;
    }

    public FindBugs extraArgs(String ... arguments) {
        DefaultGroovyMethods.addAll(this.extraArgs, Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)arguments, Object[].class)));
        return this;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != FindBugs.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public FileCollection getClasses() {
        return this.classes;
    }

    public void setClasses(FileCollection fileCollection) {
        this.classes = fileCollection;
    }

    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection fileCollection) {
        this.classpath = fileCollection;
    }

    public FileCollection getFindbugsClasspath() {
        return this.findbugsClasspath;
    }

    public void setFindbugsClasspath(FileCollection fileCollection) {
        this.findbugsClasspath = fileCollection;
    }

    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection fileCollection) {
        this.pluginClasspath = fileCollection;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean bl) {
        this.ignoreFailures = bl;
    }

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String string) {
        this.effort = string;
    }

    public String getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(String string) {
        this.reportLevel = string;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String string) {
        this.maxHeapSize = string;
    }

    public Collection<String> getVisitors() {
        return this.visitors;
    }

    public void setVisitors(Collection<String> collection) {
        this.visitors = collection;
    }

    public Collection<String> getOmitVisitors() {
        return this.omitVisitors;
    }

    public void setOmitVisitors(Collection<String> collection) {
        this.omitVisitors = collection;
    }

    public TextResource getIncludeFilterConfig() {
        return this.includeFilterConfig;
    }

    public void setIncludeFilterConfig(TextResource textResource) {
        this.includeFilterConfig = textResource;
    }

    public TextResource getExcludeFilterConfig() {
        return this.excludeFilterConfig;
    }

    public void setExcludeFilterConfig(TextResource textResource) {
        this.excludeFilterConfig = textResource;
    }

    public TextResource getExcludeBugsFilterConfig() {
        return this.excludeBugsFilterConfig;
    }

    public void setExcludeBugsFilterConfig(TextResource textResource) {
        this.excludeBugsFilterConfig = textResource;
    }

    public Collection<String> getExtraArgs() {
        return this.extraArgs;
    }

    public void setExtraArgs(Collection<String> collection) {
        this.extraArgs = collection;
    }
}

